<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Register - MNC Trade Syariah</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-world: #228B22; /* hijau daun */
      --secondary-world: #32CD32; /* hijau terang lembut */
      --text-dark: #0B3D0B;
      --bg-light: #ffffff;
      --bg-accent: #F0FFF0;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: radial-gradient(circle at top, var(--bg-accent) 0%, var(--bg-light) 70%, #ffffff 100%);
      color: var(--text-dark);
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    .page-wraper {
      width: 100%;
      max-width: 400px;
      background: rgba(50, 205, 50, 0.05);
      border-radius: 20px;
      backdrop-filter: blur(8px);
      box-shadow: 0 0 20px rgba(34, 139, 34, 0.2);
      padding: 30px 25px;
      text-align: center;
    }

    .header-title {
      font-size: 24px;
      font-weight: 600;
      color: var(--primary-world);
      margin-bottom: 15px;
    }

    .welcome-text {
      margin-bottom: 20px;
      color: var(--text-dark);
      font-size: 16px;
      line-height: 1.5;
      text-align: center;
    }

    .tab-navigation {
      display: flex;
      margin-bottom: 25px;
      border-radius: 12px;
      overflow: hidden;
      background: rgba(34, 139, 34, 0.08);
      box-shadow: inset 0 0 10px rgba(34, 139, 34, 0.2);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      background: transparent;
      color: var(--text-dark);
      border: none;
      transition: all 0.3s ease;
    }

    .tab.active {
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: #ffffff;
      box-shadow: 0 0 10px rgba(34, 139, 34, 0.3);
    }

    .input-group {
      display: flex;
      align-items: center;
      background: rgba(34, 139, 34, 0.08);
      border: 1px solid rgba(34, 139, 34, 0.15);
      border-radius: 14px;
      margin-bottom: 20px;
      padding: 0 10px;
      transition: all 0.3s ease;
    }

    .input-group:focus-within {
      border-color: var(--primary-world);
      box-shadow: 0 0 8px rgba(34, 139, 34, 0.4);
      transform: scale(1.01);
    }

    .input-icon {
      width: 40px;
      text-align: center;
      color: var(--primary-world);
      font-size: 18px;
    }

    .input-field {
      flex: 1;
      padding: 12px 10px;
      border: none;
      background: transparent;
      color: var(--text-dark);
      font-size: 15px;
    }

    .input-field::placeholder {
      color: rgba(11, 61, 11, 0.6);
    }

    .input-field:focus {
      outline: none;
    }

    .captcha-container {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 22px;
    }

    .captcha-box {
      background: #0c2238;
      border-radius: 12px;
      padding: 10px 20px;
      font-size: 22px;
      font-weight: bold;
      letter-spacing: 5px;
      color: var(--primary-world);
      text-shadow: 0 0 6px rgba(34, 139, 34, 0.8);
      user-select: none;
      box-shadow: inset 0 0 8px rgba(34, 139, 34, 0.3);
    }

    .refresh-btn {
      background: transparent;
      border: none;
      color: var(--primary-world);
      font-size: 20px;
      cursor: pointer;
      transition: 0.3s;
    }

    .refresh-btn:hover {
      transform: rotate(180deg);
      color: var(--secondary-world);
    }

    .error-message {
      color: #ff4e4e;
      text-align: center;
      margin-top: -10px;
      margin-bottom: 10px;
      font-weight: 600;
      display: none;
    }

    .submit-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: #ffffff;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      box-shadow: 0 0 15px rgba(34, 139, 34, 0.2);
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, var(--secondary-world), var(--primary-world));
      box-shadow: 0 0 25px rgba(34, 139, 34, 0.4);
      transform: scale(1.02);
    }

    @media (max-width: 450px) {
      .page-wraper {
        padding: 20px 15px;
      }
    }
  </style>
</head>

<body>

  <div class="page-wraper">
    <h1 class="header-title">Register</h1>

    <div class="welcome-text">
      Silakan daftar akun <strong>MNC Trade Syariah</strong> Anda.<br>
      Bersama kita bangun masa depan lebih cerah lagi.
    </div>

    <div class="tab-navigation">
      <a href="<?php echo e(route('login')); ?>" class="tab">Log In</a>
      <button class="tab active">Register</button>
    </div>

    <form id="registerForm" action="<?php echo e(route('register')); ?>" method="POST">
      <?php echo csrf_field(); ?>

      <div class="input-group">
        <i class="fas fa-user input-icon"></i>
        <input type="text" name="name" class="input-field" placeholder="Username" required>
      </div>

      <div class="input-group">
        <i class="fas fa-mobile-alt input-icon"></i>
        <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
      </div>

      <div class="input-group">
        <i class="fas fa-lock input-icon"></i>
        <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
      </div>

      <div class="input-group">
        <i class="fas fa-lock input-icon"></i>
        <input type="password" name="password_confirmation" class="input-field"
          placeholder="Konfirmasi Kata Sandi" required>
      </div>

      <div class="input-group">
        <i class="fas fa-ticket-alt input-icon"></i>
        <input type="text" id="referralCode" name="ref_id" class="input-field" placeholder="Kode Refferal">
      </div>

      <div class="captcha-container">
        <div id="captchaBox" class="captcha-box"></div>
        <button type="button" class="refresh-btn" onclick="generateCaptcha()">
          <i class="fas fa-sync-alt"></i>
        </button>
      </div>

      <div class="input-group">
        <i class="fas fa-key input-icon"></i>
        <input type="text" name="otp" id="otpInput" class="input-field"
          placeholder="Masukkan Kode OTP dari Gambar" required>
      </div>

      <div id="errorMsg" class="error-message">Kode OTP salah!</div>

      <button type="submit" class="submit-btn">Register</button>
    </form>
  </div>

  <script>
    function generateCaptcha() {
      const captchaBox = document.getElementById("captchaBox");
      const chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
      let otp = "";
      for (let i = 0; i < 6; i++) otp += chars.charAt(Math.floor(Math.random() * chars.length));
      captchaBox.textContent = otp;
      captchaBox.dataset.code = otp;
    }
    document.addEventListener("DOMContentLoaded", generateCaptcha);

    document.getElementById("registerForm").addEventListener("submit", function (e) {
      const userOtp = document.getElementById("otpInput").value.trim().toUpperCase();
      const correctOtp = document.getElementById("captchaBox").dataset.code;
      const errorMsg = document.getElementById("errorMsg");

      if (userOtp !== correctOtp) {
        e.preventDefault();
        errorMsg.style.display = "block";
        document.getElementById("otpInput").style.border = "1px solid #ff4e4e";
        generateCaptcha();
      } else {
        errorMsg.style.display = "none";
      }
    });

    document.addEventListener("DOMContentLoaded", function () {
      const urlParams = new URLSearchParams(window.location.search);
      const inviteCode = urlParams.get("inviteCode");
      if (inviteCode) {
        document.getElementById("referralCode").value = inviteCode;
      }
    });
  </script>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>