<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Gift Code</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root {
  --primary-green: #66cc88;
  --light-green: #b6f2c9;
  --background: #f5f7f5;
  --text-dark: #1a1a1a;
  --text-light: #555;
  --white: #ffffff;
}

/* RESET */
* { margin:0; padding:0; box-sizing:border-box; }
body {
  font-family:'Poppins',sans-serif;
  background: var(--background);
  color: var(--text-dark);
  overflow-x:hidden;
  min-height:100vh;
}

/* MAIN CONTAINER */
.main-container {
  max-width:600px;
  margin:0 auto;
  min-height:100vh;
  background: var(--white);
  border-radius:20px;
  box-shadow:0 0 20px rgba(102,204,136,0.25);
  position:relative;
  padding-bottom:80px;
  overflow:hidden;
  animation:fadeIn 0.8s ease-in-out;
}
@keyframes fadeIn {
  from{opacity:0;transform:translateY(10px);}
  to{opacity:1;transform:translateY(0);}
}

/* HEADER */
.header {
  background: var(--primary-green);
  color:#fff;
  padding:15px 20px;
  text-align:center;
  position:relative;
  font-weight:600;
  font-size:1.2rem;
  border-top-left-radius:20px;
  border-top-right-radius:20px;
  box-shadow:0 2px 10px rgba(102,204,136,0.3);
}
.back-btn {
  position:absolute;
  left:20px;
  font-size:28px;
  cursor:pointer;
  color:#fff;
}

/* CARD */
.card {
  background: var(--white);
  border-radius:16px;
  padding:25px;
  margin:20px;
  box-shadow:0 3px 15px rgba(102,204,136,0.15);
  text-align:center;
}

/* REDEEM ICON */
.redeem-icon {
  width:90px;
  height:90px;
  margin:0 auto 20px;
  border-radius:50%;
  background: radial-gradient(circle, #66cc8833, #66cc8888);
  display:flex;
  align-items:center;
  justify-content:center;
  box-shadow:0 0 20px rgba(102,204,136,0.4);
  animation:glow 3s infinite alternate;
}
.redeem-icon img {
  width:60%;
  filter: drop-shadow(0 0 8px rgba(102,204,136,0.8));
}
@keyframes glow {
  from { box-shadow:0 0 10px rgba(102,204,136,0.3); transform:scale(1);}
  to { box-shadow:0 0 25px rgba(102,204,136,0.6); transform:scale(1.05);}
}

.card h3 {
  font-size:20px;
  font-weight:600;
  margin-bottom:8px;
  color: var(--primary-green);
}
.card p {
  color: var(--text-light);
  margin-bottom:25px;
}

/* INPUT */
.form-control {
  width:100%;
  height:55px;
  padding:0 20px;
  border-radius:12px;
  border:1px solid rgba(102,204,136,0.3);
  background: rgba(255,255,255,0.9);
  font-size:16px;
  font-weight:500;
  text-align:center;
  color:var(--text-dark);
  transition:0.3s;
}
.form-control:focus {
  outline:none;
  border-color: var(--primary-green);
  box-shadow:0 0 10px rgba(102,204,136,0.3);
}

/* BUTTON */
.submit-btn {
  width:100%;
  padding:14px;
  margin-top:15px;
  background: var(--primary-green);
  border:none;
  border-radius:12px;
  font-weight:600;
  color:#fff;
  cursor:pointer;
  box-shadow:0 0 20px rgba(102,204,136,0.25);
  transition:all 0.3s ease;
}
.submit-btn:hover {
  box-shadow:0 0 25px rgba(102,204,136,0.5);
  transform:scale(1.02);
}

/* INSTRUCTION */
.instructions-card {
  text-align:left;
}
.instructions-card h4 {
  font-size:16px;
  font-weight:600;
  margin-bottom:15px;
  color: var(--primary-green);
}
.instructions-card ul {
  list-style:none;
  color: var(--text-light);
}
.instructions-card li {
  margin-bottom:10px;
  padding-left:25px;
  position:relative;
}
.instructions-card li::before {
  content:'🎁';
  position:absolute;
  left:0;
  top:0;
}

/* ANIMASI */
@keyframes fadeUp {
  from {opacity:0; transform:translateY(15px);}
  to {opacity:1; transform:translateY(0);}
}
</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    Gift Code
  </div>

  <div class="card redeem-card">
      <div class="redeem-icon">
        <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%2366cc88" alt="gift">
      </div>
      <h3>Redeem Gift Code</h3>
      <p>Masukkan kode hadiah kamu di bawah ini untuk klaim bonus menarik!</p>

      <form action="<?php echo e(route('submitBonusCode')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <input type="text" class="form-control" name="bonus_code" placeholder="Masukkan Kode Hadiah" required>
          <button class="submit-btn" type="submit">Klaim Sekarang</button>
      </form>
  </div>

  <div class="card instructions-card">
      <h4>🎀 Cara Mendapatkan Kode Hadiah:</h4>
      <ul>
          <li>Ikuti channel Telegram resmi kami untuk mendapatkan kode spesial.</li>
          <li>Setiap kode hanya bisa digunakan satu kali.</li>
          <li>Pastikan penulisan kode benar tanpa spasi tambahan.</li>
          <li>Hubungi layanan pelanggan jika mengalami kendala.</li>
      </ul>
  </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/mnctrad1/public_html/resources/views/app/main/promo.blade.php ENDPATH**/ ?>