<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
<title>Home</title>

<style>
:root {
  --primary-maroon:#7F1D1D;
  --deep-maroon:#450A0A;
  --light-maroon:#991B1B;
  --dark-bg:#0B0B0B;
  --card:#141414;
  --text:#F5F5F5;
  --muted:#CFCFCF;
  --glow:rgba(127,29,29,.6);
}

*{margin:0;padding:0;box-sizing:border-box}
body{
  font-family:Poppins,sans-serif;
  background:radial-gradient(circle at top,#1a1a1a,#000);
  color:var(--text);
}

.main-container{
  max-width:600px;
  margin:auto;
  min-height:100vh;
  background:#0e0e0e;
  box-shadow:0 0 40px var(--glow);
  padding-bottom:90px;
}

.header{
  background:linear-gradient(135deg,var(--deep-maroon),var(--primary-maroon));
  padding:15px;
  text-align:center;
  font-weight:700;
}

/* ===== SLIDER (FIXED) ===== */
.slider-wrapper{
  margin:15px;
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 25px var(--glow);
  background:#000;
}

.slider-container{
  height:180px;
  overflow:hidden;
  background:#000;
}

.slider-track{
  display:flex;
  height:100%;
  transition:1s ease-in-out;
  will-change: transform;
}

.slide{
  flex:0 0 100%;
  display:flex;
  align-items:center;
  justify-content:center;
  background:#000;
}

.slide img{
  width:100%;
  height:100%;
  object-fit:contain;
}

/* DOTS */
.slider-dots{
  display:flex;
  justify-content:center;
  gap:8px;
  padding:6px;
  background:#0e0e0e;
}

.dot{
  width:8px;
  height:8px;
  border-radius:50%;
  background:rgba(255,255,255,.3);
}

.dot.active{
  background:#f87171;
  box-shadow:0 0 8px var(--glow);
}

/* ===== PROFILE CARD ===== */
.profile-action-card{
  margin:15px;
  margin-bottom:6px; /* ðŸ”¥ DIKETATKAN */
  background:linear-gradient(180deg,#1a1a1a,#0d0d0d);
  border-radius:18px;
  box-shadow:0 0 20px var(--glow);
}

.profile-top{
  display:flex;
  gap:12px;
  padding:15px;
  align-items:center;
}

.profile-avatar{
  width:60px;height:60px;border-radius:50%;
  border:2px solid var(--primary-maroon);
}

.profile-id{font-size:13px;color:var(--muted)}
.profile-label{font-size:12px;color:#fca5a5}
.profile-balance{font-size:20px;font-weight:800;color:#fecaca}

.horizontal-divider{height:1px;background:rgba(127,29,29,.4);margin:0 15px}
.vertical-divider{width:1px;background:rgba(127,29,29,.4)}

.action-card{display:flex;height:120px}

.checkin-area,
.right-btn{
  flex:1;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  cursor:pointer;
}

.right-area{flex:1;display:flex;flex-direction:column}
.right-btn{flex-direction:row;gap:8px}

/* ===== TABS KOTAK ===== */
.tabs{
  display:flex;
  gap:10px;
  margin:6px 12px 14px;
  padding:6px;
  background:rgba(127,29,29,.15);
  border-radius:16px;
}

.tab{
  flex:1;
  padding:14px 0;
  background:linear-gradient(180deg,#140909,#0b0505);
  border:1px solid rgba(127,29,29,.45);
  border-radius:14px;
  color:#fecaca;
  font-weight:800;
  letter-spacing:.3px;
  cursor:pointer;
  box-shadow:
    inset 0 0 12px rgba(127,29,29,.35),
    0 0 10px rgba(0,0,0,.6);
  transition:.35s ease;
}

/* HOVER */
.tab:hover{
  transform:translateY(-2px);
  box-shadow:
    0 0 22px rgba(127,29,29,.65),
    inset 0 0 14px rgba(127,29,29,.55);
}

/* ACTIVE */
.tab.active{
  background:linear-gradient(135deg,var(--primary-maroon),var(--light-maroon));
  color:#fff;
  border:1px solid var(--primary-maroon);
  box-shadow:
    0 0 30px rgba(127,29,29,.9),
    inset 0 0 18px rgba(255,255,255,.15);
  transform:scale(1.05);
}


/* ===== PLAN LIST ===== */
.plan-list{
  display:flex;
  flex-direction:column;
  gap:16px;
  padding:0 12px;
}

/* ===== PLAN CARD ===== */
.plan-card{
  background:linear-gradient(180deg,#1a1a1a,#0f0f0f);
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 0 20px var(--glow);
}

/* IMAGE */
.plan-image{
  position:relative;
  height:160px;
}
.plan-image img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* BODY */
.plan-body{
  padding:14px;
}

/* TITLE */
.plan-title{
  font-size:16px;
  font-weight:800;
  color:#fecaca;
  text-align:center;
  margin-bottom:12px;
}

/* GRID INFO */
.plan-info-grid{
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:10px;
  margin-bottom:14px;
}
.info-box{
  background:#0d0d0d;
  border-radius:12px;
  padding:10px 8px;
  text-align:center;
  border:1px solid rgba(127,29,29,.35);
  box-shadow:inset 0 0 8px rgba(127,29,29,.35);
}
.info-box span{
  font-size:11px;
  color:var(--muted);
}
.info-box strong{
  display:block;
  margin-top:4px;
  font-size:14px;
  font-weight:800;
  color:#fff;
}

/* BUTTON */
.buy-btn{
  width:100%;
  padding:12px;
  border-radius:50px;
  border:none;
  background:linear-gradient(135deg,var(--primary-maroon),var(--light-maroon));
  color:#fff;
  font-weight:800;
  font-size:15px;
  box-shadow:0 0 15px var(--glow);
}
.buy-btn:disabled{
  opacity:.6;
}


</style>
</head>

<body>
<div class="main-container">

<div class="header">Taglichesgeld</div>

<!-- SLIDER -->
<div class="slider-wrapper">
  <div class="slider-container">
    <div id="main-slider" class="slider-track">
      <div class="slide"><img src="/Gemini_Generated_Image_679udo679udo679u (1).png"></div>
      <div class="slide"><img src="/Gemini_Generated_Image_jd5c1ejd5c1ejd5c.png"></div>
      <div class="slide"><img src="/Gemini_Generated_Image_679udo679udo679u (1).png"></div>
    </div>
  </div>
  <div id="slider-dots-container" class="slider-dots"></div>
</div>

<!-- PROFILE -->
<div class="profile-action-card">
  <div class="profile-top">
    <img src="Gemini_Generated_Image_e13o3he13o3he13o.png" class="profile-avatar">
    <div>
      <div class="profile-id">ID : <?php echo e(auth()->user()->phone); ?></div>
      <div class="profile-label">Saldo Akun</div>
      <div class="profile-balance"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>
  </div>

  <div class="horizontal-divider"></div>

  <div class="action-card">
    <div class="checkin-area" onclick="location.href='/checkin'">
      <span>Check-in</span>
    </div>
    <div class="vertical-divider"></div>
    <div class="right-area">
      <div class="right-btn" onclick="openPage('/user/recharge')">Isi Ulang</div>
      <div class="right-btn" onclick="openPage('/withdraw')">Withdraw</div>
    </div>
  </div>
</div>

<script>
function openPage(url){window.location.href=url;}
</script>

</body>
</html>



   <div class="tabs">
  <button class="tab active" onclick="switchTab(event, 'daily-income')">A</button>
  <button class="tab" onclick="switchTab(event, 'welfare-plan')">B</button>
</div>


    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $menu = PackageCategory::get()->toArray();
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">

<div id="daily-income" class="plan-list">
<?php if($packageOne->count() > 0): ?>
<?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
$myVip = \App\Models\Purchase::where('user_id',auth()->id())
    ->where('package_id',$element->id)
    ->where('status','active')
    ->first();
?>

<div class="plan-card">

  <div class="plan-image">
    <img src="<?php echo e(asset($element->photo)); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element->name); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element->price)); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element->daily_limit)); ?></strong>
      </div>
      <div class="info-box">
        <span>Hari</span>
        <strong><?php echo e($element->validity); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element->daily_limit * $element->validity)); ?></strong>
      </div>
    </div>

    <?php if($myVip): ?>
      <button class="buy-btn" disabled>Aktif</button>
    <?php elseif($element->status == 'coming'): ?>
      <button class="buy-btn" disabled>Coming</button>
    <?php else: ?>
      <button class="buy-btn"
        onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">
        Beli Sekarang
      </button>
    <?php endif; ?>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<p style="text-align:center;padding:20px;">No daily income plans available.</p>
<?php endif; ?>
</div>


        <div id="welfare-plan" class="plan-list" style="display:none;">
<?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<div class="plan-card">

  <div class="plan-image">
    <img src="<?php echo e(asset($element['photo'])); ?>">
  </div>

  <div class="plan-body">
    <div class="plan-title"><?php echo e($element['name']); ?></div>

    <div class="plan-info-grid">
      <div class="info-box">
        <span>Harga</span>
        <strong><?php echo e(price($element['price'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Pendapatan / Hari</span>
        <strong><?php echo e(price($element['daily_limit'])); ?></strong>
      </div>
      <div class="info-box">
        <span>Siklus</span>
        <strong><?php echo e($element['validity']); ?> Hari</strong>
      </div>
      <div class="info-box">
        <span>Total Pendapatan</span>
        <strong><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></strong>
      </div>
    </div>

    <button class="buy-btn"
      onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">
      Beli Sekarang
    </button>

  </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

</div>


</div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    const slides=Array.from(slider.children);
    let dots=[];
    slides.forEach((_,i)=>{
        const dot=document.createElement('div');
        dot.classList.add('dot');
        dot.addEventListener('click',()=>goToSlide(i));
        dotsContainer.appendChild(dot);
        dots.push(dot);
    });
    let current=0;
    const goToSlide=(i)=>{
        current=i;
        slider.style.transform=`translateX(-${i*100}%)`;
        dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
    };
    goToSlide(0);
    if(slides.length>1)setInterval(()=>goToSlide((current+1)%slides.length),10000);
});

function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}
</script>
<!-- 🌑 POPUP WHATSAPP - BLACK & MAROON LUXURY THEME -->
<!-- 🌑 POPUP WHATSAPP - BLACK & MAROON LUXURY -->
<style>
.popup-whatsapp{
  position:fixed;
  inset:0;
  background:rgba(5,5,5,.92);
  display:flex;
  justify-content:center;
  align-items:center;
  z-index:999999;
}

.popup-box{
  position:relative;
  background:linear-gradient(145deg,#120808,#2a0f0f);
  border:2px solid rgba(127,29,29,.7);
  border-radius:22px;
  box-shadow:0 0 35px rgba(127,29,29,.65);
  padding:32px 24px 26px;
  width:90%;
  max-width:360px;
  animation:popupUp .45s ease;
}

@keyframes popupUp{
  from{transform:translateY(40px);opacity:0}
  to{transform:translateY(0);opacity:1}
}

/* CLOSE */
.popup-close{
  position:absolute;
  top:10px;
  right:12px;
  width:30px;
  height:30px;
  border-radius:50%;
  background:#2a0f0f;
  border:1px solid rgba(127,29,29,.7);
  color:#FCA5A5;
  font-size:18px;
  cursor:pointer;
}

/* ICON */
.popup-box img{
  width:74px;
  display:block;
  margin:0 auto 14px;
  filter:drop-shadow(0 0 18px rgba(127,29,29,.9));
}

/* TEXT */
.popup-box h3{
  color:#FCA5A5;
  font-weight:800;
  text-align:center;
}
.popup-box p{
  color:#E5E7EB;
  font-size:14px;
  line-height:1.6;
  margin:14px 0 18px;
}

/* ACTIONS */
.popup-actions{
  display:flex;
  gap:10px;
  margin-bottom:14px;
}
.popup-actions button{
  flex:1;
  border-radius:50px;
  padding:11px 0;
  font-weight:700;
  border:1px solid rgba(127,29,29,.8);
  cursor:pointer;
}

/* BUTTONS */
.btn-group{
  background:linear-gradient(135deg,#7F1D1D,#450A0A);
  color:#FEE2E2;
}
.btn-cs{
  background:linear-gradient(135deg,#064E3B,#022C22);
  color:#ECFDF5;
  border-color:rgba(16,185,129,.7);
}

/* DOWNLOAD */
.download-app{
  display:block;
  text-align:center;
  margin-top:8px;
  padding:11px;
  border-radius:14px;
  font-weight:700;
  text-decoration:none;
  color:#FEF3C7;
  background:linear-gradient(135deg,#78350F,#451A03);
  border:1px solid rgba(251,191,36,.8);
  box-shadow:0 0 18px rgba(251,191,36,.6);
  transition:.35s;
}
.download-app:hover{
  transform:scale(1.05);
  box-shadow:0 0 30px rgba(251,191,36,1);
}
</style>

<script>
function showWhatsAppPopup(){
  if(document.querySelector('.popup-whatsapp')) return;

  const popup=document.createElement("div");
  popup.className="popup-whatsapp";
  popup.innerHTML=`
    <div class="popup-box" id="popupBox">
      <button class="popup-close" id="closePopup">×</button>

      <img src="https://cdn-icons-png.flaticon.com/512/733/733585.png">

      <h3>🎉 BONUS DAFTAR 5.000</h3>
      <p>
        ✅ Bonus pendaftaran <b>Rp 5.000</b><br>
        👥 Referral: 12% • 2% • 1%<br>
        💸 Minimal penarikan <b>Rp 32.000</b><br>
        ✂️ Potongan penarikan <b>10%</b><br><br>
        📲 Gabung Grup WhatsApp resmi<br>
        ☎️ Kendala? Hubungi CS kami
      </p>

      <div class="popup-actions">
        <button class="btn-group" id="joinGroup">Gabung Grup</button>
        <button class="btn-cs" id="callCS">Hubungi CS</button>
      </div>

      <!-- ⬇️ DOWNLOAD APLIKASI -->
      <a 
        href="/Taglichesgeld.apk" 
        class="download-app" 
        download
      >
        ⬇️ Download Aplikasi
      </a>
    </div>
  `;
  document.body.appendChild(popup);

  document.getElementById("joinGroup").onclick=()=>{
    window.open("https://chat.whatsapp.com/Bh7S23cBc7vGZW8EdDFzei","_blank");
    popup.remove();
  };

  document.getElementById("callCS").onclick=()=>{
    window.open("https://wa.me/6281234567890","_blank");
    popup.remove();
  };

  document.getElementById("closePopup").onclick=()=>popup.remove();
}

document.addEventListener("DOMContentLoaded",()=>{
  setTimeout(showWhatsAppPopup,500);
});
</script>

<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>