<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<title>Invite</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>

<style>
:root {
    --primary-green: #3fa072;       /* hijau lembut */
    --secondary-green: #66cc88;     /* hijau muda natural */
    --background-color: #f6f9f7;    /* putih kehijauan lembut */
    --text-color: #1e293b;          /* abu kehitaman */
    --subtext-color: #4b5563;       /* abu sedang */
    --card-bg: #ffffff;             /* putih bersih */
    --shadow-color: rgba(0, 0, 0, 0.08);
}

/* Reset */
* { margin: 0; padding: 0; box-sizing: border-box; }

html, body {
    font-family: 'Poppins', sans-serif;
    background: var(--background-color);
    color: var(--text-color);
    min-height: 100vh;
    overflow-x: hidden;
}

/* Animasi */
@keyframes fadeInUp {
    0% { opacity: 0; transform: translateY(15px); }
    100% { opacity: 1; transform: translateY(0); }
}

/* Kontainer utama */
.main-container {
    max-width: 600px;
    margin: 0 auto;
    position: relative;
    padding-bottom: 100px;
}

/* Header */
.header {
    background: linear-gradient(135deg, var(--secondary-green), var(--primary-green));
    color: #fff;
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 3px 12px rgba(63,160,114,0.25);
    border-bottom-left-radius: 18px;
    border-bottom-right-radius: 18px;
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    color: #fff;
    cursor: pointer;
    transition: transform 0.3s ease;
}
.header .back-btn:hover { transform: scale(1.15); }
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
}

/* Konten */
.content { padding: 20px 15px; }

/* Komisi Info */
.commission-info {
    text-align: center;
    margin-bottom: 30px;
    line-height: 1.7;
    animation: fadeInUp 0.8s ease;
}
.commission-box {
    background: var(--card-bg);
    border-radius: 14px;
    padding: 20px;
    margin-bottom: 20px;
    border: 1px solid rgba(63,160,114,0.15);
    box-shadow: 0 3px 10px var(--shadow-color);
}
.commission-title {
    font-size: 18px;
    color: var(--primary-green);
    font-weight: 700;
    margin-bottom: 10px;
}
.commission-item {
    display: flex;
    justify-content: space-between;
    padding: 6px 15px;
    font-size: 15px;
    color: var(--subtext-color);
    border-bottom: 1px solid rgba(0,0,0,0.05);
}
.commission-item:last-child { border-bottom: none; }

/* Kartu Undangan */
.invitation-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 4px 14px var(--shadow-color);
    text-align: center;
    border: 1px solid rgba(63,160,114,0.15);
    animation: fadeInUp 1s ease;
}

/* QR Code */
#qrcode {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 15px;
    background: #fff;
    border-radius: 12px;
    margin: 0 auto 25px auto;
    max-width: 220px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

/* Detail Undangan */
.invitation-details {
    text-align: left;
    margin-bottom: 25px;
    word-wrap: break-word;
}
.detail-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 10px;
    font-size: 15px;
}
.detail-label {
    font-weight: 600;
    color: var(--primary-green);
    width: 120px;
}
.detail-value { color: var(--subtext-color); }

/* Tombol */
.copy-btn {
    background: linear-gradient(135deg, var(--secondary-green), var(--primary-green));
    color: white;
    border: none;
    border-radius: 12px;
    padding: 14px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s ease;
    width: 100%;
}
.copy-btn:hover {
    transform: scale(1.03);
    box-shadow: 0 0 12px rgba(102,204,136,0.4);
}

/* Toast */
#toast {
    visibility: hidden;
    min-width: 250px;
    background-color: var(--primary-green);
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 14px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    bottom: 80px;
    transform: translateX(-50%);
    font-size: 15px;
    opacity: 0;
    transition: opacity 0.5s, visibility 0.5s;
}
#toast.show { visibility: visible; opacity: 1; }

/* Navbar Bawah */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: #ffffff;
    display: flex;
    justify-content: space-around;
    padding: 10px 0;
    box-shadow: 0 -3px 12px rgba(0,0,0,0.1);
    z-index: 1000;
    border-top: 2px solid rgba(102,204,136,0.2);
}
.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: var(--subtext-color);
    text-decoration: none;
    transition: all 0.3s ease;
}
.nav-item.active .nav-label {
    color: var(--primary-green);
    font-weight: 600;
}
.nav-item img {
    width: 28px;
    height: 28px;
    margin-bottom: 4px;
    filter: brightness(0.6) saturate(1.2);
    transition: transform 0.3s ease;
}
.nav-item:hover img { transform: scale(1.1); }
.nav-item.active img {
    filter: drop-shadow(0 0 6px var(--primary-green)) brightness(1.4);
}
.nav-label { font-size: 12px; }
</style>
</head>

<body>
<div class="main-container">
    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">MNC TRADE SYARIAH</h1>
    </div>

    <div class="content">
        <div class="commission-info">
            <div class="commission-box">
                <div class="commission-title">💰 Komisi Undangan</div>
                <div class="commission-item"><span>Tingkat A</span><span>10%</span></div>
                <div class="commission-item"><span>Tingkat B</span><span>3%</span></div>
                <div class="commission-item"><span>Tingkat C</span><span>1%</span></div>
            </div>

            <div class="commission-box">
                <div class="commission-title">🚀 Rabat Team</div>
                <div class="commission-item"><span>Tingkat A</span><span>4%</span></div>
                <div class="commission-item"><span>Tingkat B</span><span>2%</span></div>
                <div class="commission-item"><span>Tingkat C</span><span>1%</span></div>
            </div>

            <p style="font-size:14px;color:var(--subtext-color);">
                Gunakan media sosial seperti <strong>YouTube</strong>, <strong>WhatsApp</strong>, <strong>Telegram</strong>, <strong>Facebook</strong>, dan <strong>Instagram</strong> untuk mengundang lebih banyak anggota bergabung.
            </p>
        </div>

        <div class="invitation-card">
            <div id="qrcode"></div>
            <div class="invitation-details">
                <div class="detail-item">
                    <span class="detail-label">Tautan Undangan:</span>
                    <span id="invitation-link-text" class="detail-value"><?php echo e(url('register').'?inviteCode='.auth()->user()->ref_id); ?></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Kode Referral:</span>
                    <span id="invitation-code-text" class="detail-value"><?php echo e(auth()->user()->ref_id); ?></span>
                </div>
            </div>
            <button class="copy-btn" onclick="copyToClipboard('<?php echo e(url('register').'?inviteCode='.auth()->user()->ref_id); ?>','Tautan undangan berhasil disalin!')">📋 Salin Tautan Undangan</button>
        </div>
    </div>

    <!-- Navbar bawah -->
    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img src="https://api.iconify.design/solar:home-2-bold.svg">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my/vip'">
            <img src="https://api.iconify.design/solar:chart-bold.svg">
            <div class="nav-label">Investasi</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg">
            <div class="nav-label">Profil</div>
        </div>
    </div>
</div>

<div id="toast"></div>

<script>
function showToast(message) {
    const toast = document.getElementById("toast");
    toast.textContent = message;
    toast.className = "show";
    setTimeout(() => toast.className = toast.className.replace("show",""), 2000);
}
function copyToClipboard(text, message) {
    navigator.clipboard.writeText(text)
    .then(()=>showToast(message||"Tersalin!"))
    .catch(()=>showToast("Gagal menyalin!"));
}
document.addEventListener('DOMContentLoaded', ()=>{
    const invitationLink = document.getElementById('invitation-link-text').innerText;
    if(invitationLink){
        new QRCode(document.getElementById("qrcode"),{
            text: invitationLink,
            width:200,
            height:200,
            colorDark:"#000000",
            colorLight:"#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });
    }
});
</script>
</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/main/invite.blade.php ENDPATH**/ ?>