<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title>Login</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root{
  --maroon-1:#7f1d1d;
  --maroon-2:#991b1b;
  --maroon-3:#450a0a;

  --text:#ffffff;
  --glass:rgba(10,10,10,.65);
  --border:rgba(127,29,29,.45);
  --shadow:rgba(127,29,29,.65);
}

*{box-sizing:border-box}

body{
  margin:0;
  font-family:'Poppins',sans-serif;
  background:
    linear-gradient(rgba(0,0,0,.78),rgba(0,0,0,.92)),
    url("5gg") center/cover no-repeat fixed;
  color:var(--text);
}

/* PARTIKEL */
.particles{
  position:fixed;
  inset:0;
  z-index:-1;
}
.particle{
  position:absolute;
  width:6px;height:6px;
  background:var(--maroon-2);
  border-radius:50%;
  animation:float 10s linear infinite;
  opacity:.45;
  box-shadow:0 0 12px var(--shadow);
}
@keyframes float{
  from{transform:translateY(110vh);opacity:0}
  50%{opacity:1}
  to{transform:translateY(-10vh);opacity:0}
}

/* CARD */
.page-wraper{
  max-width:420px;
  min-height:100vh;
  margin:auto;
  background:var(--glass);
  backdrop-filter:blur(16px);
  border:1px solid var(--border);
  box-shadow:0 25px 70px rgba(0,0,0,.65);
  border-radius:26px;
  overflow:hidden;
}

/* HEADER */
.header{
  padding:22px 18px 14px;
  text-align:center;
}
.header-title{
  font-size:22px;
  font-weight:800;
  color:#fca5a5;
  text-shadow:0 0 20px var(--shadow);
}

/* BANNER */
.banner-container{
  position:relative;
}
.banner-image{
  width:100%;
  display:block;
}
.banner-shine{
  position:absolute;
  inset:0;
  background:linear-gradient(
    120deg,
    transparent,
    rgba(255,255,255,.18),
    transparent
  );
  animation:shine 4s infinite;
}
@keyframes shine{
  from{transform:translateX(-100%)}
  to{transform:translateX(100%)}
}

/* LOGO */
.logo-wrapper{
  display:flex;
  justify-content:center;
  margin-top:-55px;
}
.logo-circle{
  width:110px;
  height:110px;
  border-radius:50%;
  overflow:hidden;
  background:#000;
  border:4px solid var(--maroon-2);
  box-shadow:0 0 30px var(--shadow);
}
.logo-circle img{
  width:100%;
  height:100%;
  object-fit:cover;
}

/* FORM */
form{
  padding:30px 26px 10px;
}
.input-group{
  display:flex;
  align-items:center;
  margin-bottom:18px;
  background:rgba(0,0,0,.45);
  border:1px solid rgba(127,29,29,.45);
  border-radius:16px;
  transition:.3s;
}
.input-group:focus-within{
  box-shadow:0 0 22px var(--shadow);
  transform:scale(1.02);
}
.input-icon{
  width:52px;
  text-align:center;
  color:#fca5a5;
}
.input-field{
  flex:1;
  padding:15px;
  border:none;
  background:none;
  color:#fff;
  font-size:15px;
}
.input-field::placeholder{color:#e5e7eb}
.input-field:focus{outline:none}

.forgot-link{
  display:block;
  text-align:right;
  font-size:14px;
  color:#fca5a5;
  text-decoration:none;
  margin-bottom:20px;
}

/* BUTTON */
.submit-btn{
  width:100%;
  padding:15px;
  border:none;
  border-radius:40px;
  background:linear-gradient(
    135deg,
    var(--maroon-1),
    var(--maroon-2),
    var(--maroon-3)
  );
  color:#fff;
  font-size:18px;
  font-weight:800;
  cursor:pointer;
  box-shadow:0 0 35px var(--shadow);
  transition:.3s;
}
.submit-btn:hover{
  transform:scale(1.05);
  box-shadow:0 0 55px rgba(127,29,29,.95);
}

/* REGISTER */
.register-text{
  text-align:center;
  padding:18px;
  font-size:14px;
}
.register-text a{
  color:#fca5a5;
  font-weight:700;
  text-decoration:none;
}

</style>
</head>

<body>

<div class="particles">
  <div class="particle" style="left:10%"></div>
  <div class="particle" style="left:30%;animation-delay:2s"></div>
  <div class="particle" style="left:50%;animation-delay:4s"></div>
  <div class="particle" style="left:70%;animation-delay:1s"></div>
  <div class="particle" style="left:90%;animation-delay:3s"></div>
</div>

<div class="page-wraper">

<header class="header">
  <h1 class="header-title">Login Akun Segera</h1>
</header>

<div class="banner-container">
  <img src="5034012.jpg" class="banner-image">
  <div class="banner-shine"></div>
</div>

<form action="<?php echo e(url('login')); ?>" method="POST">
<?php echo csrf_field(); ?>
  <div class="input-group">
    <i class="fas fa-mobile-alt input-icon"></i>
    <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
  </div>

  <div class="input-group">
    <i class="fas fa-lock input-icon"></i>
    <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
  </div>

  <button class="submit-btn">Masuk Sekarang</button>
</form>

<div class="register-text">
  Belum punya akun? <a href="<?php echo e(url('register')); ?>">Daftar sekarang</a>
</div>

</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>