<!DOCTYPE html>    
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>Tentang Kami</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-color: #facc15;       /* Kuning utama */
    --accent-color: #eab308;        /* Kuning lebih pekat */
    --background-color: #ffffff;    /* Putih */
    --text-color: #1f2937;          /* Abu gelap */
    --card-bg: #f8fafc;             /* Putih soft */
}

/* RESET */
* { margin: 0; padding: 0; box-sizing: border-box; }

html, body {
    background: var(--background-color);
    width: 100%;
    overflow-x: hidden;
}

body {
    font-family: 'Poppins', sans-serif;
    color: var(--text-color);
    -webkit-font-smoothing: antialiased;
}

/* MAIN CONTAINER */
.main-container { 
    width: 100%;
    max-width: 600px; 
    margin: 0 auto;
    background: var(--background-color);
    min-height: 100vh;
    position: relative;
}

/* HEADER */
.header { 
    background: linear-gradient(135deg, #facc15, #eab308);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 2px 12px rgba(0,0,0,0.15);
}

.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    color: #fff;
    cursor: pointer;
    font-weight: bold;
}

.header .header-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #fff;
}

/* CONTENT */
.content-wrapper { 
    padding: 25px 15px 60px; 
}

/* MOVING TEXT BOX */
.animated-box {
    background: linear-gradient(135deg, rgba(250,204,21,0.15), rgba(234,179,8,0.25));
    border: 2px solid var(--accent-color);
    border-radius: 14px;
    padding: 18px 25px;
    margin-bottom: 25px;
    text-align: center;
    box-shadow: 0 0 25px rgba(250,204,21,0.25);
}

.animated-text {
    font-weight: 600;
    font-size: 1.05rem;
    background: linear-gradient(90deg, #eab308, #facc15, #eab308);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    white-space: nowrap;
    animation: moveText 8s linear infinite;
}

@keyframes moveText {
    0% { transform: translateX(100%); }
    100% { transform: translateX(-100%); }
}

/* COMPANY CARD */
.company-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 4px 14px rgba(0,0,0,0.12);
    transition: 0.3s ease;
    animation: fadeInUp 0.8s ease both;
}

.company-card:hover { 
    transform: translateY(-4px);
    box-shadow: 0 6px 20px rgba(0,0,0,0.18);
}

.company-image {
    width: 100%;
    height: 200px;
    border-radius: 12px;
    object-fit: cover;
    margin-bottom: 20px;
}

.company-title {
    font-size: 1.4rem;
    font-weight: 600;
    color: var(--accent-color);
    margin-bottom: 12px;
}

.company-content {
    font-size: 1rem;
    line-height: 1.7;
    color: #374151;
    text-align: justify;
}

/* ANIMATION */
@keyframes fadeInUp {
    from {opacity: 0; transform: translateY(20px);}
    to {opacity: 1; transform: translateY(0);}
}

.company-card { animation: fadeInUp 0.8s ease both; }

</style>
</head>   

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Tentang Kami</h1>
    </div>

    <div class="content-wrapper">

        <!-- KOTAK TEKS BERGERAK -->
        <div class="animated-box">
            <div class="animated-text">💳 Smart Credit • Smarter Investment • FINANCE WORLD INVESTMENT🚀</div>
        </div>

        <!-- BAGIAN UTAMA -->
        <div class="company-card">
            <img src="images (2).jpg" alt="Tentang Kami" class="company-image">
            <h2 class="company-title">FINANCE WORLD Invest</h2>
            <p class="company-content">
                <strong>FINANCE WORLD</strong> adalah pionir dalam dunia <em>FINANCE WORLD</em> — inovasi finansial masa depan yang menghubungkan kenyamanan kartu kredit dengan potensi investasi digital yang menguntungkan.  
                <br><br>
                Kami menghadirkan sistem investasi cerdas berbasis transaksi kartu kredit yang transparan, cepat, dan aman. Setiap transaksi bukan hanya pengeluaran, tetapi juga peluang untuk menumbuhkan nilai finansial Anda melalui portofolio investasi otomatis dan real-time.
                <br><br>
                Dengan dukungan teknologi <em>AI FinTech</em> dan jaringan global, kami berkomitmen menciptakan ekosistem keuangan yang dinamis — di mana pengguna dapat:
                <ul style="margin-left:20px; margin-top:10px;">
                    <li>Mengubah transaksi kartu kredit menjadi aset produktif.</li>
                    <li>Memperoleh imbal hasil kompetitif dari sistem investasi digital otomatis.</li>
                    <li>Menikmati pengalaman finansial tanpa batas dengan keamanan tingkat tinggi.</li>
                    <li>Mengakses analitik keuangan real-time untuk strategi investasi cerdas.</li>
                </ul>
                <br>
                <strong>Visi Kami:</strong> Menjadi jembatan utama antara dunia pembayaran dan investasi digital — menciptakan kebebasan finansial melalui inovasi berkelanjutan.  
                <br><br>
                <strong>Misi Kami:</strong> Memberdayakan setiap individu untuk berinvestasi lebih mudah, cepat, dan aman hanya dengan kartu kredit mereka.
                <br><br>
                <em>FINANCE WORLD</em> bukan sekadar platform — kami adalah revolusi baru dalam cara dunia mengelola uang, menumbuhkan peluang, dan membangun masa depan finansial yang lebih cerah.
            </p>
        </div>

    </div>
</div>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/about.blade.php ENDPATH**/ ?>