
<!DOCTYPE html>  
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Atur Bank</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-color: #004aad;
      --secondary-color: #002b5b;
      --accent-color: #00b7ff;
      --text-color: #fff;
      --subtext-color: #cfd8e3;
      --white-color: #fff;
      --border-color: #1a4d8f;
      --input-bg: rgba(255, 255, 255, 0.15);
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }

    html, body {
      overflow-x: hidden;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
    }

    body {
      font-family: 'Poppins', sans-serif;
      color: var(--text-color);
    }

    a { text-decoration: none; color: inherit; }

    .main-container {
      width: 100%;
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
      position: relative;
      padding-bottom: 80px;
    }

    /* HEADER */
    .header {
      background: rgba(255,255,255,0.05);
      backdrop-filter: blur(10px);
      padding: 18px 20px;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      color: #fff;
      box-shadow: 0 3px 10px rgba(0,0,0,0.2);
    }

    .header .back-btn {
      position: absolute;
      left: 20px;
      font-size: 26px;
      color: #fff;
      cursor: pointer;
      font-weight: bold;
    }

    .header .header-title {
      font-size: 1.2rem;
      font-weight: 600;
    }

    /* Banner */
    .banner-image {
      width: 100%;
      display: block;
      border-bottom: 3px solid rgba(255,255,255,0.2);
    }

    /* Content */
    .content-wrapper {
      padding: 25px 15px 40px;
    }

    .form-container {
      background: rgba(255, 255, 255, 0.1);
      border-radius: 18px;
      padding: 25px 20px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.2);
      border: 1px solid rgba(255,255,255,0.15);
      animation: fadeIn 0.5s ease-in-out;
    }

    .form-group { margin-bottom: 18px; }

    .form-label {
      display: block;
      font-size: 14px;
      font-weight: 600;
      margin-bottom: 6px;
      color: #fff;
    }

    .form-control {
      width: 100%;
      height: 48px;
      padding: 0 15px;
      border-radius: 12px;
      border: 1px solid rgba(255,255,255,0.3);
      background-color: var(--input-bg);
      color: #fff;
      font-size: 15px;
      transition: border-color 0.3s, box-shadow 0.3s;
    }

    .form-control:focus {
      outline: none;
      border-color: var(--accent-color);
      box-shadow: 0 0 6px var(--accent-color);
    }

    select.form-control {
      appearance: none;
      background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' stroke='%23ffffff' viewBox='0 0 16 16'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
      background-repeat: no-repeat;
      background-position: right 1rem center;
      background-size: 14px 10px;
    }

    .submit-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, #00b7ff, #006aff);
      color: #fff;
      border: none;
      border-radius: 14px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-top: 15px;
      box-shadow: 0 4px 15px rgba(0, 71, 171, 0.4);
      transition: transform 0.2s, opacity 0.3s;
    }

    .submit-btn:hover {
      transform: translateY(-2px);
      opacity: 0.9;
    }

    /* BOTTOM NAVBAR */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 50%;
      transform: translateX(-50%);
      width: 100%;
      max-width: 600px;
      background: linear-gradient(135deg, #002b5b, #004aad);
      display: flex;
      justify-content: space-around;
      padding: 10px 0;
      box-shadow: 0 -2px 15px rgba(0,0,0,0.4);
      z-index: 1000;
    }

    .nav-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      color: #fff;
      text-decoration: none;
      transition: all 0.3s ease;
    }

    .nav-item img {
      width: 26px;
      height: 26px;
      margin-bottom: 4px;
      filter: brightness(2);
      transition: transform 0.3s ease;
    }

    .nav-item.active img {
      filter: drop-shadow(0 0 10px #00b7ff) brightness(3);
      transform: scale(1.1);
    }

    .nav-label {
      font-size: 12px;
      color: #fff;
    }

    .nav-item.active .nav-label {
      color: #00b7ff;
      font-weight: 600;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>

<body>
<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">Informasi Bank</h1>
  </div>


  <div class="content-wrapper">
    <div class="form-container">
      <form action="<?php echo e(route('setup.gateway.submit')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="form-group">
          <label class="form-label" for="holderName">Nama Pemilik Rekening</label>
          <input id="holderName" class="form-control" name="holdername" value="<?php echo e(auth()->user()->holder_name); ?>" placeholder="Masukkan Nama Pemilik Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="accountNumber">Nomor Rekening</label>
          <input id="accountNumber" class="form-control" name="gateway_number" value="<?php echo e(auth()->user()->gateway_number); ?>" placeholder="Masukkan Nomor Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="bankCode">Nama Bank</label>
          <select id="bankCode" class="form-control" name="gateway_method" required>
            <?php
              $methods = \App\Models\PaymentMethod::select('id','name')->where('status', 'active')->groupBy('name')->get();
            ?>
            <option value="">Pilih Bank</option>
            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($element->id); ?>" <?php echo e((auth()->user()->gateway_method == $element->id) ? 'selected' : ''); ?>>
                <?php echo e($element->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <button type="submit" class="submit-btn">
          Simpan Informasi
        </button>
      </form>
    </div>
  </div>

 <!-- 🌟 NAVBAR BAWAH ELEGAN (VERSI DISEMPURNAKAN) -->
<div class="bottom-nav">
  <!-- HOME -->
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>

  <!-- INVESTASI SAYA -->
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>

  <!-- TEAM -->
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>

  <!-- PROFIL -->
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>


</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/financew/public_html/resources/views/app/main/add_bank.blade.php ENDPATH**/ ?>