<!DOCTYPE html>     
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Team</title>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-color: #007bff;
    --accent-color: #00e0ff;
    --bg-gradient: linear-gradient(135deg, #0a0f2c, #001a3d, #002f5a);
    --card-bg: rgba(255, 255, 255, 0.07);
    --text-color: #ffffff;
    --subtext-color: #a9c4ff;
}

* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    font-family: 'Poppins', sans-serif;
    background: var(--bg-gradient);
    color: var(--text-color);
    min-height: 100vh;
    overflow-x: hidden;
}

/* MAIN CONTAINER */
.main-container {
    max-width: 600px;
    margin: 0 auto;
    position: relative;
}

/* HEADER */
.header {
    background: linear-gradient(135deg, #002b5b, #004aad);
    color: var(--text-color);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 4px 15px rgba(0,0,0,0.4);
    border-bottom: 1px solid rgba(255,255,255,0.1);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 28px;
    color: var(--accent-color);
    cursor: pointer;
    transition: transform 0.3s ease;
}
.header .back-btn:hover { transform: scale(1.2); }
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
    letter-spacing: 0.5px;
}

/* REFERRAL BOX */
.referral-box {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 14px;
    padding: 14px 18px;
    margin: 15px 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
    backdrop-filter: blur(10px);
}
.referral-text {
    font-size: 14px;
    word-break: break-all;
    color: #e0e6ff;
    flex: 1;
    margin-right: 10px;
}
.copy-btn {
    background: var(--accent-color);
    color: #001a3d;
    border: none;
    padding: 8px 12px;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 13px;
}
.copy-btn:hover {
    transform: scale(1.05);
    box-shadow: 0 0 15px var(--accent-color);
}
.copy-btn i { margin-left: 5px; }

/* CONTENT */
.content-wrapper {
    padding: 20px 15px 100px;
}

/* STATS BOX */
.stats-box {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
    margin-bottom: 10px;
    border: 1px solid rgba(255,255,255,0.1);
}
.stats-box .stat-label {
    font-size: 14px;
    color: var(--subtext-color);
}
.stats-box .stat-value {
    font-size: 24px;
    font-weight: 700;
    color: var(--accent-color);
}
.stats-box .sub-stats {
    display: flex;
    justify-content: space-around;
    border-top: 1px solid rgba(255,255,255,0.2);
    margin-top: 10px;
    padding-top: 10px;
}

/* LEVEL BOXES */
.level-deposit-box {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(255,255,255,0.1);
    border-radius: 12px;
    text-align: center;
    padding: 12px;
    margin-bottom: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
}
.level-deposit-box h3 {
    color: var(--accent-color);
    font-size: 15px;
    margin-bottom: 5px;
}
.level-deposit-box p {
    color: #fff;
    font-size: 18px;
    font-weight: 600;
}

/* TABS */
.team-tabs {
    display: flex;
    background: rgba(255,255,255,0.08);
    border-radius: 12px;
    padding: 5px;
    margin-bottom: 20px;
}
.tab-btn {
    flex: 1;
    padding: 12px;
    text-align: center;
    background: transparent;
    color: var(--subtext-color);
    font-weight: 600;
    border: none;
    cursor: pointer;
    border-radius: 9px;
    transition: all 0.3s ease;
}
.tab-btn.active {
    background: var(--primary-color);
    color: #fff;
    box-shadow: 0 0 15px rgba(0,150,255,0.6);
}
.tab-content { display: none; }
.tab-content.active { display: block; }

/* USER CARD */
.user-list { display: flex; flex-direction: column; gap: 12px; }
.user-card {
    background: rgba(255,255,255,0.05);
    border-radius: 12px;
    padding: 15px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
    border: 1px solid rgba(255,255,255,0.05);
    transition: all 0.3s ease;
}
.user-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 18px rgba(0, 150, 255, 0.4);
}
.user-info .user-id {
    font-weight: 600;
    font-size: 16px;
    color: #fff;
}
.user-info .join-date, 
.user-info .team-deposit {
    font-size: 13px;
    color: var(--subtext-color);
}
.user-status {
    font-size: 14px;
    font-weight: 600;
    color: #20ff88;
}

/* NO RECORD */
.no-record {
    text-align: center;
    padding: 40px 20px;
    color: var(--subtext-color);
    background: rgba(255,255,255,0.05);
    border-radius: 12px;
}

/* BOTTOM NAV */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, #002b5b, #004aad);
    display: flex;
    justify-content: space-around;
    padding: 10px 0;
    box-shadow: 0 -2px 15px rgba(0,0,0,0.4);
    z-index: 1000;
    border-top: 1px solid rgba(255,255,255,0.15);
}
.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: var(--subtext-color);
    text-decoration: none;
    transition: all 0.3s ease;
}
.nav-item.active .nav-label {
    color: var(--accent-color);
    font-weight: 600;
}
.nav-item img {
    width: 28px;
    height: 28px;
    margin-bottom: 4px;
    filter: brightness(2);
    transition: filter 0.3s ease, transform 0.3s ease;
}
.nav-item:hover img {
    transform: scale(1.15);
}
.nav-item.active img {
    filter: drop-shadow(0 0 10px var(--accent-color)) brightness(2.5);
}
.nav-label { font-size: 12px; }
</style>
</head>
<body>
<div class="main-container">

    <!-- HEADER -->
    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Tim</h1>
    </div>

    <!-- CONTENT -->
    <div class="content-wrapper">
        <!-- STATISTIK TEAM -->
        <div class="stats-box">
            <div class="main-stat">
                <div class="stat-label">Deposit Team</div>
                <div class="stat-value"><?php echo e(price($totalDeposit1 + $totalDeposit2 + $totalDeposit3)); ?></div>
            </div>
            <div class="sub-stats">
                <div class="stat-item">
                    <div class="stat-label">Total Asset</div>
                    <div class="stat-value"><?php echo e(price($totalCommission1 + $totalCommission2 + $totalCommission3)); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-label">Total Anggota Tim:</div>
                    <div class="stat-value"><?php echo e($team_size ?? 0); ?></div>
                </div>
            </div>
        </div>

        <!-- REFERRAL BOX -->
        <div class="referral-box">
            <div class="referral-text" id="referralLink"><?php echo e(url('register') . '?inviteCode=' . auth()->user()->ref_id); ?></div>
            <button class="copy-btn" onclick="copyReferral()">Salin <i class="fa fa-copy"></i></button>
        </div>

        <!-- TABS -->
        <div class="team-tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'level-1')">1-level</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-2')">2-level</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-3')">3-level</button>
        </div>

        <!-- LEVEL 1 -->
        <div id="level-1" class="tab-content active">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 1</h3>
                <p><?php echo e(price($totalDeposit1)); ?></p>
            </div>
            <?php if($first_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Joined: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Active' : 'Nonaktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">No record</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 2 -->
        <div id="level-2" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 2</h3>
                <p><?php echo e(price($totalDeposit2)); ?></p>
            </div>
            <?php if($second_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Joined: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Active' : 'Nonaktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">No record</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 3 -->
        <div id="level-3" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 3</h3>
                <p><?php echo e(price($totalDeposit3)); ?></p>
            </div>
            <?php if($third_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Team Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Joined: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Active' : 'Nonaktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">No record</div>
            <?php endif; ?>
        </div>
    </div>

   <!-- 🌟 NAVBAR BAWAH ELEGAN (VERSI DISEMPURNAKAN) -->
<div class="bottom-nav">
  <!-- HOME -->
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>

  <!-- INVESTASI SAYA -->
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>

  <!-- TEAM -->
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>

  <!-- PROFIL -->
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>


</div>

<script>
function switchTab(event, tabId) {
    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.getElementById(tabId).classList.add('active');
    event.currentTarget.classList.add('active');
}

function copyReferral() {
    const text = document.getElementById("referralLink").innerText;
    navigator.clipboard.writeText(text).then(() => {
        const btn = document.querySelector(".copy-btn");
        btn.innerHTML = "Disalin ✓";
        btn.style.background = "#20ff88";
        setTimeout(() => {
            btn.innerHTML = 'Salin <i class="fa fa-copy"></i>';
            btn.style.background = "var(--accent-color)";
        }, 2000);
    });
}
</script>
</body>
</html>
<?php /**PATH /home/runnlvbg/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>