<!DOCTYPE html>  
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Register</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --gold-main: #d4af37;
      --gold-light: #fbe7a1;
      --gold-glow: rgba(255, 215, 0, 0.7);
      --white: #ffffff;
      --text-dark: #222;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(180deg, #ffffff 0%, #f7f7f7 50%, #f0f0f0 100%);
      color: var(--text-dark);
      overflow-x: hidden;
      position: relative;
    }

    /* Gold floating particles */
    .particles {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      overflow: hidden;
      z-index: -1;
    }

    .particle {
      position: absolute;
      width: 6px;
      height: 6px;
      background: var(--gold-main);
      border-radius: 50%;
      animation: float 10s linear infinite;
      opacity: 0.8;
      box-shadow: 0 0 8px var(--gold-main);
    }

    @keyframes float {
      from { transform: translateY(100vh) scale(0.6); opacity:0; }
      50% { opacity:1; }
      to { transform: translateY(-10vh) scale(1); opacity:0; }
    }

    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: rgba(255,255,255,0.8);
      border-radius: 20px;
      backdrop-filter: blur(8px);
      box-shadow: 0 0 25px rgba(212, 175, 55, 0.25);
      overflow: hidden;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      position: relative;
      z-index: 2;
    }

    .back-arrow {
      font-size: 24px;
      color: var(--gold-main);
      text-decoration: none;
      position: absolute;
      left: 15px;
    }

    .header-title {
      font-size: 22px;
      font-weight: 600;
      text-align: center;
      flex-grow: 1;
      color: var(--gold-main);
      text-shadow: 0 0 8px var(--gold-glow);
    }

    .banner-container {
      position: relative;
      overflow: hidden;
    }

    .banner-image {
      width: 100%;
      display: block;
      border-bottom: 2px solid var(--gold-main);
      box-shadow: 0 4px 20px rgba(212, 175, 55, 0.25);
    }

    .banner-shine {
      position: absolute;
      top: 0;
      left: -100%;
      width: 60%;
      height: 100%;
      background: linear-gradient(120deg, transparent, rgba(255,255,255,0.4), transparent);
      animation: shineMove 4s infinite;
    }

    @keyframes shineMove {
      0% { left:-100%; }
      50%,100% { left:120%; }
    }

    .auth-container {
      padding: 25px 25px 40px;
      margin-top: -10px;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      background: #ffffff;
    }

    .tab-navigation {
      display: flex;
      background: rgba(212,175,55,0.15);
      border-radius: 12px;
      padding: 6px;
      margin-bottom: 25px;
      box-shadow: inset 0 0 10px rgba(212,175,55,0.5);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 9px;
      cursor: pointer;
      background: transparent;
      color: var(--text-dark);
      transition: all .3s ease;
    }

    .tab.active {
      background: linear-gradient(135deg, var(--gold-main), var(--gold-light));
      color: #fff;
      box-shadow: 0 0 14px var(--gold-glow);
    }

    .input-group {
      display: flex;
      align-items: center;
      margin-bottom: 22px;
      background: #fff;
      border: 1px solid rgba(212,175,55,0.4);
      border-radius: 14px;
      transition: all 0.3s ease;
      overflow: hidden;
      box-shadow: 0 0 10px rgba(212,175,55,0.15);
    }

    .input-group:focus-within {
      border-color: var(--gold-main);
      box-shadow: 0 0 12px var(--gold-glow);
      transform: scale(1.01);
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: var(--gold-main);
      font-size: 18px;
      border-right: 1px solid rgba(212,175,55,0.3);
    }

    .input-field {
      flex: 1;
      padding: 15px;
      font-size: 15px;
      background: transparent;
      border: none;
      color: #333;
    }

    .captcha-container {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 22px;
    }

    .captcha-box {
      background: #fff7d6;
      border-radius: 12px;
      padding: 10px 20px;
      font-size: 22px;
      font-weight: bold;
      letter-spacing: 5px;
      color: var(--gold-main);
      text-shadow: 0 0 8px var(--gold-glow);
      user-select: none;
      box-shadow: inset 0 0 12px rgba(212,175,55,0.4);
    }

    .refresh-btn {
      background: transparent;
      border: none;
      color: var(--gold-main);
      font-size: 20px;
      cursor: pointer;
      transition: .3s;
    }

    .refresh-btn:hover {
      transform: rotate(180deg);
      color: #000;
    }

    .error-message {
      color: red;
      text-align: center;
      margin-top: -10px;
      margin-bottom: 10px;
      font-weight: 600;
      display: none;
    }

    .submit-btn {
      width: 100%;
      padding: 15px;
      background: linear-gradient(135deg, var(--gold-main), var(--gold-light));
      color: #fff;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      margin-top: 20px;
      box-shadow: 0 0 20px var(--gold-glow);
      transition: all .3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, #c9a233, #f4e39a);
      transform: scale(1.02);
      box-shadow: 0 0 30px var(--gold-glow);
    }
  </style>
</head>

<body>

  <!-- GOLD PARTICLES -->
  <div class="particles">
    <div class="particle" style="left:10%; animation-delay:0s;"></div>
    <div class="particle" style="left:30%; animation-delay:2s;"></div>
    <div class="particle" style="left:50%; animation-delay:4s;"></div>
    <div class="particle" style="left:70%; animation-delay:1s;"></div>
    <div class="particle" style="left:90%; animation-delay:3s;"></div>
  </div>

  <div class="page-wraper">

    <header class="header">
      <a href="javascript:history.back()" class="back-arrow">&#60;</a>
      <h1 class="header-title">Register</h1>
    </header>

    <div class="banner-container">
      <img src="WHATT.jpg" class="banner-image">
      <div class="banner-shine"></div>
    </div>

    <div class="auth-container">

      <div class="tab-navigation">
        <a href="<?php echo e(route('login')); ?>" class="tab">Log In</a>
        <button class="tab active">Register</button>
      </div>

      <form id="registerForm" action="<?php echo e(route('register')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-user input-icon"></i>
          <input type="text" name="name" class="input-field" placeholder="Username" required>
        </div>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password_confirmation" class="input-field" placeholder="Konfirmasi Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-ticket-alt input-icon"></i>
          <input type="text" id="referralCode" name="ref_id" class="input-field" placeholder="Kode Referral">
        </div>

        <div class="captcha-container">
          <div id="captchaBox" class="captcha-box"></div>
          <button type="button" class="refresh-btn" onclick="generateCaptcha()">
            <i class="fas fa-sync-alt"></i>
          </button>
        </div>

        <div class="input-group">
          <i class="fas fa-key input-icon"></i>
          <input type="text" name="otp" id="otpInput" class="input-field" placeholder="Masukkan kode OTP pada gambar" required>
        </div>

        <div id="errorMsg" class="error-message">Kode OTP salah!</div>

        <button type="submit" class="submit-btn">Register</button>
      </form>
    </div>
  </div>

  <script>
    function generateCaptcha() {
      const captchaBox = document.getElementById("captchaBox");
      const chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
      let otp = "";
      for (let i=0; i<6; i++) otp += chars.charAt(Math.floor(Math.random() * chars.length));
      captchaBox.textContent = otp;
      captchaBox.dataset.code = otp;
    }
    document.addEventListener("DOMContentLoaded", generateCaptcha);

    document.getElementById("registerForm").addEventListener("submit", function(e) {
      const userOtp = document.getElementById("otpInput").value.trim().toUpperCase();
      const correctOtp = document.getElementById("captchaBox").dataset.code;
      const errorMsg = document.getElementById("errorMsg");

      if (userOtp !== correctOtp) {
        e.preventDefault();
        errorMsg.style.display = "block";
        generateCaptcha();
      } else {
        errorMsg.style.display = "none";
      }
    });

    document.addEventListener("DOMContentLoaded", function () {
      const urlParams = new URLSearchParams(window.location.search);
      const inviteCode = urlParams.get("inviteCode");
      if (inviteCode) {
        document.getElementById("referralCode").value = inviteCode;
      }
    });
  </script>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/speedeku/public_html/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>