<!DOCTYPE html>   
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Penarikan</title>

  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-color: #f4d03f;     /* kuning emas */
      --primary-dark: #d4b12f;
      --text-dark: #333;
      --text-light: #777;
      --white: #ffffff;
      --border-color: #eaeaea;
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }

    body {
      font-family: 'Poppins', sans-serif;
      background: #ffffff;
      color: var(--text-dark);
      width: 100%;
      min-height: 100vh;
    }

    .main-container {
      width: 100%;
      max-width: 600px;
      margin: auto;
      padding-bottom: 80px;
      background: #fff;
    }

    /* HEADER */
    .header {
      background: var(--primary-color);
      padding: 15px 20px;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      border-radius: 0 0 15px 15px;
    }

    .header .back-btn {
      position: absolute;
      left: 20px;
      font-size: 26px;
      color: #000;
      cursor: pointer;
      font-weight: bold;
    }

    .header-title {
      font-size: 1.3rem;
      font-weight: 700;
      color: #000;
    }

    .content-wrapper { padding: 20px 15px; }

    /* CARD */
    .card {
      background: #fff;
      border: 1px solid var(--border-color);
      box-shadow: 0 4px 20px rgba(0,0,0,0.05);
      border-radius: 14px;
      padding: 20px;
      margin-bottom: 20px;
    }

    /* SALDO */
    .balance-label {
      font-size: 14px;
      color: var(--text-light);
    }

    .balance-amount {
      font-size: 32px;
      font-weight: 700;
      color: var(--primary-dark);
      margin-top: 5px;
    }

    /* BANK */
    .bank-card-display .card-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
    }

    .card-title {
      font-size: 16px;
      font-weight: 600;
      color: var(--text-dark);
    }

    .edit-btn {
      background: var(--primary-color);
      border: none;
      padding: 6px 14px;
      border-radius: 8px;
      color: #000;
      font-weight: 600;
      font-size: 13px;
      cursor: pointer;
      transition: .2s;
    }

    .edit-btn:hover {
      background: var(--primary-dark);
    }

    .info-row {
      display: flex;
      justify-content: space-between;
      padding: 7px 0;
      font-size: 14px;
      color: var(--text-dark);
    }

    .info-row .label { color: var(--text-light); }

    /* INPUT */
    .form-label {
      display: block;
      font-size: 14px;
      font-weight: 600;
      margin-bottom: 6px;
      color: var(--text-dark);
    }

    .form-control {
      width: 100%;
      height: 48px;
      border-radius: 10px;
      padding: 0 15px;
      border: 1px solid #ccc;
      background: #fafafa;
      font-size: 16px;
      color: var(--text-dark);
      font-weight: 500;
      transition: .3s;
    }

    .form-control:focus {
      outline: none;
      border-color: var(--primary-color);
      box-shadow: 0 0 5px rgba(244,208,63,0.5);
    }

    /* NOMINAL */
    .amount-options {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 10px;
      margin-top: 14px;
    }

    .amount-btn {
      padding: 12px 10px;
      background: #fff;
      border: 1px solid var(--border-color);
      border-radius: 12px;
      font-weight: 600;
      cursor: pointer;
      font-size: 15px;
      transition: .25s;
      color: var(--text-dark);
    }

    .amount-btn:hover,
    .amount-btn.active {
      background: var(--primary-color);
      border-color: var(--primary-color);
      color: #000;
      transform: translateY(-2px);
    }

    /* BUTTON */
    .submit-btn {
      width: 100%;
      background: var(--primary-color);
      border: none;
      border-radius: 12px;
      padding: 14px;
      font-size: 16px;
      font-weight: 700;
      margin-top: 15px;
      cursor: pointer;
      transition: .25s;
      color: #000;
    }

    .submit-btn:hover {
      background: var(--primary-dark);
    }

    /* INFO */
    .info-section {
      font-size: 14px;
      color: var(--text-dark);
      line-height: 1.6;
    }

    .highlight {
      background: #fff8d2;
      border-left: 4px solid var(--primary-color);
      padding: 10px;
      border-radius: 10px;
      margin: 10px 0;
      color: #7a6400;
    }

    /* NAVBAR */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background: #fff;
      border-top: 1px solid var(--border-color);
      display: flex;
      justify-content: space-around;
      padding: 10px 0;
      box-shadow: 0 -4px 15px rgba(0,0,0,0.08);
    }

    .nav-item {
      text-align: center;
      font-size: 13px;
      color: var(--text-light);
      cursor: pointer;
    }

    .nav-item.active {
      color: var(--primary-dark);
      font-weight: 700;
    }

    .nav-icon {
      font-size: 20px;
      margin-bottom: 4px;
    }
  </style>
</head>
<body>

<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">Penarikan</h1>
  </div>

  <div class="content-wrapper">

    <!-- SALDO -->
    <div class="card balance-card">
      <div class="balance-label">Saldo Tersedia</div>
      <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>

    <?php if(auth()->user()->gateway_number && auth()->user()->gateway_method): ?>
      <?php
        $method = \App\Models\PaymentMethod::where('id', auth()->user()->gateway_method)->first();
      ?>

      <!-- BANK -->
      <div class="card bank-card-display">
        <div class="card-header">
          <span class="card-title">Penarikan ke Rekening Bank</span>
          <button class="edit-btn" onclick="window.location.href='/add/card'">
            <i class="fas fa-edit"></i> Ubah
          </button>
        </div>

        <div class="bank-info">
          <div class="info-row">
            <span class="label">Nama Bank:</span>
            <span class="value"><?php echo e($method->name ?? 'N/A'); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nama Pemilik:</span>
            <span class="value"><?php echo e(auth()->user()->holder_name); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nomor Rekening:</span>
            <span class="value"><?php echo e(auth()->user()->gateway_number); ?></span>
          </div>
        </div>
      </div>

      <!-- FORM -->
      <div class="card withdraw-form">
        <form action="<?php echo e(route('user.withdraw-confirm-submit')); ?>" method="POST">
          <?php echo csrf_field(); ?>

          <label class="form-label">Jumlah Penarikan</label>
          <input id="withdrawAmount" type="number" class="form-control" name="amount" placeholder="Pilih nominal" readonly required>

          <div class="amount-options">
            <button type="button" class="amount-btn" data-amount="30000">Rp 30.000</button>
            <button type="button" class="amount-btn" data-amount="80000">Rp 80.000</button>
            <button type="button" class="amount-btn" data-amount="250000">Rp 250.000</button>
            <button type="button" class="amount-btn" data-amount="750000">Rp 750.000</button>
            <button type="button" class="amount-btn" data-amount="1500000">Rp 1.500.000</button>
            <button type="button" class="amount-btn" data-amount="3000000">Rp 3.000.000</button>
            <button type="button" class="amount-btn" data-amount="5000000">Rp 5.000.000</button>
            <button type="button" class="amount-btn" data-amount="10000000">Rp 10.000.000</button>
          </div>

          <button type="submit" class="submit-btn">Konfirmasi Penarikan</button>
        </form>
      </div>

    <?php else: ?>
      <div class="card">
        <p>Anda belum menambahkan kartu bank.</p>
        <a href="/add/card" class="submit-btn" style="display:block;text-align:center;margin-top:15px;">Tambah Kartu Bank</a>
      </div>
    <?php endif; ?>

    <!-- INFO -->
    <div class="card info-section">
      <h4>ℹ️ Informasi Penting Penarikan</h4>
      <div class="highlight">
        Pastikan data rekening Anda benar agar dana dapat diterima tanpa kendala.
      </div>
      <p>1. Minimal penarikan: <strong>Rp 30.000</strong></p>
      <p>2. Maksimal penarikan: <strong>Rp 10.000.000</strong></p>
      <p>3. Biaya administrasi: <strong>10%</strong></p>
      <p>4. Jam layanan: <strong>10:00 – 18:00 WIB</strong></p>
      <p>5. Proses: <strong>1–24 jam</strong></p>
      <div class="highlight">Tips: Lakukan penarikan di jam aktif agar lebih cepat.</div>
    </div>

  </div>

  <!-- NAVBAR -->
  <div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
      <div class="nav-icon">🏠</div>
      <div class="nav-label">Home</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/my/vip'">
      <div class="nav-icon">📦</div>
      <div class="nav-label">Investasi</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/my-team'">
      <div class="nav-icon">👥</div>
      <div class="nav-label">Team</div>
    </div>
    <div class="nav-item active" onclick="window.location.href='/mine'">
      <div class="nav-icon">👤</div>
      <div class="nav-label">Profil</div>
    </div>
  </div>

</div>

<script>
document.querySelectorAll('.amount-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    document.querySelectorAll('.amount-btn').forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
    document.getElementById('withdrawAmount').value = btn.dataset.amount;
  });
});
</script>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>