<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>Home</title>

    <style>
        :root {
            --gold: #e8c26b;
            --gold-light: #ffeb9c;
            --gold-deep: #b99350;
            --white: #ffffff;
            --soft-bg: #fafafa;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: var(--soft-bg);
            color: #222;
            overflow-x: hidden;
        }

        .main-container {
            max-width: 600px;
            margin: 0 auto;
            min-height: 100vh;
            background: var(--white);
            border-radius: 20px;
            box-shadow: 0 0 25px rgba(255, 215, 0, 0.25);
            padding-bottom: 80px;
        }

        /* Header */
        .header {
            background: linear-gradient(135deg, var(--gold), var(--gold-deep));
            color: #fff;
            padding: 15px 20px;
            text-align: center;
            font-weight: 700;
            font-size: 1.25rem;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            box-shadow: 0 0 18px rgba(255, 215, 0, 0.6);
        }

        /* Slider */
        .slider-container {
            overflow: hidden;
            width: 100%;
        }

        .slider {
            display: flex;
            width: 100%;
            transition: transform 0.6s ease;
        }

        .slide img {
    width: 100%;
    height: auto;        /* Tinggi otomatis → gambar tidak dipotong */
    object-fit: contain; /* Tidak memotong gambar */
    border-bottom: 3px solid var(--gold);
    display: block;
}


        .dots {
            display: flex;
            justify-content: center;
            margin: 10px 0;
        }

        .dot {
            width: 10px;
            height: 10px;
            margin: 0 4px;
            background: #e8d69c;
            border-radius: 50%;
        }

        .dot.active {
            background: var(--gold);
            box-shadow: 0 0 8px gold;
        }

        /* Action Buttons */
        .action-buttons {
            display: flex;
            justify-content: space-between;
            background: #fff8e1;
            padding: 15px 10px;
            margin: 12px;
            border-radius: 15px;
            box-shadow: 0 0 12px rgba(225, 190, 90, 0.35);
        }

        .action-btn {
            flex: 1;
            text-align: center;
            cursor: pointer;
        }

        .action-btn img {
            width: 44px;
            filter: drop-shadow(0 0 12px rgba(255, 200, 0, 0.8));
        }

        .action-btn div {
            margin-top: 5px;
            font-weight: 600;
            color: #7a5a20;
        }

        /* Tabs */
        .tabs {
            display: flex;
            background: #fff6d8;
            margin: 15px;
            border-radius: 12px;
            box-shadow: inset 0 0 10px rgba(255, 220, 140, 0.5);
        }

        .tab {
            flex: 1;
            padding: 12px;
            border: 0;
            background: transparent;
            cursor: pointer;
            font-weight: 600;
            color: #aa8b48;
        }

        .tab.active {
            background: linear-gradient(135deg, var(--gold), var(--gold-light));
            color: #fff;
            box-shadow: 0 0 15px rgba(255, 215, 0, 0.6);
        }

        /* Cards */
        .content-wrapper {
            padding: 0 15px 90px;
        }

        .plan-card {
            background: #fffdf5;
            border-radius: 15px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 0 15px rgba(255, 215, 0, 0.25);
            border: 1px solid rgba(255, 215, 0, 0.5);
        }

        .plan-title {
            color: var(--gold-deep);
            font-weight: 700;
            margin-bottom: 8px;
        }

        .plan-body {
            display: flex;
            gap: 15px;
        }

        .plan-image-container {
            width: 90px;
            height: 90px;
            overflow: hidden;
            border-radius: 12px;
            border: 2px solid var(--gold);
        }

        .plan-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .detail-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            color: #6a5520;
        }

        .detail-item .value {
            font-weight: 700;
            color: var(--gold-deep);
        }

        .buy-btn {
            width: 100%;
            padding: 10px;
            margin-top: 10px;
            border: 0;
            border-radius: 50px;
            font-weight: 700;
            color: #fff;
            background: linear-gradient(135deg, var(--gold), var(--gold-deep));
        }

        .buy-btn:disabled {
            background: #c9c9c9;
        }

        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            max-width: 600px;
            width: 100%;
            background: linear-gradient(135deg, var(--gold), var(--gold-deep));
            padding: 10px 0;
            display: flex;
            justify-content: space-around;
            color: #fff;
            box-shadow: 0 -3px 12px rgba(255, 220, 140, 0.55);
        }

        .nav-item {
            text-align: center;
        }

        .nav-item img {
            width: 26px;
        }

        .nav-item.active img {
            filter: drop-shadow(0 0 8px gold);
        }
    </style>

</head>

<body>

    <div class="main-container">

        <div class="header">FD225WAT</div>

        
        <div class="slider-container" id="main-slider-container">
            <div class="slider" id="main-slider">
                <?php $__currentLoopData = \App\Models\VipSlider::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="slide">
                        <img src="<?php echo e(asset($slider->photo)); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="dots" id="slider-dots-container"></div>
        </div>

        
        <div class="action-buttons">

            <div class="action-btn" onclick="openPage('user/recharge')">
                <img src="https://api.iconify.design/solar:card-send-bold-duotone.svg?color=%23e8c26b">
                <div>Isi Ulang</div>
            </div>

            <div class="action-btn" onclick="openPage('/withdraw')">
                <img src="https://api.iconify.design/solar:wallet-money-bold-duotone.svg?color=%23e8c26b">
                <div>Withdraw</div>
            </div>

            <div class="action-btn" onclick="openPage('/promo')">
                <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%23e8c26b">
                <div>Hadiah</div>
            </div>

            <div class="action-btn" onclick="openPage('https://t.me/+CXtgwO55KGkxY2E9')">
                <img src="https://api.iconify.design/solar:headphones-round-sound-bold-duotone.svg?color=%23e8c26b">
                <div>Telegram</div>
            </div>

        </div>

        
        <div class="tabs">
            <button class="tab active" onclick="switchTab(event, 'daily-income')">VIP</button>
            <button class="tab" onclick="switchTab(event, 'welfare-plan')">Plus</button>
        </div>

        
        <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;

        $packageOne = Package::where('Status', '!=', 'inactive')->where('tab', 'vip')->get();
        $packagetwo = Package::where('Status', '!=', 'inactive')->where('tab', 'fixed')->get();
        $packagethree = Package::where('Status', '!=', 'inactive')->where('tab', 'event')->get();
        ?>

        <div class="content-wrapper">

            
            <div id="daily-income" class="plan-list">

                <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $myVip = \App\Models\Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status','active')->first(); ?>

                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>

                        <div class="plan-body">
                            <div class="plan-image-container">
                                <img src="<?php echo e(asset($element->photo)); ?>" class="plan-image">
                            </div>

                            <div class="plan-details">
                                <div class="detail-item"><span>Harga :</span><span
                                        class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span>Pendapatan Perhari :</span><span
                                        class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span>Siklus :</span><span
                                        class="value"><?php echo e($element->validity); ?> Hari</span></div>
                                <div class="detail-item"><span>Total Pendapatan :</span><span
                                        class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span>
                                </div>
                            </div>
                        </div>

                        <?php if($myVip): ?>
                            <button class="buy-btn" disabled>Aktif</button>
                        <?php elseif($element->status == 'coming'): ?>
                            <button class="buy-btn" disabled>Coming</button>
                        <?php else: ?>
                            <button class="buy-btn"
                                onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">Beli Sekarang</button>
                        <?php endif; ?>
                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            
            <div id="welfare-plan" class="plan-list" style="display:none;">

                <?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="plan-card">

                        <h3 class="plan-title"><?php echo e($element['name']); ?></h3>

                        <div class="plan-body">

                            <div class="plan-image-container">
                                <img src="<?php echo e(asset($element['photo'])); ?>" class="plan-image">
                            </div>

                            <div class="plan-details">
                                <div class="detail-item"><span>Harga :</span><span
                                        class="value"><?php echo e(price($element['price'])); ?></span></div>
                                <div class="detail-item"><span>Pendapatan Perhari :</span><span
                                        class="value"><?php echo e(price($element['daily_limit'])); ?></span></div>
                                <div class="detail-item"><span>Siklus :</span><span
                                        class="value"><?php echo e($element['validity']); ?> Hari</span></div>
                                <div class="detail-item"><span>Total Pendapatan :</span><span
                                        class="value"><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></span>
                                </div>
                            </div>

                        </div>

                        <button class="buy-btn"
                            onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">Beli Sekarang</button>

                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

        </div>

    </div>

    
    <div class="bottom-nav">

        <div class="nav-item" onclick="openPage('/')">
            <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white">
            <div>Home</div>
        </div>

        <div class="nav-item" onclick="openPage('/my/vip')">
            <img src="https://api.iconify.design/solar:chart-bold.svg?color=white">
            <div>Investasi</div>
        </div>

        <div class="nav-item" onclick="openPage('/my-team')">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white">
            <div>Team</div>
        </div>

        <div class="nav-item active" onclick="openPage('/mine')">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white">
            <div>Profil</div>
        </div>

    </div>

    <script>
        function openPage(url) {
            window.location.href = url;
        }

        document.addEventListener('DOMContentLoaded', () => {

            const slider = document.getElementById('main-slider');
            const dotsContainer = document.getElementById('slider-dots-container');
            const slides = Array.from(slider.children);
            let dots = [];
            let current = 0;

            slides.forEach((_, i) => {
                const dot = document.createElement('div');
                dot.classList.add('dot');

                dot.addEventListener('click', () => goTo(i));

                dotsContainer.appendChild(dot);
                dots.push(dot);
            });

            function goTo(i) {
                current = i;
                slider.style.transform = `translateX(-${i * 100}%)`;
                dots.forEach((d, idx) => d.classList.toggle('active', idx === current));
            }

            goTo(0);

            if (slides.length > 1) {
                setInterval(() => {
                    current = (current + 1) % slides.length;
                    goTo(current);
                }, 3000);
            }
        });

        function switchTab(evt, id) {
            document.querySelectorAll('.plan-list').forEach(list => list.style.display = 'none');
            document.getElementById(id).style.display = 'block';

            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            evt.currentTarget.classList.add('active');
        }
    </script>

</body>

</html>
<?php /**PATH /home/speedeku/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>