<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
<title>Profil VIP - Tema Hijau</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&family=Orbitron:wght@600;700&display=swap" rel="stylesheet">

<style>
:root {
  --green-100: #eafaf0;
  --green-200: #d1f4da;
  --green-300: #a8e9b8;
  --green-400: #4bd07a;
  --green-500: #1fa85a;
  --green-600: #137a41;
  --text-dark: #0f2b17;
  --muted: #6b7a6a;
  --shadow: 0 8px 24px rgba(17,73,36,0.12);
}

/* RESET */
*{margin:0;padding:0;box-sizing:border-box}

html,body{height:100%}

/* *** FIX SCROLL *** */
body {
  background: linear-gradient(180deg,#ffffff 0%, var(--green-100) 100%);
  font-family: 'Poppins', sans-serif;
  color: var(--text-dark);
  overflow-y: auto !important;        /* ← FIX scroll */
  padding-bottom: 0 !important;       /* ← hilangkan padding bawaan */
}

.container{
  max-width:720px;
  margin:24px auto 0;
  padding:0 16px 180px;               /* ← ruang agar menu tidak ketutup navbar */
}

.header-box {
  background: #ffffff;
  border-radius:20px;
  padding:18px;
  display:flex;
  gap:18px;
  align-items:center;
  box-shadow:var(--shadow);
  border:1px solid rgba(31,168,90,0.08);
}

.avatar-box{
  width:92px; height:92px;
  border-radius:50%;
  overflow:hidden;
  border:4px solid #fff;
  box-shadow:0 6px 18px rgba(31,168,90,0.12);
}
.avatar-box img{width:100%;height:100%;object-fit:cover}

.vip-badge{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding:6px 10px;
  border-radius:999px;
  font-weight:700;
  font-size:12px;
  background:linear-gradient(90deg,var(--green-300),var(--green-100));
  color:var(--green-600);
  box-shadow:0 4px 10px rgba(31,168,90,0.08)
}

.header-text .id{
  font-family:'Orbitron',sans-serif;
  font-weight:700;
  color:var(--green-600);
  font-size:18px;
  margin-top:6px
}
.balance-label{font-size:13px;color:var(--muted);margin-top:6px}
.balance-amount{font-size:28px;font-weight:800;color:var(--text-dark);margin-top:4px}

.sub-stats{display:flex;gap:12px;margin:18px 0}
.sub-stat{
  flex:1;
  background:linear-gradient(180deg, #ffffff, var(--green-100));
  padding:12px;
  border-radius:14px;
  text-align:center;
  box-shadow:0 10px 18px rgba(17,73,36,0.04);
  border:1px solid rgba(31,168,90,0.06)
}
.sub-stat .label{font-size:13px;color:var(--muted);font-weight:600}
.sub-stat .value{font-size:16px;font-weight:800;color:var(--green-500);margin-top:6px}

.menu-container{margin-top:6px}
.menu-title{
  font-size:18px;
  font-weight:800;
  color:var(--green-600);
  font-family:'Orbitron',sans-serif;
  margin-bottom:10px
}

/* MENU MENURUN 1 KOLOM */
.menu-grid{
  display:grid;
  grid-template-columns:1fr;
  gap:12px;
}

.menu-item{
  background:#ffffff;
  border-radius:14px;
  padding:16px;
  display:flex;
  align-items:center;
  gap:14px;
  text-align:left;
  box-shadow:0 12px 20px rgba(17,73,36,0.04);
  border:1px solid rgba(31,168,90,0.06);
  transition:transform .18s ease, box-shadow .18s ease;
}

.menu-item i{
  font-size:26px;
  color:var(--green-500)
}

.menu-item .menu-text{
  font-weight:700;
  font-size:16px;
  color:var(--text-dark)
}

.menu-item:hover{
  transform:translateY(-6px);
  box-shadow:0 20px 40px rgba(17,73,36,0.08)
}

.menu-item a, .menu-item {text-decoration:none}

/* NAVBAR BAWAH */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 100%;
  max-width: 720px;
  background: #ffffff;
  border-radius: 20px 20px 0 0;
  box-shadow: 0 -8px 25px rgba(17,73,36,0.12);
  border-top: 2px solid rgba(31,168,90,0.12);
  padding: 10px 0;
  display: flex;
  justify-content: space-around;
  align-items: center;
  z-index: 999;
}

.bottom-nav .item {
  display: flex;
  flex-direction: column;
  align-items: center;
  text-decoration: none;
  font-size: 12px;
  font-weight: 600;
  color: var(--muted);
  width: 20%;
  gap: 6px;
  opacity: 0.85;
  transition: all 0.25s ease;
}

.bottom-nav .item img {
  width: 28px;
  height: 28px;
  object-fit: contain;
  transition: transform .25s ease;
}

.bottom-nav .item:hover img { transform: translateY(-4px) scale(1.05); }
.bottom-nav .item:hover { opacity: 1; }

.bottom-nav .item.active {
  color: var(--green-600);
  opacity: 1;
}
.bottom-nav .item.active img { transform: scale(1.15); }

</style>
</head>

<body>

<div class="container">

  <header class="header-box">
    <div class="avatar-box">
      <img src="6129934559768939426.jpg" alt="Avatar">
    </div>

    <div class="header-text">
      <div class="vip-badge"><i class="fas fa-crown"></i></div>
      <div class="id">Card: <?php echo e(auth()->user()->phone ?? '-'); ?></div>
      <div class="balance-label">Saldo Akun</div>
      <div class="balance-amount"><?php echo e(price(auth()->user()->balance ?? 0)); ?></div>
    </div>
  </header>

  <section class="sub-stats">
    <div class="sub-stat">
      <div class="label">Total Penarikan</div>
      <div class="value"><?php echo e(price(\App\Models\Withdrawal::where('user_id', auth()->id() ?? 0)->where('status','approved')->sum('amount'))); ?></div>
    </div>

    <div class="sub-stat">
      <div class="label">Total Deposit</div>
      <div class="value"><?php echo e(price(\App\Models\Deposit::where('user_id', auth()->id() ?? 0)->where('status','approved')->sum('amount'))); ?></div>
    </div>
  </section>

  <section class="menu-container">
    <div class="menu-title">Menu</div>

    <div class="menu-grid">

      <a href="/history" class="menu-item">
        <i class="fas fa-book"></i>
        <span class="menu-text">History Akun</span>
      </a>

      <a href="/my/vip" class="menu-item">
        <i class="fas fa-chart-bar"></i>
        <span class="menu-text">Produk Saya</span>
      </a>

      <a href="/service" class="menu-item">
        <i class="fas fa-briefcase"></i>
        <span class="menu-text">Call center</span>
      </a>

      <a href="/add/card" class="menu-item">
        <i class="fas fa-credit-card"></i>
        <span class="menu-text">Kartu Bank</span>
      </a>

      <a href="https://chat.whatsapp.com/J2cy9JEfrPn9i1INX9gi9k?mode=wwt" target="_blank" class="menu-item">
        <i class="fab fa-whatsapp"></i>
        <span class="menu-text">Grup WA</span>
      </a>

      <a href="/logout" class="menu-item">
        <i class="fas fa-right-from-bracket"></i>
        <span class="menu-text">Keluar</span>
      </a>

    </div>
  </section>

</div>

<nav class="bottom-nav" aria-label="Footer navigation">

  <a href="/" class="item active">
    <img src="/public/site/img/footer/home_active.png" />
    <p>Home</p>
  </a>

  <a href="/vip" class="item">
    <img src="/public/site/img/footer/invest.png" />
    <p>Invest</p>
  </a>

  <a href="/my-team" class="item">
    <img src="/public/site/img/footer/notice.png" />
    <p>Team</p>
  </a>

  <a href="/mine" class="item">
    <img src="/public/site/img/footer/account.png" />
    <p>Account</p>
  </a>

</nav>

</body>
</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>