<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <link rel="icon" type="image/png" href="<?php echo e(setting('logo')); ?>">
  <title>Login</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-yellow: #ffc800;
      --yellow-dark: #d4a600;
      --yellow-soft: #fff4c2;
      --text-dark: #222;
      --white: #ffffff;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #fff, #ffe89c);
      color: var(--text-dark);
      overflow-x: hidden;
      position: relative;
    }

    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: var(--white);
      border-radius: 20px;
      box-shadow: 0 0 25px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      position: relative;
      border: 2px solid var(--primary-yellow);
    }

    /* HEADER */
    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      position: relative;
      background: var(--primary-yellow);
      box-shadow: 0 4px 15px rgba(255, 200, 0, 0.5);
    }

    .back-arrow {
      font-size: 24px;
      color: #000;
      text-decoration: none;
      position: absolute;
      left: 15px;
    }

    .header-title {
      font-size: 22px;
      font-weight: 700;
      text-align: center;
      flex-grow: 1;
      color: #000;
    }

    /* LOGO BULAT */
    .logo-wrap {
      width: 110px;
      height: 110px;
      margin: 25px auto 10px;
      border-radius: 50%;
      overflow: hidden;
      border: 4px solid var(--primary-yellow);
      box-shadow: 0 0 15px rgba(255, 200, 0, 0.6);
    }

    .logo-wrap img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    /* CONTAINER */
    .auth-container {
      padding: 25px 25px 40px;
      position: relative;
      z-index: 1;
    }

    /* TAB */
    .tab-navigation {
      display: flex;
      background: var(--yellow-soft);
      border-radius: 12px;
      padding: 6px;
      margin-bottom: 25px;
      border: 1px solid var(--primary-yellow);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 10px;
      cursor: pointer;
      background: transparent;
      color: #000;
      transition: 0.3s;
      text-decoration: none;
    }

    .tab.active {
      background: var(--primary-yellow);
      color: #000;
      box-shadow: 0 0 10px rgba(255, 200, 0, 0.6);
    }

    /* INPUT */
    .input-group {
      display: flex;
      align-items: center;
      background: #fff7d4;
      border: 1px solid var(--primary-yellow);
      border-radius: 14px;
      margin-bottom: 18px;
      overflow: hidden;
      transition: 0.3s;
    }

    .input-group:focus-within {
      border-color: var(--yellow-dark);
      box-shadow: 0 0 12px rgba(255, 200, 0, 0.6);
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: var(--yellow-dark);
      font-size: 18px;
      border-right: 1px solid rgba(255, 200, 0, 0.3);
    }

    .input-field {
      flex: 1;
      padding: 15px;
      font-size: 15px;
      background: transparent;
      border: none;
      color: #000;
    }

    .input-field:focus {
      outline: none;
    }

    .forgot-link {
      display: block;
      text-align: right;
      font-size: 14px;
      color: var(--yellow-dark);
      margin-top: -5px;
      margin-bottom: 15px;
      text-decoration: none;
    }

    /* BUTTON */
    .submit-btn {
      width: 100%;
      padding: 15px;
      background: var(--primary-yellow);
      color: #000;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 700;
      cursor: pointer;
      margin-top: 10px;
      transition: 0.3s;
      box-shadow: 0 0 15px rgba(255, 200, 0, 0.6);
    }

    .submit-btn:hover {
      background: var(--yellow-dark);
      transform: scale(1.02);
    }
  </style>
</head>

<body>

  <div class="page-wraper">
    <!-- Header -->
    <header class="header">
      <h1 class="header-title">Login</h1>
    </header>

    <!-- LOGO BULAT -->
    <div class="logo-wrap">
      <img src="<?php echo e(setting('logo')); ?>" alt="Logo">
    </div>

    <!-- Form Login -->
    <div class="auth-container">

      <div class="tab-navigation">
        <button class="tab active">Login</button>
        <a href="<?php echo e(route('register')); ?>" class="tab">Daftar</a>
      </div>

      <form action="<?php echo e(url('login')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <a href="#" class="forgot-link">Lupa kata sandi?</a>

        <button type="submit" class="submit-btn">Masuk Sekarang</button>
      </form>
    </div>
  </div>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>