<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Register</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --yellow: #ffcc00;
      --yellow-light: #ffe680;
      --white: #ffffff;
      --text-dark: #333;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(to bottom, var(--yellow-light), var(--white));
      color: var(--text-dark);
    }

    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: var(--white);
      border-radius: 0;
      box-shadow: none;
    }

    /* HEADER */
    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      background: var(--yellow);
    }

    .back-arrow {
      font-size: 24px;
      color: #000;
      text-decoration: none;
      position: absolute;
      left: 15px;
    }

    .header-title {
      margin: 0 auto;
      font-size: 22px;
      font-weight: 700;
      color: #000;
    }

    /* LOGO BULAT */
    .logo-wrapper {
      display: flex;
      justify-content: center;
      margin-top: 20px;
    }

    .logo-img {
      width: 110px;
      height: 110px;
      border-radius: 50%;
      border: 4px solid var(--yellow);
      object-fit: cover;
      background: #fff;
      box-shadow: 0 4px 10px rgba(0,0,0,0.15);
    }

    /* BANNER */
    .banner-container {
      margin-top: 20px;
    }

    .banner-image {
      width: 100%;
      display: block;
      border-radius: 12px;
    }

    /* CONTENT BOX */
    .auth-container {
      padding: 25px;
      background: #fff;
      border-radius: 20px 20px 0 0;
      margin-top: -10px;
    }

    .tab-navigation {
      display: flex;
      background: var(--yellow-light);
      border-radius: 10px;
      padding: 6px;
      margin-bottom: 25px;
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 8px;
      cursor: pointer;
      background: transparent;
      color: #444;
      text-decoration: none;
    }

    .tab.active {
      background: var(--yellow);
      color: #000;
    }

    /* INPUT */
    .input-group {
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      border: 1px solid #ddd;
      border-radius: 12px;
      overflow: hidden;
      background: #fff;
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: #555;
    }

    .input-field {
      flex: 1;
      padding: 14px;
      border: none;
      font-size: 15px;
    }

    .input-field:focus {
      outline: none;
    }

    /* CAPTCHA */
    .captcha-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
    }

    .captcha-box {
      padding: 10px 20px;
      background: var(--yellow);
      font-size: 22px;
      font-weight: 700;
      letter-spacing: 4px;
      border-radius: 10px;
      user-select: none;
      color: #000;
    }

    .refresh-btn {
      background: none;
      border: none;
      font-size: 22px;
      cursor: pointer;
      color: #000;
    }

    .error-message {
      color: red;
      font-weight: bold;
      text-align: center;
      margin-bottom: 10px;
      display: none;
    }

    /* BUTTON */
    .submit-btn {
      width: 100%;
      padding: 15px;
      background: var(--yellow);
      color: #000;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 700;
      cursor: pointer;
      margin-top: 15px;
    }

    .submit-btn:hover {
      background: #ffdb4d;
    }
  </style>
</head>

<body>

  <div class="page-wraper">

    <!-- HEADER -->
    <header class="header">
      <h1 class="header-title">Register</h1>
    </header>

    <!-- LOGO BULAT -->
    <div class="logo-wrapper">
      <img src="<?php echo e(setting('logo')); ?>" class="logo-img" alt="Logo">
    </div>

    <!-- FORM -->
    <div class="auth-container">

      <div class="tab-navigation">
        <a href="<?php echo e(route('login')); ?>" class="tab">Login</a>
        <button class="tab active">Daftar</button>
      </div>

      <form id="registerForm" action="<?php echo e(route('register')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-user input-icon"></i>
          <input type="text" name="name" class="input-field" placeholder="Username" required>
        </div>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password_confirmation" class="input-field" placeholder="Konfirmasi Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-ticket-alt input-icon"></i>
          <input type="text" id="referralCode" name="ref_id" class="input-field" placeholder="Kode Refferal">
        </div>

        <div class="captcha-container">
          <div id="captchaBox" class="captcha-box"></div>
          <button type="button" class="refresh-btn" onclick="generateCaptcha()">
            <i class="fas fa-sync-alt"></i>
          </button>
        </div>

        <div class="input-group">
          <i class="fas fa-key input-icon"></i>
          <input type="text" name="otp" id="otpInput" class="input-field" placeholder="Masukkan Kode Captcha " required>
        </div>

        <div id="errorMsg" class="error-message">Kode OTP salah!</div>

        <button type="submit" class="submit-btn">Daftar Sekarang</button>

      </form>
    </div>
  </div>

  <!-- SCRIPT TIDAK DIUBAH -->
  <script>
    function generateCaptcha() {
      const captchaBox = document.getElementById("captchaBox");
      const chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
      let otp = "";
      for (let i = 0; i < 6; i++) otp += chars.charAt(Math.floor(Math.random() * chars.length));
      captchaBox.textContent = otp;
      captchaBox.dataset.code = otp;
    }
    document.addEventListener("DOMContentLoaded", generateCaptcha);

    document.getElementById("registerForm").addEventListener("submit", function (e) {
      const userOtp = document.getElementById("otpInput").value.trim().toUpperCase();
      const correctOtp = document.getElementById("captchaBox").dataset.code;
      const errorMsg = document.getElementById("errorMsg");

      if (userOtp !== correctOtp) {
        e.preventDefault();
        errorMsg.style.display = "block";
        generateCaptcha();
      }
    });

    document.addEventListener("DOMContentLoaded", function () {
      const urlParams = new URLSearchParams(window.location.search);
      const inviteCode = urlParams.get("inviteCode");
      if (inviteCode) document.getElementById("referralCode").value = inviteCode;
    });
  </script>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>