<!DOCTYPE html>   
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>My Vip</title>

    <style>
        :root {
            --gold: #f8c102;
            --gold-dark: #d6a402;
            --white: #ffffff;
            --text-dark: #333;
            --soft-gray: #f5f5f5;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--soft-gray);
            color: var(--text-dark);
            overflow-x: hidden;
        }

        .main-container {
            max-width: 600px;
            margin: 0 auto;
            min-height: 100vh;
            background: var(--white);
            border-radius: 20px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding-bottom: 80px;
        }

        .header {
            background: var(--white);
            color: var(--gold-dark);
            padding: 15px 20px;
            text-align: center;
            font-weight: 700;
            font-size: 1.3rem;
            border-bottom: 3px solid var(--gold);
        }

        /* Tabs */
        .tabs {
            display: flex;
            background: #fff7db;
            margin: 15px;
            border-radius: 12px;
            border: 1px solid var(--gold);
        }
        .tab {
            flex: 1;
            padding: 12px;
            text-align: center;
            background: transparent;
            font-weight: 600;
            color: #8a6b00;
            cursor: pointer;
        }
        .tab.active {
            background: var(--gold);
            color: #fff;
            box-shadow: 0 0 8px rgba(248,193,2,0.5);
        }

        /* Plan cards */
        .content-wrapper { padding: 0 15px 90px; }
        .plan-list { display: flex; flex-direction: column; gap: 15px; }

        .plan-card {
            background: var(--white);
            border-radius: 15px;
            border: 1px solid #e5e5e5;
            padding: 15px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        }

        .plan-title {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--gold-dark);
        }

        .plan-body { display: flex; gap: 15px; align-items: center; }

        .plan-image-container { width: 90px; height: 90px; border-radius: 12px; overflow: hidden; }
        .plan-image { width: 100%; height: 100%; object-fit: cover; }

        .plan-details { flex: 1; font-size: 0.9rem; color: #444; }
        .detail-item { display: flex; justify-content: space-between; margin-bottom: 5px; }
        .detail-item .value { color: var(--gold-dark); font-weight: 700; }

        .buy-btn {
            width: 100%;
            margin-top: 10px;
            padding: 10px;
            background: var(--gold);
            color: #fff;
            border: none;
            border-radius: 50px;
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 0 12px rgba(248,193,2,0.3);
        }
        .buy-btn:disabled {
            background: #bbb;
            color: #eee;
        }

        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 600px;
            background: var(--white);
            border-top: 2px solid var(--gold);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.08);
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #444;
            font-size: 12px;
        }
        .nav-item.active {
            color: var(--gold-dark);
            font-weight: 700;
        }

        .nav-icon {
            font-size: 26px;
            margin-bottom: 4px;
            color: var(--gold-dark);
        }
    </style>
</head>

<body>

    <div class="header">Good World Time Investment</div>

    <div class="tabs">
        <button class="tab active" onclick="switchTab(event, 'daily-income')">Harian</button>
        <button class="tab" onclick="switchTab(event, 'welfare-plan')">Mingguan</button>
    </div>

    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $menu = PackageCategory::get()->toArray();
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="main-container">
    <div class="content-wrapper">
        <div id="daily-income" class="plan-list">
            <?php if($packageOne->count() > 0): ?>
                <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first(); ?>
                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span>Harga :</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span>Pendapatan Perhari:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span>Siklus :</span><span class="value"><?php echo e($element->validity); ?> Hari</span></div>
                                <div class="detail-item"><span>Total Pendapatan :</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>
                        <?php if($myVip): ?>
                            <button class="buy-btn" disabled>Aktif</button>
                        <?php elseif($element->status == 'coming'): ?>
                            <button class="buy-btn" disabled>Coming</button>
                        <?php else: ?>
                            <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">Beli Sekarang</button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p style="text-align:center; padding:20px;">No plans available.</p>
            <?php endif; ?>
        </div>

        <div id="welfare-plan" class="plan-list" style="display:none;">
            <?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element['name']); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element['photo'])); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span>Harga :</span><span class="value"><?php echo e(price($element['price'])); ?></span></div>
                            <div class="detail-item"><span>Pendapatan Perhari :</span><span class="value"><?php echo e(price($element['daily_limit'])); ?></span></div>
                            <div class="detail-item"><span>Siklus :</span><span class="value"><?php echo e($element['validity']); ?> Hari</span></div>
                            <div class="detail-item"><span>Total Pendapatan :</span><span class="value"><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></span></div>
                        </div>
                    </div>
                    <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">Beli Sekarang</button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
        <div class="nav-icon">🏠</div>
        <div>Home</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my/vip'">
        <div class="nav-icon">📦</div>
        <div>Investasi</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my-team'">
        <div class="nav-icon">👥</div>
        <div>Team</div>
    </div>

    <div class="nav-item active" onclick="window.location.href='/mine'">
        <div class="nav-icon">👤</div>
        <div>Profil</div>
    </div>
</div>

<script>
function openPage(url){ window.location.href = url; }
function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}
</script>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/myvip.blade.php ENDPATH**/ ?>