<!DOCTYPE html>    
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Pesanan Saya</title>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<style>
:root {
    --primary-color: #1e40af;
    --background-color: #0f172a;
    --text-color: #fff;
    --light-text-color: #94a3b8;
    --white-color: #1e293b;
    --gray-bg: #334155;
    --success-color: #22c55e;
    --pending-color: #f59e0b;
    --failed-color: #ef4444;
}
* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    background: var(--background-color);
    width: 100%;
    overflow-x: hidden;
}
body {
    font-family: 'Poppins', sans-serif;
    color: var(--text-color);
    -webkit-font-smoothing: antialiased;
}
a { text-decoration: none; color: inherit; }
.main-container { 
    width: 100%;
    max-width: 600px; 
    margin: 0 auto;
    background: var(--background-color);
    min-height: 100vh;
    position: relative;
}
.header { 
    background: linear-gradient(135deg, #1e3a8a, #1e40af);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 2px 8px rgba(0,0,0,0.4);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    color: #fff;
    cursor: pointer;
    font-weight: bold;
}
.header .header-title {
    font-size: 1.2rem;
    font-weight: 600;
    color: #fff;
}
.tabs { 
    display: flex;
    background: #1e293b;
    border-radius: 12px;
    padding: 5px;
    margin: 20px 15px;
    box-shadow: inset 0 1px 3px rgba(255,255,255,0.05);
}
.tab {
    flex: 1;
    padding: 10px;
    text-align: center;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    border: none;
    background: transparent;
    color: var(--light-text-color);
    transition: all 0.3s ease;
    border-radius: 10px;
}
.tab.active {
    background: linear-gradient(135deg, #2563eb, #3b82f6);
    color: #fff;
    box-shadow: 0 4px 15px rgba(59,130,246,0.3);
}
.content-wrapper { padding: 10px 15px 100px; }
.plan-list {
    display: flex;
    flex-direction: column;
    gap: 15px;
}
.plan-list.hidden { display: none; }
.plan-card {
    background: var(--white-color);
    border-radius: 16px;
    padding: 16px;
    display: flex;
    flex-direction: column;
    box-shadow: 0 4px 15px rgba(0,0,0,0.4);
    transition: transform 0.2s ease;
}
.plan-card:hover { transform: translateY(-3px); }
.plan-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--text-color);
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.vip-group {
    display: inline-flex;
    align-items: center;
    background: linear-gradient(135deg, #16a34a, #22c55e);
    padding: 6px 10px;
    border-radius: 20px;
    color: #fff;
    font-size: 0.85rem;
    font-weight: 600;
    gap: 6px;
    text-decoration: none;
    box-shadow: 0 2px 8px rgba(0,0,0,0.3);
    transition: all 0.3s ease;
}
.vip-group:hover { opacity: 0.9; transform: translateY(-2px); }
.vip-group i { font-size: 1rem; }
.plan-body { display: flex; gap: 15px; align-items: center; }
.plan-image-container { width: 100px; height: 100px; flex-shrink: 0; }
.plan-image {
    width: 100%; height: 100%;
    border-radius: 10px; object-fit: cover;
}
.plan-details { flex: 1; display: flex; flex-direction: column; }
.detail-item {
    display: flex;
    justify-content: space-between;
    font-size: 0.9rem;
    padding: 6px 0;
    color: var(--light-text-color);
}
.detail-item .value { color: #38bdf8; font-weight: 600; }
.action-btn {
    width: 100%;
    margin-top: 15px;
    padding: 12px;
    background: linear-gradient(135deg, #2563eb, #3b82f6);
    color: #fff;
    border: none;
    border-radius: 8px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}
.action-btn:hover { opacity: 0.9; transform: translateY(-2px); }
.action-btn.countdown {
    background-color: #475569;
    cursor: default;
}
.no-record {
    text-align: center;
    padding: 40px 20px;
    color: var(--light-text-color);
    background: var(--white-color);
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
}
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, #002b5b, #004aad);
    display: flex;
    justify-content: space-around;
    padding: 10px 0;
    box-shadow: 0 -2px 15px rgba(0,0,0,0.4);
    z-index: 1000;
    border-top: 1px solid rgba(255,255,255,0.15);
}
.nav-item { display: flex; flex-direction: column; align-items: center; color: var(--subtext-color); text-decoration: none; transition: all 0.3s ease; }
.nav-item img { width: 28px; height: 28px; margin-bottom: 4px; filter: brightness(2); transition: filter 0.3s ease, transform 0.3s ease; }
.nav-item:hover img { transform: scale(1.1); }
.nav-label { font-size: 12px; }
</style>
</head>
<body>
<div class="main-container">
    <div class="header">
        <span class="back-btn" onclick="history.back()"></span>
        <h1 class="header-title">Pesanan Saya</h1>
    </div>
    
    <div class="tabs">
        <button class="tab active" onclick="switchTab(event, 'daily-income')">Card VIP</button>
        <button class="tab" onclick="switchTab(event, 'welfare-plan')">Tesla Plus</button>
    </div>

    <?php
        use \App\Models\Package;
        use \App\Models\Purchase;
        use \App\Models\UserLedger;

        $purchasedPackageIds = Purchase::where('user_id', auth()->id())->where('status', 'active')->pluck('package_id');
        $packageOne = Package::whereIn('id', $purchasedPackageIds)->where('tab','vip')->get();
        $packagetwo = Package::whereIn('id', $purchasedPackageIds)->where('tab', 'fixed')->get();
        $packagethree = Package::whereIn('id', $purchasedPackageIds)->where('tab', 'event')->get();
    ?>  

    <div class="content-wrapper">
        <div id="daily-income" class="plan-list">
           <?php if($packageOne->count() > 0): ?>
               <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $myVip = Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
                        $last_claim = UserLedger::where(['user_id' => auth()->id(), 'reason' => 'daily_claim_'.$element->id])->latest()->first();
                        $lastPurchaseDate = $last_claim->created_at ?? $myVip->created_at; 
                        $diffInHours = $lastPurchaseDate->diffInHours(now());
                        $canClaim = !UserLedger::where(['user_id' => auth()->id(), 'reason' => 'daily_claim_'.$element->id])->whereDate('created_at', today())->exists();
                    ?>  
                    <div class="plan-card">
                        <div class="plan-title">
                            <span><?php echo e($element->name); ?></span>
                            <?php if($myVip): ?>
                            <a href="https://chat.whatsapp.com/LMaJWBWm8nt0GYxPuJYcr8?mode=ems_copy_t" target="_blank" class="vip-group">
                                <i class="fab fa-whatsapp"></i>
                                <span>Grup VIP</span>
                            </a>
                            <?php endif; ?>
                        </div>

                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span class="label">Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span class="label">Pendapatan Harian:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span class="label">Total Pendapatan:</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>

                        <?php if($diffInHours < 24): ?>
                            <button class="action-btn countdown" id="countdown-<?php echo e($element->id); ?>">00j 00m 00d</button>
                        <?php elseif($canClaim): ?>
                            <button class="action-btn" onclick="window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'">Klaim Sekarang</button>
                        <?php else: ?>
                            <button class="action-btn countdown" disabled>Sudah Diklaim</button>
                        <?php endif; ?>
                        
                        <script>
                            (function() {
                                let lastPurchaseDate = new Date("<?php echo e($lastPurchaseDate); ?>");
                                let endTime = new Date(lastPurchaseDate.getTime() + 24 * 60 * 60 * 1000);
                                const countdownEl = document.getElementById("countdown-<?php echo e($element->id); ?>");
                                if (!countdownEl) return;
                                function updateCountdown() {
                                    let now = new Date().getTime();
                                    let distance = endTime - now;
                                    if (distance < 0) {
                                        clearInterval(countdownInterval);
                                        countdownEl.style.display = 'none';
                                        const claimButton = document.querySelector(`button[onclick*="vip_id=<?php echo e($element->id); ?>"]`);
                                        if (claimButton) claimButton.style.display = 'block';
                                        return;
                                    }
                                    let h = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                                    let m = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                                    let s = Math.floor((distance % (1000 * 60)) / 1000);
                                    countdownEl.innerText = `${h.toString().padStart(2, '0')}j ${m.toString().padStart(2, '0')}m ${s.toString().padStart(2, '0')}d`;
                                }
                                if (countdownEl.classList.contains('countdown')) {
                                    var countdownInterval = setInterval(updateCountdown, 1000);
                                    updateCountdown();
                                }
                            })();
                        </script>
                    </div>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           <?php else: ?>
               <div class="no-record">Tidak ada rencana harian aktif.</div>
           <?php endif; ?>
        </div>
        <div id="welfare-plan" class="plan-list hidden">
            <?php $welfarePackages = $packagetwo->merge($packagethree); ?>
            <?php if($welfarePackages->count() > 0): ?>
                <?php $__currentLoopData = $welfarePackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $myVip = Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
                    ?>
                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span class="label">Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span class="label">Siklus:</span><span class="value"><?php echo e($element->validity); ?> hari</span></div>
                                <div class="detail-item"><span class="label">Total Keuntungan:</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>
                        <?php if($myVip->created_at->addDays($element->validity) <= now()): ?>
                            <button class="action-btn" onclick="window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'">Klaim Sekarang</button>
                        <?php else: ?>
                            <button class="action-btn countdown" disabled>Berjalan</button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="no-record">Tidak ada rencana kesejahteraan aktif.</div>
            <?php endif; ?>
        </div>
    </div>
    
     <!-- NAVBAR BAWAH -->
    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my/vip'">
            <img src="https://api.iconify.design/solar:chart-bold.svg?color=white">
            <div class="nav-label">Investasi</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white">
            <div class="nav-label">Profil</div>
        </div>
    </div>
</div>
<script src="/assets/app/js/jquery.js"></script>
<script>
function switchTab(evt, tabId) {
    document.querySelectorAll('.plan-list').forEach(c => c.classList.add('hidden'));
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    const activeTab = document.getElementById(tabId);
    if (activeTab) activeTab.classList.remove('hidden');
    evt.currentTarget.classList.add('active');
}
</script>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/runnlvbg/card5dgtal.com/resources/views/app/main/myvip.blade.php ENDPATH**/ ?>