<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover">
<title>Mine</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --maroon-dark:#3B0A0A;
  --maroon-main:#7F1D1D;
  --maroon-soft:#991B1B;
  --maroon-border:#B91C1C;
  --maroon-accent:#FCA5A5;
  --black-main:#0B0B0B;
  --black-soft:#121212;
}

*{box-sizing:border-box;margin:0;padding:0}

body{
  font-family:'Poppins',sans-serif;
  color:#F5F5F5;
  padding-bottom:90px;
  background:radial-gradient(circle at top,#1a1a1a 0%,#000000 70%);
}

/* WRAPPER */
.main-container{
  max-width:520px;
  margin:18px auto;
  padding:0 14px;
}

/* HEADER */
.header{
  background:rgba(20,10,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  border-radius:14px;
  padding:14px 18px;
  display:flex;
  align-items:center;
  gap:12px;
  margin-bottom:18px;
}

.header-title{
  font-size:18px;
  font-weight:700;
  color:#FFE4E6;
}

/* PROFILE CARD */
.profile-action-card{
  background:linear-gradient(135deg,rgba(30,10,10,.9),rgba(10,5,5,.88));
  border:1.5px solid var(--maroon-border);
  border-radius:18px;
  padding:18px;
  backdrop-filter:blur(14px);
  box-shadow:0 12px 35px rgba(0,0,0,.65);
  margin-bottom:18px;
}

.profile-top{
  display:flex;
  gap:14px;
  align-items:center;
}

.profile-avatar{
  width:64px;
  height:64px;
  border-radius:50%;
  border:2px solid var(--maroon-accent);
  object-fit:cover;
}

.profile-id{
  font-size:13px;
  color:#FECACA;
  font-weight:600;
}

.profile-label{
  font-size:13px;
  color:#FCA5A5;
}

.profile-balance{
  font-size:26px;
  font-weight:700;
  color:#FFFFFF;
}

/* DIVIDER */
.horizontal-divider{
  height:1px;
  background:rgba(185,28,28,.4);
  margin:14px 0;
}
.vertical-divider{
  width:1px;
  background:rgba(185,28,28,.4);
}

/* ACTION CARD */
.action-card{
  display:flex;
  height:90px;
}

.checkin-area,
.right-btn{
  flex:1;
  display:flex;
  align-items:center;
  justify-content:center;
  font-weight:600;
  cursor:pointer;
  color:#FFE4E6;
}

.checkin-area{
  background:rgba(40,10,10,.85);
  border-radius:12px 0 0 12px;
}

.right-area{
  flex:1;
  display:flex;
  flex-direction:column;
}

.right-btn{
  background:rgba(60,10,10,.85);
}

/* STATS */
.profile-stats{
  display:flex;
  gap:12px;
  margin-bottom:20px;
}

.stat-box{
  flex:1;
  background:rgba(40,10,10,.85);
  border:1px solid var(--maroon-border);
  border-radius:14px;
  padding:12px;
  text-align:center;
}

.stat-label{
  font-size:12px;
  color:#FCA5A5;
}

.stat-value{
  font-size:14px;
  font-weight:700;
  color:#FFFFFF;
}

/* MENU BUTTONS */
.action-buttons{
  display:flex;
  flex-direction:column;
  gap:14px;
  margin-bottom:20px;
}

.action-btn{
  display:flex;
  align-items:center;
  gap:14px;
  padding:14px 16px;
  border-radius:14px;
  background:rgba(20,10,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  cursor:pointer;
}

.action-btn img{
  width:38px;
}

.action-btn div{
  font-size:15px;
  font-weight:600;
  color:#FFE4E6;
}

/* LOGOUT */
.menu-item{
  display:flex;
  align-items:center;
  gap:12px;
  padding:14px;
  border-radius:14px;
  background:rgba(60,10,10,.85);
  border:1px solid #DC2626;
  text-decoration:none;
}

.menu-item img{
  width:36px;
}

.menu-text{
  font-size:15px;
  font-weight:700;
  color:#F87171;
}
</style>
</head>

<body>

<div class="main-container">

<div class="header">
  <div class="header-title">Taglichesgeld</div>
</div>

<div class="profile-action-card">
  <div class="profile-top">
    <img src="Gemini_Generated_Image_e13o3he13o3he13o.png" class="profile-avatar">
    <div>
      <div class="profile-id">ID : <?php echo e(auth()->user()->phone); ?></div>
      <div class="profile-label">Saldo Akun</div>
      <div class="profile-balance"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>
  </div>

  <div class="horizontal-divider"></div>

  <div class="action-card">
    <div class="checkin-area" onclick="location.href='/checkin'">Check-in</div>
    <div class="vertical-divider"></div>
    <div class="right-area">
      <div class="right-btn" onclick="openPage('/user/recharge')">Isi Ulang</div>
      <div class="right-btn" onclick="openPage('/withdraw')">Withdraw</div>
    </div>
  </div>
</div>

<div class="profile-stats">
  <div class="stat-box">
    <div class="stat-label">Total Penarikan</div>
    <div class="stat-value">
      <?php echo e(price(\App\Models\Withdrawal::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?>

    </div>
  </div>
  <div class="stat-box">
    <div class="stat-label">Total Deposit</div>
    <div class="stat-value">
      <?php echo e(price(\App\Models\Deposit::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?>

    </div>
  </div>
</div>

<div class="action-buttons">
  <div class="action-btn" onclick="location.href='/promo'"><div>Hadiah</div></div>
  <div class="action-btn" onclick="location.href='/history'"><div>Catatan</div></div>
  <div class="action-btn" onclick="location.href='/add/card'"><div>Kartu Bank</div></div>
  <div class="action-btn" onclick="location.href='/about-us'"><div>Tentang</div></div>
</div>

<a href="/logout" class="menu-item">
  <span class="menu-text">Keluar</span>
</a>

</div>

<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>