<!DOCTYPE html>   
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>Home</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">

    <style>
        :root {
            --primary-blue: #00eaff;
            --deep-blue: #021526;
            --light-blue: #0077ff;
            --white: #ffffff;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle at top, #021526 0%, #010b14 60%, #000 100%);
            color: var(--white);
            overflow-x: hidden;
            position: relative;
        }

        /* Container utama */
       .main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 20px;
    backdrop-filter: blur(10px);
    box-shadow: 0 0 30px rgba(0, 234, 255, 0.2);
    position: relative;
    animation: fadeIn 1s ease-in-out;
    padding-bottom: 80px; /* tambah ruang bawah supaya konten tidak ketimpa navbar */
}


        @keyframes fadeIn {
          from {opacity: 0; transform: translateY(10px);}
          to {opacity: 1; transform: translateY(0);}
        }

        /* Partikel latar */
        .particles {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            overflow: hidden;
            z-index: -1;
        }
        .particle {
            position: absolute;
            width: 6px; height: 6px;
            background: var(--primary-blue);
            border-radius: 50%;
            opacity: 0.6;
            animation: float 10s linear infinite;
        }
        @keyframes float {
            from { transform: translateY(100vh) scale(0.5); opacity: 0; }
            50% { opacity: 1; }
            to { transform: translateY(-10vh) scale(1); opacity: 0; }
        }

        /* Header */
        .header {
              background: linear-gradient(135deg, #002b5b, #004aad);
            color: var(--white);
            padding: 15px 20px;
            text-align: center;
            position: relative;
            font-weight: 600;
            font-size: 1.2rem;
            box-shadow: 0 0 20px rgba(0,234,255,0.3);
        }
        .back-btn {
            position: absolute;
            left: 20px;
            font-size: 28px;
            cursor: pointer;
            color: var(--white);
        }

        /* Slider */
        .slider-container {
          overflow: hidden;
          position: relative;
          width: 100%;
        }
        .slider {
          display: flex;
          width: 100%;
          transition: transform 0.6s ease;
        }
        .slide {
          min-width: 100%;
        }
        .slide img {
          width: 100%;
          height: 200px;
          object-fit: cover;
          border-bottom: 2px solid rgba(0, 234, 255, 0.3);
          box-shadow: 0 4px 20px rgba(0, 234, 255, 0.1);
          display: block;
        }

        /* Dots */
        .dots {
          display: flex;
          justify-content: center;
          margin-top: 10px;
        }
        .dot {
          width: 10px; height: 10px;
          margin: 0 4px;
          background: rgba(0,234,255,0.4);
          border-radius: 50%;
          cursor: pointer;
          transition: 0.3s;
        }
        .dot.active {
          background: #00eaff;
          box-shadow: 0 0 10px rgba(0,234,255,0.7);
        }

      /* ðŸ”· Area tombol menu */
/* ðŸ”· Area tombol menu (1 baris, 5 ikon sejajar) */
.action-buttons {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 18px 10px;
  background: linear-gradient(180deg, #0a0f1e, #0f1828);
  border-radius: 18px;
  box-shadow: inset 0 0 10px rgba(0, 180, 255, 0.15),
              0 0 15px rgba(0, 180, 255, 0.15);
  flex-wrap: nowrap; /* ðŸ”’ agar tidak turun ke baris kedua */
  overflow-x: auto; /* jika layar kecil tetap bisa digeser */
}

/* ðŸ”¹ Setiap tombol */
.action-btn {
  flex: 1; /* otomatis lebar merata */
  text-align: center;
  cursor: pointer;
  transition: all 0.3s ease;
  padding: 6px 0;
  min-width: 65px; /* menjaga proporsi di layar kecil */
}

/* ðŸ”¹ Ikon glowing */
.action-btn img {
  width: 44px;
  height: 44px;
  margin-bottom: 5px;
  transition: transform 0.3s ease, filter 0.3s ease;
  filter: brightness(2.6) contrast(1.2)
          drop-shadow(0 0 6px rgba(120, 200, 255, 0.8))
          drop-shadow(0 0 14px rgba(100, 180, 255, 0.5));
}

.action-btn:hover img {
  transform: scale(1.15);
  filter: brightness(3.2)
          drop-shadow(0 0 12px rgba(160, 240, 255, 1))
          drop-shadow(0 0 22px rgba(90, 200, 255, 0.8));
}

/* ðŸ”¹ Label teks */
.action-btn div {
  color: #e8f4ff;
  font-size: 13px;
  font-weight: 600;
  letter-spacing: 0.3px;
  text-shadow: 0 0 6px rgba(160, 230, 255, 0.4);
}

/* ðŸ”¹ Responsif biar tetap 5 ikon rapat tapi rapi */
@media (max-width: 480px) {
  .action-btn img {
    width: 38px;
    height: 38px;
  }
  .action-btn div {
    font-size: 12px;
  }
}


        /* Tabs */
        .tabs {
            display: flex;
            background: rgba(255,255,255,0.08);
            margin: 15px;
            border-radius: 12px;
            box-shadow: inset 0 0 10px rgba(0,234,255,0.3);
        }
        .tab {
            flex: 1;
            padding: 12px;
            text-align: center;
            border: none;
            background: transparent;
            font-weight: 600;
            color: rgba(255,255,255,0.7);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .tab.active {
            background: linear-gradient(135deg, #00eaff, #0077ff);
            color: #fff;
            box-shadow: 0 0 12px rgba(0,234,255,0.5);
        }

        /* Plan cards */
        .content-wrapper { padding: 0 15px 90px; }
        .plan-list { display: flex; flex-direction: column; gap: 15px; }
        .plan-card {
            background: rgba(255, 255, 255, 0.06);
            border-radius: 15px;
            box-shadow: 0 0 10px rgba(0,234,255,0.2);
            padding: 15px;
            backdrop-filter: blur(8px);
        }
        .plan-title {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 10px;
            text-shadow: 0 0 8px rgba(0,234,255,0.5);
        }
        .plan-body {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        .plan-image-container { width: 90px; height: 90px; border-radius: 12px; overflow: hidden; }
        .plan-image { width: 100%; height: 100%; object-fit: cover; border-radius: 12px; }
        .plan-details { flex: 1; font-size: 0.9rem; color: #ddd; }
        .detail-item { display: flex; justify-content: space-between; margin-bottom: 5px; }
        .detail-item .value { color: #00eaff; font-weight: 600; }

        .buy-btn {
            width: 100%;
            margin-top: 10px;
            padding: 10px;
            background: linear-gradient(135deg, #00eaff, #0077ff);
            color: #fff;
            border: none;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 0 12px rgba(0,234,255,0.3);
            transition: 0.3s;
        }
        .buy-btn:hover {
            box-shadow: 0 0 20px rgba(0,234,255,0.6);
            transform: scale(1.02);
        }
        .buy-btn:disabled { background: #777; cursor: not-allowed; }

        /* Floating Icon */
        .draggable-icon {
            position: fixed;
            bottom: 80px;
            right: 15px;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            box-shadow: 0 0 15px rgba(0,234,255,0.3);
            z-index: 999;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid rgba(0,234,255,0.4);
        }
        .draggable-icon img { width: 90%; height: 90%; border-radius: 50%; }
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 100%;
  max-width: 600px;
   background: linear-gradient(135deg, #002b5b, #004aad);
  backdrop-filter: blur(8px);
  display: flex;
  justify-content: space-around;
  padding: 10px 0;
  box-shadow: 0 -3px 15px rgba(0,234,255,0.3);
  z-index: 9999;
  border-top-left-radius: 15px;
  border-top-right-radius: 15px;
}

/* Style umum tombol nav */
.nav-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  color:white;
  text-decoration: none;
  font-size: 12px;
  user-select: none;
  transition: all 0.3s ease;
}

/* Item aktif */
.nav-item.active {
  color: white;
  font-weight: 600;
  text-shadow: 0 0 10px rgba(0,234,255,0.5);
}

.nav-icon {
  width: 26px;
  height: 26px;
  margin-bottom: 4px;
  transition: transform 0.3s ease, filter 0.3s ease;
  filter: brightness(0) invert(1); /* ðŸ”¥ membuat ikon berwarna putih */
}

.nav-item.active .nav-icon {
  filter: drop-shadow(0 0 8px var(--accent-color)) brightness(1.5) invert(1);
}

.nav-item:hover .nav-icon {
  transform: scale(1.15);
}

/* Efek neon animasi untuk ikon aktif */
@keyframes neonPulse {
  0% {
    transform: scale(1);
    filter: drop-shadow(0 0 8px rgba(0,234,255,0.8));
  }
  50% {
    transform: scale(1.08);
    filter: drop-shadow(0 0 16px rgba(0,234,255,1));
  }
  100% {
    transform: scale(1);
    filter: drop-shadow(0 0 8px rgba(0,234,255,0.8));
  }
}

/* Terapkan efek ke ikon aktif */
.nav-item.active img {
  animation: neonPulse 2.5s infinite ease-in-out;
  filter: brightness(0) invert(1); /* pastikan tetap putih solid */
}

</style>
</head>

<body>
    <div class="particles">
        <div class="particle" style="left:10%; animation-delay:0s;"></div>
        <div class="particle" style="left:30%; animation-delay:2s;"></div>
        <div class="particle" style="left:50%; animation-delay:4s;"></div>
        <div class="particle" style="left:70%; animation-delay:1s;"></div>
        <div class="particle" style="left:90%; animation-delay:3s;"></div>
    </div>

<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="goBack()"></span>
        Rumah
    </div>

    
    <div class="slider-container" id="main-slider-container">
        <div class="slider" id="main-slider">
            <?php $__currentLoopData = \App\Models\VipSlider::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slide"><img src="<?php echo e(asset($slider->photo)); ?>" alt="Slider Image"></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="dots" id="slider-dots-container"></div>
    </div>

 <!-- BAGIAN ACTION ICON DENGAN TAMBAHAN PRODUK SAYA -->
<div class="action-buttons"> 
  <div class="action-btn" onclick="openPage('user/recharge')">
    <img src="https://api.iconify.design/solar:card-send-bold-duotone.svg?color=white" alt="Isi Ulang">
    <div>Isi Ulang</div>
  </div>

  <div class="action-btn" onclick="openPage('/withdraw')">
    <img src="https://api.iconify.design/solar:wallet-money-bold-duotone.svg?color=white" alt="Withdraw">
    <div>Withdraw</div>
  </div>

  <div class="action-btn" onclick="openPage('/promo')">
    <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=white" alt="Hadiah">
    <div>Hadiah</div>
  </div>

  <div class="action-btn" onclick="openPage('/my/vip')"> 
  <img src="https://api.iconify.design/solar:chart-square-bold-duotone.svg?color=white" alt="Investasi Saya">
  <div>Investasi</div>
</div>


  <div class="action-btn" onclick="openPage('https://chat.whatsapp.com/H4SpzNIPaXnCuu777AFNef?mode=ems_copy_t')">
    <img src="https://api.iconify.design/solar:headphones-round-sound-bold-duotone.svg?color=white" alt="Group">
    <div>Group</div>
  </div>
</div>



    <div class="tabs">
        <button class="tab active" onclick="switchTab(event, 'daily-income')">Card VIP</button>
        <button class="tab" onclick="switchTab(event, 'welfare-plan')">Tesla Plus</button>
    </div>

    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $menu = PackageCategory::get()->toArray();
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">
        <div id="daily-income" class="plan-list">
            <?php if($packageOne->count() > 0): ?>
                <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first(); ?>
                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span class="label">Pendapatan Perhari:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element->validity); ?> Hari</span></div>
                                <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>
                        <?php if($myVip): ?>
                            <button class="buy-btn" disabled>Aktif</button>
                        <?php elseif($element->status == 'coming'): ?>
                            <button class="buy-btn" disabled>Coming</button>
                        <?php else: ?>
                            <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">Beli Sekarang</button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p style="text-align:center;padding:20px;">No daily income plans available.</p>
            <?php endif; ?>
        </div>

        <div id="welfare-plan" class="plan-list" style="display:none;">
            <?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element['name']); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element['photo'])); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element['price'])); ?></span></div>
                            <div class="detail-item"><span class="label">Pendapatan Perhari :</span><span class="value"><?php echo e(price($element['daily_limit'])); ?></span></div>
                            <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element['validity']); ?> days</span></div>
                            <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></span></div>
                        </div>
                    </div>
                    <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">Beli Sekarang</button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    
</div> <!-- Tutup main-container di sini -->
<!-- 🌟 NAVBAR BAWAH ELEGAN (VERSI DISEMPURNAKAN) -->
<div class="bottom-nav">
  <!-- HOME -->
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>

  <!-- INVESTASI SAYA -->
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>

  <!-- TEAM -->
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>

  <!-- PROFIL -->
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>



</div>

<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    const slides=Array.from(slider.children);
    let dots=[];
    slides.forEach((_,i)=>{
        const dot=document.createElement('div');
        dot.classList.add('dot');
        dot.addEventListener('click',()=>goToSlide(i));
        dotsContainer.appendChild(dot);
        dots.push(dot);
    });
    let current=0;
    const goToSlide=(i)=>{
        current=i;
        slider.style.transform=`translateX(-${i*100}%)`;
        dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
    };
    goToSlide(0);
    if(slides.length>1)setInterval(()=>goToSlide((current+1)%slides.length),3000);
});

function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}
</script>
<!-- 🌟 POPUP WHATSAPP ELEGAN -->
<style>
.popup-whatsapp {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0, 0, 0, 0.85);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999999;
  animation: fadeInPopup 0.4s ease-in-out;
}
@keyframes fadeInPopup {
  from { opacity: 0; transform: scale(0.95); }
  to { opacity: 1; transform: scale(1); }
}
.popup-box {
  background: linear-gradient(135deg, #021526, #004aad);
  border: 2px solid rgba(0, 234, 255, 0.4);
  border-radius: 20px;
  box-shadow: 0 0 30px rgba(0, 234, 255, 0.5);
  text-align: center;
  padding: 30px 25px;
  width: 90%;
  max-width: 330px;
  animation: slideUp 0.5s ease forwards;
}
@keyframes slideUp {
  from { transform: translateY(40px); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}
.popup-box img {
  width: 80px;
  height: 80px;
  animation: rotateGlow 3s linear infinite;
  filter: drop-shadow(0 0 15px rgba(0, 234, 255, 0.8));
  margin-bottom: 15px;
}
@keyframes rotateGlow {
  from { transform: rotate(0deg); }
  to { transform: rotate(360deg); }
}
.popup-box h3 {
  color: #00eaff;
  font-weight: 700;
  margin-bottom: 8px;
  text-shadow: 0 0 10px rgba(0, 234, 255, 0.6);
}
.popup-box p {
  color: #cdeaff;
  font-size: 14px;
  margin-bottom: 15px;
  line-height: 1.5;
}
.popup-box button {
  background: linear-gradient(135deg, #00eaff, #0077ff);
  color: white;
  border: none;
  border-radius: 50px;
  padding: 10px 25px;
  font-weight: 600;
  box-shadow: 0 0 20px rgba(0, 234, 255, 0.5);
  cursor: pointer;
  transition: 0.3s ease;
}
.popup-box button:hover {
  transform: scale(1.05);
  box-shadow: 0 0 25px rgba(0, 234, 255, 0.8);
}
</style>

<!-- 🌟 POPUP WHATSAPP ELEGAN DAN INTERAKTIF -->
<style>
.popup-whatsapp {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0, 0, 0, 0.85);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999999;
  animation: fadeInPopup 0.4s ease-in-out;
}
@keyframes fadeInPopup {
  from { opacity: 0; transform: scale(0.95); }
  to { opacity: 1; transform: scale(1); }
}

.popup-box {
  background: linear-gradient(135deg, #021526, #004aad);
  border: 2px solid rgba(0, 234, 255, 0.4);
  border-radius: 20px;
  box-shadow: 0 0 30px rgba(0, 234, 255, 0.5);
  text-align: center;
  padding: 30px 25px;
  width: 90%;
  max-width: 330px;
  animation: slideUp 0.5s ease forwards;
  position: relative;
}
@keyframes slideUp {
  from { transform: translateY(40px); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

/* 🌈 ICON WHATSAPP: BERDENYUT & GLOW */
.popup-box img {
  width: 80px;
  height: 80px;
  filter: drop-shadow(0 0 20px rgba(0, 255, 150, 0.8));
  animation: pulseGlow 2.5s infinite ease-in-out;
  margin-bottom: 15px;
}
@keyframes pulseGlow {
  0%, 100% {
    transform: scale(1);
    filter: drop-shadow(0 0 15px rgba(0, 255, 150, 0.7))
            drop-shadow(0 0 25px rgba(0, 255, 200, 0.4));
  }
  50% {
    transform: scale(1.08);
    filter: drop-shadow(0 0 30px rgba(0, 255, 180, 0.9))
            drop-shadow(0 0 40px rgba(0, 255, 255, 0.7));
  }
}

.popup-box h3 {
  color: #00eaff;
  font-weight: 700;
  margin-bottom: 8px;
  text-shadow: 0 0 10px rgba(0, 234, 255, 0.6);
}

.popup-box p {
  color: #cdeaff;
  font-size: 14px;
  margin-bottom: 15px;
  line-height: 1.5;
}

.popup-box button {
  background: linear-gradient(135deg, #00eaff, #00ffbb);
  color: white;
  border: none;
  border-radius: 50px;
  padding: 10px 25px;
  font-weight: 600;
  box-shadow: 0 0 20px rgba(0, 234, 255, 0.5);
  cursor: pointer;
  transition: 0.3s ease;
}
.popup-box button:hover {
  transform: scale(1.05);
  box-shadow: 0 0 25px rgba(0, 234, 255, 0.8);
}
</style>

<script>
// 🌐 Fungsi menampilkan popup WhatsApp
function showWhatsAppPopup() {
  if (document.querySelector('.popup-whatsapp')) return; // hindari dobel

  const popup = document.createElement("div");
  popup.className = "popup-whatsapp";
  popup.innerHTML = `
    <div class="popup-box" id="popupBox">
      <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
      <h3>💳 Berinvestasilah Sekarang!</h3>
      <p>
        Gunakan peluang emas dengan kartu kredit Anda.  
        Dapatkan promo eksklusif dan panduan investasi cerdas langsung di grup WhatsApp resmi kami. 🚀
      </p>
      <button id="joinNow">Gabung Sekarang</button>
    </div>
  `;
  document.body.appendChild(popup);

  // Klik tombol -> buka WhatsApp
  document.getElementById("joinNow").addEventListener("click", () => {
    window.open("https://chat.whatsapp.com/H4SpzNIPaXnCuu777AFNef?mode=ems_copy_t", "_blank");
    popup.remove();
  });

  // Klik luar popup -> tutup popup
  popup.addEventListener("click", (e) => {
    if (!document.getElementById("popupBox").contains(e.target)) {
      popup.remove();
    }
  });

  // Hilang otomatis setelah 10 detik
  setTimeout(() => popup.remove(), 10000);
}

// 🎯 Tampilkan popup otomatis saat halaman Home dimuat
document.addEventListener("DOMContentLoaded", () => {
  setTimeout(showWhatsAppPopup, 1000);
});
</script>


</body>
</html>
<?php /**PATH /home/runnlvbg/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>