<!DOCTYPE html>   
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Penarikan</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>

/* 🎨 WHITE + PREMIUM GREEN THEME */
:root {
  --white:#ffffff;
  --soft-white:#fafafa;

  --green:#00c896;            /* hijau utama */
  --green-light:#7ce7c3;      /* hijau gradasi */
  --green-soft:#d9fff3;       /* hijau pastel background */

  --text:#222;
  --text-muted:#666;

  --border:#e4e4e4;
  --card-border:#efefef;

  --shadow:0 4px 15px rgba(0,0,0,0.06);
}

/* RESET */
*{margin:0;padding:0;box-sizing:border-box}
body{
  background:var(--soft-white);
  font-family:'Poppins',sans-serif;
  color:var(--text);
  min-height:100vh;
}

/* CONTAINER */
.main-container{
  max-width:600px;
  margin:0 auto;
  padding-bottom:70px;
}

/* HEADER PUTIH + HIJAU */
.header{
  background:var(--white);
  padding:16px 20px;
  text-align:center;
  font-weight:700;
  border-bottom:2px solid var(--green);
  color:var(--green);
  position:relative;
  box-shadow:0 2px 12px rgba(0,0,0,0.05);
}
.back-btn{
  position:absolute;
  left:16px;
  top:50%;
  transform:translateY(-50%);
  font-size:26px;
  cursor:pointer;
  color:var(--green);
}

/* CONTENT */
.content-wrapper{
  padding:20px 16px 100px;
}

/* CARD */
.card{
  background:var(--white);
  padding:18px 20px;
  border-radius:14px;
  border:1px solid var(--card-border);
  box-shadow:var(--shadow);
  margin-bottom:18px;
}

/* SALDO */
.balance-label{
  font-size:14px;
  color:var(--text-muted);
  margin-bottom:6px;
  text-align:center;
}
.balance-amount{
  font-size:34px;
  font-weight:700;
  background:linear-gradient(90deg,var(--green),var(--green-light));
  -webkit-background-clip:text;
  -webkit-text-fill-color:transparent;
  text-align:center;
}

/* BANK CARD */
.card-header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  margin-bottom:12px;
}
.card-title{
  font-size:16px;
  font-weight:600;
  color:var(--green);
}
.edit-btn{
  background:var(--green);
  border:none;
  padding:6px 14px;
  border-radius:8px;
  font-size:13px;
  color:#fff;
  cursor:pointer;
  transition:.3s;
}
.edit-btn:hover{
  opacity:.85;
}

/* INFO ROW */
.info-row{
  display:flex;
  justify-content:space-between;
  padding:8px 0;
  border-bottom:1px solid #f5f5f5;
}
.info-row:last-child{border-bottom:none}
.info-row .label{color:var(--text-muted)}
.info-row .value{font-weight:600}

/* FORM */
.form-label{
  font-weight:600;
  margin-bottom:8px;
  display:block;
}
.form-control{
  width:100%;
  height:48px;
  padding:0 14px;
  border-radius:10px;
  border:1px solid var(--border);
  background:#fff;
  font-size:16px;
}
.form-control:focus{
  outline:none;
  border-color:var(--green);
  box-shadow:0 0 8px rgba(0,200,150,0.4);
}

/* NOMINAL BTN */
.amount-options{
  margin-top:14px;
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:10px;
}
.amount-btn{
  padding:12px;
  border-radius:10px;
  border:1px solid var(--border);
  background:var(--white);
  cursor:pointer;
  font-weight:600;
  transition:.3s;
}
.amount-btn:hover,
.amount-btn.active{
  background:linear-gradient(90deg,var(--green),var(--green-light));
  color:#fff;
  box-shadow:0 4px 12px rgba(0,200,150,0.4);
}

/* SUBMIT */
.submit-btn{
  width:100%;
  padding:15px;
  border:none;
  border-radius:10px;
  background:linear-gradient(90deg,var(--green),var(--green-light));
  color:#fff;
  font-size:15px;
  font-weight:700;
  cursor:pointer;
  margin-top:12px;
  box-shadow:0 4px 14px rgba(0,200,150,0.4);
  transition:.3s;
}
.submit-btn:hover{
  opacity:.9;
  transform:translateY(-2px);
}

/* INFO SECTION */
.info-section{
  font-size:14px;
  color:var(--text);
}
.highlight{
  background:var(--green-soft);
  padding:10px 12px;
  border-left:4px solid var(--green);
  border-radius:10px;
  margin:12px 0;
}

</style>
</head>

<body>
<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    Penarikan
  </div>

  <div class="content-wrapper">

    <!-- SALDO -->
    <div class="card">
      <div class="balance-label">Saldo Tersedia</div>
      <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>

    <?php if(auth()->user()->gateway_number && auth()->user()->gateway_method): ?>
      <?php
        $method = \App\Models\PaymentMethod::where('id', auth()->user()->gateway_method)->first();
      ?>

      <!-- DATA BANK -->
      <div class="card">
        <div class="card-header">
          <span class="card-title">Penarikan ke Rekening Bank</span>
          <button class="edit-btn" onclick="window.location.href='/add/card'">
            <i class="fas fa-edit"></i> Ubah
          </button>
        </div>

        <div class="bank-info">
          <div class="info-row">
            <span class="label">Nama Bank:</span>
            <span class="value"><?php echo e($method->name ?? 'N/A'); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nama Pemilik:</span>
            <span class="value"><?php echo e(auth()->user()->holder_name); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nomor Rekening:</span>
            <span class="value"><?php echo e(auth()->user()->gateway_number); ?></span>
          </div>
        </div>
      </div>

      <!-- FORM PENARIKAN -->
      <div class="card">
        <form action="<?php echo e(route('user.withdraw-confirm-submit')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          
          <label class="form-label">Jumlah Penarikan</label>
          <input id="withdrawAmount" type="number" name="amount" class="form-control" placeholder="Pilih nominal" readonly required>

          <div class="amount-options">
            <button type="button" class="amount-btn" data-amount="33000">Rp 33.000</button>
            <button type="button" class="amount-btn" data-amount="60000">Rp 60.000</button>
            <button type="button" class="amount-btn" data-amount="150000">Rp 150.000</button>
            <button type="button" class="amount-btn" data-amount="750000">Rp 750.000</button>
            <button type="button" class="amount-btn" data-amount="1500000">Rp 1.500.000</button>
            <button type="button" class="amount-btn" data-amount="3000000">Rp 3.000.000</button>
            <button type="button" class="amount-btn" data-amount="5000000">Rp 5.000.000</button>
            <button type="button" class="amount-btn" data-amount="10000000">Rp 10.000.000</button>
          </div>

          <button type="submit" class="submit-btn">Konfirmasi Penarikan</button>
        </form>
      </div>

    <?php else: ?>
      <div class="card">
        <p>Anda belum menambahkan kartu bank.</p>
        <a href="/add/card" class="submit-btn" style="text-align:center;display:block;margin-top:14px;">Tambah Kartu Bank</a>
      </div>
    <?php endif; ?>

    <!-- INFORMASI -->
    <div class="card info-section">
      <h4>⚠️ Informasi Penting</h4>

      <div class="highlight">Pastikan data rekening benar.</div>

      <p>1. Minimal penarikan: <strong>Rp 33.000</strong></p>
      <p>2. Maksimal penarikan: <strong>Rp 10.000.000</strong></p>
      <p>3. Biaya admin: <strong>10%</strong></p>
      <p>4. Jam layanan: <strong>08.00 – 23.00 WIB</strong></p>
      <p>5. Proses: <strong>1–24 Jam</strong></p>

      <div class="highlight">Tarik saldo di jam aktif agar lebih cepat.</div>
    </div>

  </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>

<script>
document.querySelectorAll('.amount-btn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    document.querySelectorAll('.amount-btn').forEach(b=>b.classList.remove('active'));
    btn.classList.add('active');
    document.getElementById('withdrawAmount').value=btn.dataset.amount;
  });
});
</script>

</body>
</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>