<?php  
    $paymentMethods = \App\Models\PaymentMethod::where('status', 1)->orderBy('id', 'desc')->get();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui, viewport-fit=cover">
<title>Isi Ulang Saldo</title>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
  --primary-gradient: linear-gradient(135deg, #002b40, #004b80);
  --background-color: #00111f;
  --text-color: #fff;
  --card-bg: rgba(255,255,255,0.05);
  --shadow: 0 4px 15px rgba(0,234,255,0.2);
  --accent-color: #00eaff;
}

* { margin: 0; padding: 0; box-sizing: border-box; }
body {
  font-family: 'Poppins', sans-serif;
  background: var(--background-color);
  color: var(--text-color);
  overflow-x: hidden;
}
a { text-decoration: none; color: inherit; }

.main-container {
  max-width: 600px;
  margin: 0 auto;
  min-height: 100vh;
  position: relative;
  padding-bottom: 90px;
}

/* HEADER */
.header {
  background: var(--primary-gradient);
  padding: 18px 15px;
  text-align: center;
  position: relative;
  border-bottom-left-radius: 25px;
  border-bottom-right-radius: 25px;
  box-shadow: var(--shadow);
}
.header .back-btn {
  position: absolute;
  left: 20px;
  top: 18px;
  font-size: 26px;
  color: var(--text-color);
  cursor: pointer;
  font-weight: bold;
}
.header .header-title {
  font-size: 1.4rem;
  font-weight: 600;
  color: #fff;
}

/* KONTEN */
.content-wrapper {
  padding: 20px;
}

/* KARTU SALDO */
.balance-card {
  background: var(--primary-gradient);
  border-radius: 20px;
  padding: 25px 20px;
  color: #fff;
  text-align: center;
  box-shadow: var(--shadow);
  margin-bottom: 25px;
}
.balance-card .balance-amount {
  font-size: 34px;
  font-weight: 700;
}
.balance-card .balance-label {
  font-size: 15px;
  opacity: 0.9;
}

/* FORM ISI ULANG */
.recharge-form-container {
  background: var(--card-bg);
  border-radius: 20px;
  padding: 20px;
  box-shadow: var(--shadow);
}

/* FORM */
.form-label {
  font-weight: 600;
  color: #fff;
  margin-bottom: 8px;
  display: block;
}
.form-control {
  height: 55px;
  font-size: 18px;
  font-weight: 700;
  border-radius: 12px;
  border: 2px solid rgba(255,255,255,0.3);
  text-align: center;
  width: 100%;
  background: transparent;
  color: #fff;
}
.form-control:focus {
  outline: none;
  border-color: var(--accent-color);
  box-shadow: 0 0 10px rgba(0,234,255,0.4);
}

/* NOMINAL CEPAT */
.quick-amount-title {
  margin-top: 25px;
  color: var(--accent-color);
  font-weight: 600;
  letter-spacing: 0.5px;
  text-shadow: 0 0 5px rgba(0,234,255,0.5);
}
.amount-grid {
  display: flex;
  flex-wrap: wrap;
  justify-content: space-between;
  gap: 12px;
  margin-top: 15px;
}
.amount-btn {
  flex: 1 1 30%;
  background: var(--card-bg);
  color: #fff !important;
  border: 1px solid rgba(255,255,255,0.2);
  border-radius: 12px;
  padding: 14px 0;
  cursor: pointer;
  text-align: center;
  font-weight: 600;
  transition: all 0.3s ease;
  box-shadow: inset 0 0 8px rgba(255,255,255,0.1);
}
.amount-btn:hover {
  background: linear-gradient(135deg, #00eaff, #007bff);
  color: #000 !important;
  transform: translateY(-4px) scale(1.05);
  box-shadow: 0 0 15px rgba(0,234,255,0.5);
}
.amount-btn.active {
  background: linear-gradient(135deg, #00eaff, #007bff);
  color: #000;
  box-shadow: 0 0 18px rgba(0,234,255,0.6);
}

/* METODE PEMBAYARAN */
.payment-methods-container {
  margin-top: 35px;
}
.payment-methods-container h5 {
  color: var(--accent-color);
  text-shadow: 0 0 5px rgba(0,234,255,0.5);
  font-weight: 600;
}
.payment-method-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(110px, 1fr));
  gap: 15px;
  margin-top: 15px;
}
.payment-method-card {
  position: relative;
  border: 2px solid rgba(255,255,255,0.15);
  border-radius: 15px;
  padding: 15px 10px;
  text-align: center;
  cursor: pointer;
  transition: all 0.3s ease;
  background: var(--card-bg);
  box-shadow: inset 0 0 8px rgba(255,255,255,0.05);
}
.payment-method-card:hover {
  transform: translateY(-4px);
  border-color: var(--accent-color);
  box-shadow: 0 0 15px rgba(0,234,255,0.4);
}
.payment-method-card img {
  max-width: 55%;
  height: 30px;
  object-fit: contain;
  filter: brightness(0) invert(1);
  margin-bottom: 8px;
  transition: 0.3s;
}
.payment-method-card .method-name {
  font-size: 13px;
  color: #fff;
  font-weight: 500;
}
.payment-method-card.active {
  border-color: var(--accent-color);
  background: rgba(0,234,255,0.1);
  box-shadow: 0 0 20px rgba(0,234,255,0.5);
}
.payment-method-card.active img {
  filter: drop-shadow(0 0 8px #00eaff);
}

/* TOMBOL ISI ULANG */
.recharge-btn {
  padding: 16px;
  font-size: 18px;
  font-weight: 600;
  width: 100%;
  margin-top: 30px;
  border-radius: 12px;
  background: linear-gradient(135deg, #00eaff, #007bff);
  color: #000;
  border: none;
  box-shadow: 0 4px 15px rgba(0,234,255,0.3);
  transition: all 0.3s ease;
  cursor: pointer;
}
.recharge-btn:hover {
  transform: scale(1.03);
  box-shadow: 0 6px 20px rgba(0,234,255,0.5);
}

/* BAGIAN INFO */
.info-section {
  margin-top: 25px;
  background: var(--card-bg);
  border-radius: 15px;
  padding: 18px 15px;
  color: rgba(255,255,255,0.9);
  font-size: 14px;
  line-height: 1.7;
  box-shadow: var(--shadow);
  position: relative;
  overflow: hidden;
}
.info-section::before {
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  width: 5px;
  height: 100%;
  background: var(--accent-color);
  border-radius: 5px 0 0 5px;
}
.info-section h3 {
  font-size: 18px;
  font-weight: 600;
  color: var(--accent-color);
  margin-bottom: 10px;
  text-shadow: 0 0 10px rgba(0,234,255,0.5);
}
.info-section ul {
  list-style: none;
}
.info-section ul li {
  margin-bottom: 8px;
  display: flex;
  align-items: flex-start;
}
.info-section ul li i {
  color: var(--accent-color);
  margin-right: 8px;
  font-size: 14px;
}

/* NAVBAR BAWAH (TIDAK DIUBAH) */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 100%;
  max-width: 600px;
  background: var(--primary-gradient);
  backdrop-filter: blur(8px);
  display: flex;
  justify-content: space-around;
  padding: 10px 0;
  box-shadow: 0 -3px 15px rgba(0,234,255,0.3);
  z-index: 9999;
  border-top-left-radius: 15px;
  border-top-right-radius: 15px;
}
.nav-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  color: rgba(255,255,255,0.7);
  text-decoration: none;
  font-size: 12px;
  transition: all 0.3s ease;
}
.nav-item.active {
  color: #fff;
  font-weight: 600;
  text-shadow: 0 0 10px rgba(0,234,255,0.8);
}
.nav-icon {
  width: 26px;
  height: 26px;
  margin-bottom: 4px;
  filter: brightness(0) invert(1);
}
</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">Isi Ulang Saldo</h1>
  </div>

  <div class="content-wrapper">
    <div class="balance-card">
      <p class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></p>
      <span class="balance-label">Saldo Saat Ini</span>
    </div>

    <div class="recharge-form-container">
      <form method="POST" action="<?php echo e(url('topup')); ?>">
        <?php echo csrf_field(); ?>
        <label class="form-label" for="topupAmount">Masukkan Nominal</label>
        <input id="topupAmount" type="number" min="100000" class="form-control" name="amount" placeholder="Minimal Rp 100.000" required>

        <h5 class="quick-amount-title">Nominal Cepat</h5>
        <div class="amount-grid">
          <div class="amount-btn" onclick="setAmount(100000)" data-amount="300"><?php echo e(price(100000)); ?></div>
          <div class="amount-btn" onclick="setAmount(250000)" data-amount="250000"><?php echo e(price(250000)); ?></div>
          <div class="amount-btn" onclick="setAmount(550000)" data-amount="550000"><?php echo e(price(550000)); ?></div>
          <div class="amount-btn" onclick="setAmount(1200000)" data-amount="1200000"><?php echo e(price(1200000)); ?></div>
         
        </div>

        <div class="payment-methods-container">
          <h5>Pilih Metode Pembayaran</h5>
          <div class="payment-method-grid mt-2">
            <?php $__empty_1 = true; $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <label class="payment-method-card" for="method-<?php echo e($method->id); ?>">
                <input type="radio" name="payment_method_id" id="method-<?php echo e($method->id); ?>" value="<?php echo e($method->id); ?>" required hidden>
                <img src="<?php echo e(asset($method->photo)); ?>" alt="<?php echo e($method->name); ?>">
                <div class="method-name"><?php echo e($method->name); ?></div>
              </label>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <p>Tidak ada metode pembayaran tersedia saat ini.</p>
            <?php endif; ?>
          </div>
        </div>

        <button type="submit" class="recharge-btn">Konfirmasi Isi Ulang</button>
      </form>
    </div>

    <!-- KEBIJAKAN ISI ULANG -->
    <div class="info-section">
      <h3><i class="fa-solid fa-circle-info"></i> Kebijakan Isi Ulang</h3>
      <ul>
        <li><i class="fa-solid fa-check-circle"></i> Minimal isi ulang adalah <b>Rp 100.000</b>.</li>
        <li><i class="fa-solid fa-lock"></i> Gunakan metode pembayaran resmi di halaman ini.</li>
        <li><i class="fa-solid fa-shield"></i> Dana Anda aman, transaksi terenkripsi.</li>
        <li><i class="fa-solid fa-headset"></i> Jika saldo belum masuk, hubungi layanan pelanggan 24 jam.</li>
      </ul>
    </div>
  </div>

 <!-- 🌟 NAVBAR BAWAH ELEGAN (VERSI DISEMPURNAKAN) -->
<div class="bottom-nav">
  <!-- HOME -->
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>

  <!-- INVESTASI SAYA -->
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>

  <!-- TEAM -->
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>

  <!-- PROFIL -->
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script>
function setAmount(amount){
  $('#topupAmount').val(amount);
  $('.amount-btn').removeClass('active');
  $('.amount-btn[data-amount="'+amount+'"]').addClass('active');
}
$('.payment-method-card').click(function(){
  $('.payment-method-card').removeClass('active');
  $(this).addClass('active').find('input[type="radio"]').prop('checked',true);
});
</script>
</body>
</html>
<?php /**PATH /home/runnlvbg/public_html/resources/views/app/main/recharge/index.blade.php ENDPATH**/ ?>