<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Gift Code</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root {
  --gold: #d4af37;
  --gold-light: #f7e9b5;
  --gold-gradient: linear-gradient(135deg, #d4af37, #f9d976, #f6e27a);
  --white: #ffffff;
  --background: #fafafa;
  --text-dark: #1a1a1a;
  --text-light: #666;
}

/* RESET */
* { margin:0; padding:0; box-sizing:border-box; }
body {
  font-family:'Poppins',sans-serif;
  background: var(--background);
  color: var(--text-dark);
  overflow-x:hidden;
  min-height:100vh;
}

/* MAIN CONTAINER */
.main-container {
  max-width:600px;
  margin:0 auto;
  min-height:100vh;
  background: var(--white);
  border-radius:20px;
  box-shadow:0 0 20px rgba(0,0,0,0.07);
  position:relative;
  padding-bottom:80px;
  overflow:hidden;
  animation:fadeIn 0.8s ease-in-out;
}

/* ANIMATION */
@keyframes fadeIn {
  from{opacity:0; transform:translateY(10px);}
  to{opacity:1; transform:translateY(0);}
}

/* HEADER */
.header {
  background: var(--gold-gradient);
  color:#fff;
  padding:15px 20px;
  text-align:center;
  position:relative;
  font-weight:600;
  font-size:1.2rem;
  border-top-left-radius:20px;
  border-top-right-radius:20px;
  box-shadow:0 2px 10px rgba(212,175,55,0.4);
}
.back-btn {
  position:absolute;
  left:20px;
  font-size:28px;
  cursor:pointer;
  color:#fff;
}

/* CARD */
.card {
  background: var(--white);
  border-radius:16px;
  padding:25px;
  margin:20px;
  box-shadow:0 3px 15px rgba(212,175,55,0.18);
  text-align:center;
  border:1px solid rgba(212,175,55,0.25);
}

/* REDEEM ICON */
.redeem-icon {
  width:90px;
  height:90px;
  margin:0 auto 20px;
  border-radius:50%;
  background: radial-gradient(circle, #d4af3722, #d4af37aa);
  display:flex;
  align-items:center;
  justify-content:center;
  box-shadow:0 0 20px rgba(212,175,55,0.4);
  animation:glow 3s infinite alternate;
}
.redeem-icon img {
  width:60%;
  filter: drop-shadow(0 0 10px rgba(212,175,55,0.8));
}
@keyframes glow {
  from { box-shadow:0 0 12px rgba(212,175,55,0.3); transform:scale(1);}
  to { box-shadow:0 0 26px rgba(212,175,55,0.6); transform:scale(1.05);}
}

.card h3 {
  font-size:20px;
  font-weight:600;
  margin-bottom:8px;
  color: var(--gold);
}
.card p {
  color: var(--text-light);
  margin-bottom:25px;
}

/* INPUT */
.form-control {
  width:100%;
  height:55px;
  padding:0 20px;
  border-radius:12px;
  border:1px solid rgba(212,175,55,0.3);
  background: rgba(255,255,255,0.95);
  font-size:16px;
  font-weight:500;
  text-align:center;
  color:var(--text-dark);
  transition:0.3s;
}
.form-control:focus {
  outline:none;
  border-color: var(--gold);
  box-shadow:0 0 10px rgba(212,175,55,0.3);
}

/* BUTTON */
.submit-btn {
  width:100%;
  padding:14px;
  margin-top:15px;
  background: var(--gold-gradient);
  border:none;
  border-radius:12px;
  font-weight:600;
  color:#fff;
  cursor:pointer;
  box-shadow:0 0 20px rgba(212,175,55,0.25);
  transition:all 0.3s ease;
}
.submit-btn:hover {
  box-shadow:0 0 28px rgba(212,175,55,0.45);
  transform:scale(1.03);
}

/* INSTRUCTION */
.instructions-card {
  text-align:left;
}
.instructions-card h4 {
  font-size:16px;
  font-weight:600;
  margin-bottom:15px;
  color: var(--gold);
}
.instructions-card ul {
  list-style:none;
  color: var(--text-light);
}
.instructions-card li {
  margin-bottom:10px;
  padding-left:25px;
  position:relative;
}
.instructions-card li::before {
  content:'✨';
  position:absolute;
  left:0;
  top:0;
}

/* Fade */
@keyframes fadeUp {
  from {opacity:0; transform:translateY(15px);}
  to {opacity:1; transform:translateY(0);}
}
</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    Gift Code
  </div>

  <div class="card redeem-card">
      <div class="redeem-icon">
        <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%23d4af37" alt="gift">
      </div>
      <h3>Redeem Gift Code</h3>
      <p>Masukkan kode hadiah kamu untuk mendapatkan bonus spesial!</p>

      <form action="<?php echo e(route('submitBonusCode')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <input type="text" class="form-control" name="bonus_code" placeholder="Masukkan Kode Hadiah" required>
          <button class="submit-btn" type="submit">Klaim Sekarang</button>
      </form>
  </div>

  <div class="card instructions-card">
      <h4>✨ Cara Mendapatkan Kode Hadiah:</h4>
      <ul>
          <li>Ikuti channel Telegram resmi kami.</li>
          <li>Setiap kode hanya bisa digunakan satu kali.</li>
          <li>Pastikan kode ditulis tanpa spasi berlebih.</li>
          <li>Hubungi CS jika mengalami masalah.</li>
      </ul>
  </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/main/promo.blade.php ENDPATH**/ ?>