<!DOCTYPE html>      
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Tim</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-maroon: #7F1D1D;
    --maroon-dark: #450A0A;

    --bg-overlay: rgba(0,0,0,0.95);
    --card-bg: rgba(15,10,10,0.9);

    --text-color: #ffffff;
    --subtext-color: #f3b4b4;

    --border-color: rgba(127,29,29,0.35);
    --hover-shadow: 0 10px 28px rgba(127,29,29,0.55);
}

* { margin:0; padding:0; box-sizing:border-box; }

html, body {
    font-family:'Poppins', sans-serif;
    color:var(--text-color);
    min-height:100vh;
    background:
        radial-gradient(circle at top, #1a0a0a 0%, #000000 70%);
}

.main-container {
    max-width:600px;
    margin:0 auto;
    padding-bottom:120px;
}

/* HEADER */
.header {
    background: linear-gradient(135deg, var(--maroon-dark), var(--primary-maroon));
    padding:16px 20px;
    display:flex;
    justify-content:center;
    align-items:center;
    position:relative;
    box-shadow:0 6px 20px rgba(127,29,29,.6);
}
.header .back-btn {
    position:absolute;
    left:20px;
    font-size:28px;
    cursor:pointer;
}
.header-title {
    font-size:1.5rem;
    font-weight:700;
}

/* CONTENT */
.content-wrapper {
    padding:22px 15px 120px;
}

/* GLASS BOX */
.stats-box,
.referral-box,
.level-deposit-box,
.user-card,
.no-record {
    background: var(--card-bg);
    backdrop-filter: blur(10px);
    border-radius:16px;
    border:1px solid var(--border-color);
    box-shadow:0 8px 22px rgba(0,0,0,.6);
}

/* STATS */
.stats-box {
    padding:24px;
    text-align:center;
    margin-bottom:16px;
}
.stat-label {
    font-size:14px;
    color:var(--subtext-color);
}
.stat-value {
    font-size:26px;
    font-weight:700;
}
.sub-stats {
    display:flex;
    justify-content:space-around;
    margin-top:12px;
    padding-top:12px;
    border-top:1px solid var(--border-color);
}

/* REFERRAL */
.referral-box {
    display:flex;
    gap:12px;
    align-items:center;
    padding:16px;
    margin-bottom:20px;
}
.referral-text {
    font-size:14px;
    word-break:break-all;
    color:var(--subtext-color);
}
.copy-btn {
    background: linear-gradient(135deg, var(--primary-maroon), #991B1B);
    border:none;
    color:#fff;
    padding:10px 16px;
    border-radius:10px;
    font-weight:600;
    cursor:pointer;
}
.copy-btn:hover {
    box-shadow:var(--hover-shadow);
    transform:scale(1.05);
}

/* TEAM TABS */
.team-tabs {
    display:flex;
    gap:6px;
    padding:6px;
    border-radius:14px;
    margin-bottom:20px;
    background:rgba(20,5,5,0.85);
    border:1px solid var(--border-color);
}
.tab-btn {
    flex:1;
    padding:12px;
    border:none;
    border-radius:10px;
    background:transparent;
    color:var(--subtext-color);
    font-weight:600;
    cursor:pointer;
}
.tab-btn.active {
    background: linear-gradient(135deg, var(--primary-maroon), #991B1B);
    color:#fff;
    box-shadow:var(--hover-shadow);
}
.tab-content { display:none; }
.tab-content.active { display:block; }

/* LEVEL DEPOSIT */
.level-deposit-box {
    padding:16px;
    text-align:center;
    margin-bottom:18px;
}
.level-deposit-box p {
    font-size:18px;
    font-weight:700;
    color:#fca5a5;
}

/* USER LIST */
.user-list {
    display:flex;
    flex-direction:column;
    gap:14px;
}
.user-card {
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:16px;
}
.user-card:hover {
    transform:translateY(-3px);
    box-shadow:var(--hover-shadow);
}
.user-id { font-weight:700; }
.join-date,
.team-deposit {
    font-size:13px;
    color:var(--subtext-color);
}
.user-status {
    font-weight:700;
    color:#f87171;
}

/* NO RECORD */
.no-record {
    padding:40px 20px;
    text-align:center;
    color:var(--subtext-color);
}

/* BOTTOM NAV */
.bottom-nav {
    position:fixed;
    bottom:0;
    left:50%;
    transform:translateX(-50%);
    width:100%;
    max-width:600px;
    background:rgba(15,5,5,0.95);
    backdrop-filter: blur(12px);
    display:flex;
    justify-content:space-around;
    padding:12px 0;
    border-radius:18px 18px 0 0;
    border-top:1px solid var(--border-color);
}
.nav-item {
    text-align:center;
    font-size:12px;
    color:var(--subtext-color);
}
.nav-item.active {
    color:#fecaca;
    font-weight:700;
}

/* TEAM INVITE CARD */
.team-invite-card{
    background: linear-gradient(
        135deg,
        rgba(127,29,29,0.35),
        rgba(69,10,10,0.65)
    );
    backdrop-filter: blur(12px);
    border-radius:18px;
    border:1px solid var(--border-color);
    padding:18px 16px;
    margin-bottom:20px;
    box-shadow:0 10px 28px rgba(127,29,29,.55);
}

.invite-title{
    text-align:center;
    font-size:16px;
    font-weight:700;
    margin-bottom:14px;
}

.invite-levels{
    display:flex;
    gap:10px;
    margin-bottom:12px;
}

.level-box{
    flex:1;
    background:rgba(20,5,5,0.85);
    border:1px solid var(--border-color);
    border-radius:14px;
    padding:12px 6px;
    text-align:center;
    transition:.25s;
}
.level-box:hover{
    transform:translateY(-4px);
    box-shadow:0 8px 22px rgba(127,29,29,.6);
}

.level{
    font-size:13px;
    font-weight:600;
    color:var(--subtext-color);
}
.percent{
    font-size:22px;
    font-weight:800;
    margin-top:6px;
    background:linear-gradient(135deg,#fecaca,#f87171);
    -webkit-background-clip:text;
    -webkit-text-fill-color:transparent;
}

.invite-note{
    font-size:12px;
    text-align:center;
    color:var(--subtext-color);
    opacity:.9;
}

/* ================= GAJI AGEN TABLE ================= */
.salary-box{
    background:linear-gradient(
        135deg,
        rgba(127,29,29,0.35),
        rgba(69,10,10,0.75)
    );
    backdrop-filter:blur(14px);
    border:1px solid var(--border-color);
    border-radius:18px;
    padding:18px;
    margin-bottom:22px;
    box-shadow:0 10px 28px rgba(127,29,29,.55);
}

.salary-title{
    text-align:center;
    font-size:16px;
    font-weight:700;
    margin-bottom:14px;
    color:#fecaca;
}

.salary-table{
    width:100%;
    border-collapse:collapse;
    overflow:hidden;
    border-radius:14px;
}

.salary-table thead{
    background:rgba(20,5,5,0.85);
}

.salary-table th,
.salary-table td{
    padding:12px 10px;
    text-align:center;
    font-size:13px;
}

.salary-table th{
    font-weight:700;
    color:#fca5a5;
    border-bottom:1px solid var(--border-color);
}

.salary-table tbody tr{
    background:rgba(15,5,5,0.6);
    transition:.25s;
}

.salary-table tbody tr:hover{
    background:rgba(127,29,29,0.25);
}

.salary-table td{
    color:#ffffff;
    border-bottom:1px solid rgba(127,29,29,0.25);
}

.salary-badge{
    display:inline-block;
    padding:4px 10px;
    border-radius:999px;
    font-size:12px;
    font-weight:600;
    background:linear-gradient(135deg,#fecaca,#f87171);
    color:#450A0A;
}

</style>
</head>
<body>
<div class="main-container">

    <!-- HEADER -->
    <div class="header">
        <span class="back-btn" onclick="history.back()"></span>
        <h1 class="header-title">Taglichesgeld</h1>
    </div>
<div class="salary-box">
    <div class="salary-title">Gaji Agen Level 1 (Aktif)</div>

    <table class="salary-table">
        <thead>
            <tr>
                <th>Jumlah Aktif</th>
                <th>Status Agen</th>
                <th>Gaji</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>5 Aktif</td>
                <td><span class="salary-badge">Agen</span></td>
                <td>Rp25.000</td>
            </tr>
            <tr>
                <td>10 Aktif</td>
                <td><span class="salary-badge">Agen</span></td>
                <td>Rp50.000</td>
            </tr>
            <tr>
                <td>15 Aktif</td>
                <td><span class="salary-badge">Agen</span></td>
                <td>Rp75.000</td>
            </tr>
            <tr>
                <td>20 Aktif</td>
                <td><span class="salary-badge">Agen</span></td>
                <td>Rp100.000</td>
            </tr>
            <tr>
                <td>25 Aktif</td>
                <td><span class="salary-badge">Agen</span></td>
                <td>Rp125.000</td>
            </tr>
        </tbody>
    </table>
</div>

    <!-- CONTENT -->
    <div class="content-wrapper">
        <!-- STATISTIK TEAM -->
        <div class="stats-box">
            <div class="main-stat">
                <div class="stat-label">Deposit Tim</div>
                <div class="stat-value"><?php echo e(price($totalDeposit1 + $totalDeposit2 + $totalDeposit3)); ?></div>
            </div>
            <div class="sub-stats">
                <div class="stat-item">
                    <div class="stat-label">Total Asset</div>
                    <div class="stat-value"><?php echo e(price($totalCommission1 + $totalCommission2 + $totalCommission3)); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-label">Total Anggota Tim:</div>
                    <div class="stat-value"><?php echo e($team_size ?? 0); ?></div>
                </div>
            </div>
        </div>

<div class="team-invite-card">
  <div class="invite-title">Undang Team Level 3</div>

  <div class="invite-levels">
    <div class="level-box">
      <span class="level">Team 1</span>
      <span class="percent">12%</span>
    </div>
    <div class="level-box">
      <span class="level">Team 2</span>
      <span class="percent">2%</span>
    </div>
    <div class="level-box">
      <span class="level">Team 3</span>
      <span class="percent">1%</span>
    </div>
  </div>

  <div class="invite-note">
    Dapatkan komisi dari setiap aktivitas tim hingga 3 level
  </div>
</div>




        <!-- REFERRAL BOX -->
        <div class="referral-box">
            <div class="referral-text" id="referralLink"><?php echo e(url('register') . '?inviteCode=' . auth()->user()->ref_id); ?></div>
            <button class="copy-btn" onclick="copyReferral()">Salin <i class="fa fa-copy"></i></button>
        </div>

        <!-- TABS -->
        <div class="team-tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'level-1')">1-level 12%</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-2')">2-level  2%</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-3')">3-level  1%</button>
        </div>

        <!-- LEVEL 1 -->
        <div id="level-1" class="tab-content active">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 1</h3>
                <p><?php echo e(price($totalDeposit1)); ?></p>
            </div>
            <?php if($first_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 2 -->
        <div id="level-2" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 2</h3>
                <p><?php echo e(price($totalDeposit2)); ?></p>
            </div>
            <?php if($second_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 3 -->
        <div id="level-3" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 3</h3>
                <p><?php echo e(price($totalDeposit3)); ?></p>
            </div>
            <?php if($third_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit Tim: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function switchTab(event, tabId) {
    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.getElementById(tabId).classList.add('active');
    event.currentTarget.classList.add('active');
}

function copyReferral() {
    const text = document.getElementById("referralLink").innerText;
    navigator.clipboard.writeText(text).then(() => {
        const btn = document.querySelector(".copy-btn");
        btn.innerHTML = "Disalin ✔";
        btn.style.background = "#20ff88";
        setTimeout(() => {
            btn.innerHTML = 'Salin <i class="fa fa-copy"></i>';
            btn.style.background = "var(--accent-color)";
        }, 2000);
    });
}
</script>
</body>
</html>
<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>