<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<title>Invite  Gold Theme</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>

<style>
:root {
    --gold: #d4af37;
    --gold-light: #f7e9b2;
    --gold-dark: #b8860b;
    --bg-color: #ffffff;
    --card-bg: #ffffff;
    --text-color: #222;
    --subtext-color: #666;
    --border-light: rgba(212,175,55,0.35);
}

* { margin: 0; padding: 0; box-sizing: border-box; }

html, body {
    font-family: 'Poppins', sans-serif;
    background: var(--bg-color);
    color: var(--text-color);
    min-height: 100vh;
    overflow-x: hidden;
}

/* animasi fadeInUp */
@keyframes fadeInUp {
    0% { opacity: 0; transform: translateY(20px); }
    100% { opacity: 1; transform: translateY(0); }
}

/* KONTAINER UTAMA */
.main-container {
    max-width: 600px;
    margin: 0 auto;
    position: relative;
    padding-bottom: 100px;
}

/* HEADER GOLD */
.header {
    background: linear-gradient(135deg, var(--gold), var(--gold-dark));
    color: #fff;
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    border-bottom: 2px solid var(--gold-light);
    box-shadow: 0 4px 15px rgba(212,175,55,0.5);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 28px;
    color: #fff;
    cursor: pointer;
    transition: transform 0.3s ease;
}
.header .back-btn:hover { transform: scale(1.2); }
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
    letter-spacing: 0.5px;
}

/* KONTEN */
.content { padding: 20px 15px; }

/* KARTU UNDANGAN GOLD */
.invitation-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 25px;
    border: 1px solid var(--border-light);
    box-shadow: 0 4px 15px rgba(212,175,55,0.25);
    text-align: center;
    animation: fadeInUp 1s ease;
}

/* QR CODE */
#qrcode {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 15px;
    background: #fff;
    border-radius: 12px;
    border: 2px solid var(--gold);
    margin: 0 auto 25px auto;
    max-width: 220px;
}

/* DETAIL UNDANGAN */
.invitation-details {
    text-align: left;
    margin-bottom: 25px;
    word-wrap: break-word;
    color: var(--subtext-color);
}
.detail-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 10px;
    font-size: 15px;
}
.detail-label {
    font-weight: 600;
    color: var(--gold-dark);
    width: 120px;
}
.detail-value { color: #444; }

/* TOMBOL GOLD */
.copy-btn {
    background: linear-gradient(135deg, var(--gold), var(--gold-dark));
    color: white;
    border: none;
    border-radius: 12px;
    padding: 15px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s ease;
    border: 1px solid var(--gold-dark);
}
.copy-btn:hover {
    transform: scale(1.03);
    box-shadow: 0 0 15px rgba(212,175,55,0.5);
}

/* INFO KOMISI */
.commission-info {
    text-align: center;
    margin-bottom: 30px;
    line-height: 1.7;
}
.commission-box {
    background: #fff;
    border-radius: 14px;
    padding: 20px;
    margin-bottom: 20px;
    border: 1px solid var(--border-light);
    box-shadow: 0 0 15px rgba(212,175,55,0.2);
}
.commission-title {
    font-size: 18px;
    font-weight: 700;
    color: var(--gold-dark);
    margin-bottom: 10px;
}
.commission-item {
    display: flex;
    justify-content: space-between;
    padding: 5px 15px;
    color: #444;
    font-size: 15px;
    border-bottom: 1px solid rgba(0,0,0,0.06);
}
.commission-item span:first-child {
    font-weight: 600;
}

/* TOAST */
#toast {
    visibility: hidden;
    min-width: 250px;
    background-color: var(--gold-dark);
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 16px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    bottom: 80px;
    transform: translateX(-50%);
    font-size: 17px;
    opacity: 0;
    transition: opacity 0.5s, visibility 0.5s;
}
#toast.show { visibility: visible; opacity: 1; }

/* NAVBAR GOLD */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, var(--gold), var(--gold-dark));
    display: flex;
    justify-content: space-around;
    padding: 10px 0;
    z-index: 1000;
    box-shadow: 0 -2px 15px rgba(212,175,55,0.4);
}
.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: #fff9dd;
    text-decoration: none;
    transition: all 0.3s ease;
}
.nav-item.active .nav-label {
    color: #fff;
    font-weight: 700;
}
.nav-item img {
    width: 28px;
    height: 28px;
    margin-bottom: 4px;
    filter: brightness(1.2);
    transition: transform 0.3s ease;
}
.nav-item:hover img { transform: scale(1.15); }
.nav-label { font-size: 12px; }
</style>
</head>

<body>
<div class="main-container">
    <div class="header">
        <span class="" onclick="history.back()">‹</span>
        <h1 class="header-title">FD225WAT</h1>
    </div>

    <div class="content">
        <div class="commission-info">
            <div class="commission-box">
                <div class="commission-title">💰 Komisi Undangan</div>
                <div class="commission-item"><span>Tingkat A</span><span>10%</span></div>
                <div class="commission-item"><span>Tingkat B</span><span>3%</span></div>
                <div class="commission-item"><span>Tingkat C</span><span>1%</span></div>
            </div>

            <p style="font-size:14px;color:var(--subtext-color);">
                Gunakan media sosial seperti <strong>YouTube</strong>, <strong>WhatsApp</strong>, <strong>Telegram</strong>, <strong>Facebook</strong>, dan <strong>Instagram</strong> untuk mengundang lebih banyak anggota bergabung.
            </p>
        </div>

        <div class="invitation-card">
            <div id="qrcode"></div>
            <div class="invitation-details">
                <div class="detail-item">
                    <span class="detail-label">Tautan Undangan:</span>
                    <span id="invitation-link-text" class="detail-value"><?php echo e(url('register').'?inviteCode='.auth()->user()->ref_id); ?></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Kode Referral:</span>
                    <span id="invitation-code-text" class="detail-value"><?php echo e(auth()->user()->ref_id); ?></span>
                </div>
            </div>
            <button class="copy-btn" onclick="copyToClipboard('<?php echo e(url('register').'?inviteCode='.auth()->user()->ref_id); ?>','Tautan undangan berhasil disalin!')">📋 Salin Tautan Undangan</button>
         
        </div>
    </div>
  <!-- NAVBAR BAWAH -->
<div class="bottom-nav">
    <!-- HOME -->
    <div class="nav-item" onclick="window.location.href='/'">
        <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white">
        <div class="nav-label">Home</div>
    </div>

    <!-- INVESTASI SAYA -->
    <div class="nav-item" onclick="window.location.href='/my/vip'">
        <img src="https://api.iconify.design/solar:chart-bold.svg?color=white">
        <div class="nav-label">Investasi</div>
    </div>

    <!-- TEAM -->
    <div class="nav-item" onclick="window.location.href='/my-team'">
        <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white">
        <div class="nav-label">Team</div>
    </div>

    <!-- PROFIL -->
    <div class="nav-item active" onclick="window.location.href='/mine'">
        <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white">
        <div class="nav-label">Profil</div>
    </div>
</div>

    </div>
</div>

<div id="toast"></div>

<script>
function showToast(message) {
    const toast = document.getElementById("toast");
    toast.textContent = message;
    toast.className = "show";
    setTimeout(() => toast.className = toast.className.replace("show",""), 2000);
}
function copyToClipboard(text, message) {
    navigator.clipboard.writeText(text).then(()=>showToast(message||"Tersalin!"))
    .catch(()=>showToast("Gagal menyalin!"));
}
document.addEventListener('DOMContentLoaded', ()=>{
    const invitationLink = document.getElementById('invitation-link-text').innerText;
    if(invitationLink){
        new QRCode(document.getElementById("qrcode"),{
            text: invitationLink,
            width:200,
            height:200,
            colorDark:"#000000",
            colorLight:"#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });
    }
});
</script>
</body>
</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/main/invite.blade.php ENDPATH**/ ?>