<style>
:root{
  --maroon-main:#7F1D1D;
  --maroon-dark:#450A0A;
  --maroon-light:#991B1B;
  --text-soft:#FECACA;
  --text-white:#FFFFFF;
}

/* ===============================
   BOTTOM NAVBAR
================================ */
.bottom-nav{
  position:fixed;
  bottom:0;
  left:50%;
  transform:translateX(-50%);
  width:100%;
  max-width:600px;
  background:linear-gradient(135deg,var(--maroon-dark),var(--maroon-main));
  display:flex;
  justify-content:space-around;
  padding:12px 0 14px;
  border-radius:18px 18px 0 0;
  box-shadow:0 -6px 25px rgba(127,29,29,.6);
  z-index:999;
}

/* ===============================
   NAV ITEM
================================ */
.nav-item{
  flex:1;
  text-align:center;
  cursor:pointer;
  position:relative;
}

.nav-svg{
  width:26px;
  height:26px;
  fill:var(--text-soft);
  transition:.3s ease;
}

.nav-label{
  font-size:11px;
  margin-top:4px;
  color:var(--text-soft);
  font-weight:600;
  transition:.3s ease;
}

/* ===============================
   ACTIVE STATE
================================ */
.nav-item.active .nav-svg{
  fill:var(--text-white);
  filter:drop-shadow(0 0 8px rgba(255,255,255,.7));
  transform:translateY(-4px) scale(1.15);
}

.nav-item.active .nav-label{
  color:var(--text-white);
}

.nav-item.active::after{
  content:'';
  position:absolute;
  bottom:-8px;
  left:50%;
  transform:translateX(-50%);
  width:8px;
  height:8px;
  background:var(--text-white);
  border-radius:50%;
  box-shadow:0 0 12px rgba(255,255,255,.8);
}

/* ===============================
   HOVER
================================ */
.nav-item:hover .nav-svg{
  fill:#fff;
}
</style>

<div class="bottom-nav">

  <div class="nav-item" onclick="location.href='/'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M3 10.5L12 3l9 7.5V21a1 1 0 0 1-1 1h-5v-6h-6v6H4a1 1 0 0 1-1-1z"/>
    </svg>
    <div class="nav-label">Home</div>
  </div>

  <div class="nav-item" onclick="location.href='/vip'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M21 7l-9-4-9 4v10l9 4 9-4z"/>
    </svg>
    <div class="nav-label">Investasi Saya</div>
  </div>

  <div class="nav-item" onclick="location.href='/my-team'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M16 11a4 4 0 1 0-8 0c0 1.5.8 2.8 2 3.5V17H6a4 4 0 0 0-4 4h20a4 4 0 0 0-4-4h-4v-2.5c1.2-.7 2-2 2-3.5z"/>
    </svg>
    <div class="nav-label">Team</div>
  </div>

  <div class="nav-item active" onclick="location.href='/mine'">
    <svg class="nav-svg" viewBox="0 0 24 24">
      <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5zm0 2c-4 0-8 2-8 5v1h16v-1c0-3-4-5-8-5z"/>
    </svg>
    <div class="nav-label">Profil</div>
  </div>

</div>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/layout/menu.blade.php ENDPATH**/ ?>