
<!DOCTYPE html>  
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Atur Bank</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
:root {
    --primary-color: #FFD600;      /* Kuning utama */
    --accent-color: #E0B800;       /* Kuning gelap */
    --text-color: #111;
    --subtext-color: #777;
    --white-color: #fff;
    --border-color: #e6e6e6;
    --input-bg: #f8f8f8;
}

/* RESET */
* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    width: 100%;
    height: 100%;
    background: #ffffff !important;
    font-family: 'Poppins', sans-serif;
    color: var(--text-color);
}

/* MAIN CONTAINER */
.main-container {
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    background: #fff !important;
    padding-bottom: 80px;
}

/* HEADER */
.header {
    background: var(--primary-color);
    color: #000;
    padding: 18px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    color: #000;
    font-weight: bold;
    cursor: pointer;
}
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
}

/* CONTENT */
.content-wrapper {
    padding: 25px 15px 40px;
}

/* FORM CARD */
.form-container {
    background: #fff;
    border-radius: 18px;
    padding: 25px 20px;
    border: 1px solid var(--border-color);
    box-shadow: 0 4px 20px rgba(0,0,0,0.05);
    animation: fadeIn 0.4s ease-in-out;
}

.form-label {
    display: block;
    font-size: 14px;
    color: #333;
    font-weight: 600;
    margin-bottom: 6px;
}

.form-control {
    width: 100%;
    height: 48px;
    padding: 0 15px;
    border-radius: 12px;
    border: 1px solid var(--border-color);
    background: var(--input-bg);
    color: #111;
    font-size: 15px;
    transition: 0.25s;
}
.form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 6px rgba(255, 214, 0, 0.4);
    outline: none;
}

/* SELECT CUSTOM ARROW */
select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' stroke='%23000000' viewBox='0 0 16 16'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    background-size: 14px 10px;
}

/* SUBMIT BUTTON */
.submit-btn {
    width: 100%;
    padding: 14px;
    background: var(--primary-color);
    color: #000;
    border: none;
    border-radius: 14px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    margin-top: 15px;
    box-shadow: 0 4px 15px rgba(255, 214, 0, 0.45);
    transition: 0.25s;
}
.submit-btn:hover {
    transform: translateY(-2px);
}

/* BOTTOM NAVBAR */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background:#fff;
    display: flex;
    justify-content: space-around;
    padding: 12px 0;
    border-top: 1px solid var(--border-color);
    box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
}

.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: #000;
    transition: 0.2s;
}
.nav-item .nav-icon {
    font-size: 22px;
}
.nav-item.active .nav-icon {
    color: #000;
    transform: scale(1.15);
}
.nav-label {
    font-size: 12px;
    font-weight: 600;
}
.nav-item.active .nav-label {
    color: #000;
}

/* ANIMATION */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}

  </style>
</head>

<body>
<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()">â€¹</span>
    <h1 class="header-title">Informasi Bank</h1>
  </div>


  <div class="content-wrapper">
    <div class="form-container">
      <form action="<?php echo e(route('setup.gateway.submit')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="form-group">
          <label class="form-label" for="holderName">Nama Pemilik Rekening</label>
          <input id="holderName" class="form-control" name="holdername" value="<?php echo e(auth()->user()->holder_name); ?>" placeholder="Masukkan Nama Pemilik Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="accountNumber">Nomor Rekening</label>
          <input id="accountNumber" class="form-control" name="gateway_number" value="<?php echo e(auth()->user()->gateway_number); ?>" placeholder="Masukkan Nomor Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="bankCode">Nama Bank</label>
          <select id="bankCode" class="form-control" name="gateway_method" required>
            <?php
              $methods = \App\Models\PaymentMethod::select('id','name')->where('status', 'active')->groupBy('name')->get();
            ?>
            <option value="">Pilih Bank</option>
            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($element->id); ?>" <?php echo e((auth()->user()->gateway_method == $element->id) ? 'selected' : ''); ?>>
                <?php echo e($element->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <button type="submit" class="submit-btn">
          Simpan Informasi
        </button>
      </form>
    </div>
  </div>

   <div class="bottom-nav">
  <!-- HOME -->
  <div class="nav-item" onclick="window.location.href='/'">
    <div class="nav-icon">🏠</div>
    <div class="nav-label">Home</div>
  </div>

  <!-- INVESTASI -->
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <div class="nav-icon">📦</div>
    <div class="nav-label">Investasi</div>
  </div>

  <!-- TEAM -->
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <div class="nav-icon">👥</div>
    <div class="nav-label">Team</div>
  </div>

  <!-- PROFIL -->
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <div class="nav-icon">👤</div>
    <div class="nav-label">Profil</div>
  </div>
</div>


</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/add_bank.blade.php ENDPATH**/ ?>