<!DOCTYPE html>   
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>Home</title>

<style>
:root {
    --primary-green: #66cc88; /* hijau muda nyaman */
    --dark-bg: #f5f5f5; /* putih lembut */
    --text-dark: #1a1a1a;
    --text-light: #555;
}

/* Reset */
* { margin:0; padding:0; box-sizing:border-box; }
body {
    font-family: 'Poppins', sans-serif;
    background: var(--dark-bg);
    color: var(--text-dark);
}

/* Container */
.main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    background: rgba(255,255,255,0.8);
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(102,204,136,0.3);
    padding-bottom: 80px;
}

/* Header */
.header {
    background: var(--primary-green);
    color: #fff;
    padding: 15px 20px;
    text-align: center;
    font-weight: 600;
    font-size: 1.2rem;
    position: relative;
    border-radius: 15px 15px 0 0;
}
.back-btn {
    position: absolute;
    left: 20px;
    font-size: 28px;
    cursor: pointer;
    color: #fff;
}

/* Slider */
.slider-container { overflow:hidden; position:relative; }
.slider { display:flex; transition: transform 0.5s ease; }
.slide { min-width:100%; }
.slide img { width:100%; height:200px; object-fit:cover; border-radius: 0 0 15px 15px; }

/* Dots */
.dots { display:flex; justify-content:center; margin-top:5px; }
.dot { width:10px; height:10px; margin:0 4px; background:#cceedd; border-radius:50%; cursor:pointer; }
.dot.active { background: var(--primary-green); }

/* Action Buttons */
.action-buttons {
    display:flex; justify-content:space-between; padding:10px;
    gap:5px;
}
.action-btn {
    flex:1; text-align:center; cursor:pointer; padding:5px;
}
.action-btn img { width:40px; height:40px; margin-bottom:3px; }
.action-btn div { font-size:12px; color:var(--text-dark); }

/* Tabs */
.tabs { display:flex; margin:10px; background: #e0f0e8; border-radius:12px; }
.tab { flex:1; padding:10px; text-align:center; cursor:pointer; border-radius:12px; font-weight:600; color:var(--text-light); }
.tab.active { background: var(--primary-green); color: #fff; }

/* Plan Cards */
.content-wrapper { padding:0 15px 90px; }
.plan-list { display:flex; flex-direction:column; gap:10px; }
.plan-card { background:#fff; border-radius:12px; padding:15px; box-shadow:0 2px 10px rgba(0,0,0,0.1); }
.plan-title { font-weight:600; color:var(--primary-green); margin-bottom:10px; }
.plan-body { display:flex; gap:10px; align-items:center; }
.plan-image-container { width:80px; height:80px; overflow:hidden; border-radius:12px; }
.plan-image { width:100%; height:100%; object-fit:cover; }
.plan-details { flex:1; font-size:0.9rem; color:var(--text-dark); }
.detail-item { display:flex; justify-content:space-between; margin-bottom:3px; }
.detail-item .value { color:var(--primary-green); font-weight:600; }
.buy-btn { width:100%; padding:10px; margin-top:8px; background:var(--primary-green); color:#fff; border:none; border-radius:50px; font-weight:600; cursor:pointer; }

/* Bottom Navbar */
.bottom-nav {
    position:fixed; bottom:0; left:50%; transform:translateX(-50%);
    width:100%; max-width:600px;
    background:#fff; display:flex; justify-content:space-around;
    padding:10px 0; border-top:1px solid #ccc;
}
.nav-item { display:flex; flex-direction:column; align-items:center; color:var(--text-dark); font-size:12px; cursor:pointer; }
.nav-item.active { color: var(--primary-green); font-weight:600; }
.nav-item img { width:24px; height:24px; margin-bottom:2px; }

/* Floating WhatsApp Icon */
.draggable-icon {
    position:fixed; bottom:80px; right:15px; width:60px; height:60px; border-radius:50%;
    background: var(--primary-green); display:flex; justify-content:center; align-items:center;
    box-shadow: 0 6px 18px rgba(102,204,136,0.25);
    z-index: 99999;
}
.draggable-icon img { width:70%; height:70%; }

/* POPUP COMMON (WhatsApp / Telegram combined) */
.popup-whatsapp {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0, 0, 0, 0.65);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999999;
  animation: fadeInPopup 0.25s ease-in-out;
}
@keyframes fadeInPopup {
  from { opacity: 0; transform: scale(0.98); }
  to { opacity: 1; transform: scale(1); }
}

.popup-box {
  background: #ffffff;
  border-radius: 16px;
  text-align: center;
  padding: 22px;
  width: 92%;
  max-width: 360px;
  box-shadow: 0 8px 36px rgba(0,0,0,0.12);
  position: relative;
  transform-origin: bottom center;
}

/* header image */
.popup-box .logo {
  width:72px; height:72px; border-radius:50%; display:inline-block; overflow:hidden; margin-bottom:10px;
  box-shadow: 0 6px 20px rgba(102,204,136,0.15);
}
.popup-box h3 {
  color: #66cc88;
  font-weight: 700;
  margin-bottom: 6px;
}
.popup-box p {
  color: #333;
  font-size: 14px;
  margin-bottom: 14px;
  line-height: 1.4;
}

/* buttons */
.popup-actions { display:flex; gap:10px; justify-content:center; margin-bottom: 8px; flex-wrap:wrap; }
.popup-actions a, .popup-actions button {
  display:inline-flex; align-items:center; gap:8px;
  padding:10px 14px; border-radius: 10px; border:none; cursor:pointer;
  font-weight:600; text-decoration:none;
}
.btn-telegram { background: #0093DD; color: #fff; }
.btn-whatsapp { background: #25D366; color: #fff; }
.btn-close { background: transparent; color: #666; border: 1px solid #eee; }

/* small note */
.popup-small { font-size:12px; color:#666; margin-top:6px; }

/* close X top-right */
.popup-close-x {
  position:absolute; top:10px; right:10px; background:transparent; border:none; font-size:20px; cursor:pointer; color:#888;
}

/* responsive tweaks */
@media (max-width:420px){
  .action-btn img { width:36px; height:36px; }
  .plan-image-container { width:70px; height:70px; }
}
</style>
</head>

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="goBack()"></span>
    MNC TRADE SYARIAH
    </div>

    <!-- Slider -->
    <div class="slider-container" id="main-slider-container">
        <div class="slider" id="main-slider">
            <?php $__currentLoopData = \App\Models\VipSlider::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slide"><img src="<?php echo e(asset($slider->photo)); ?>" alt="Slider Image"></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="dots" id="slider-dots-container"></div>
    </div>

    <!-- Action Buttons -->
    <div class="action-buttons"> 
      <div class="action-btn" onclick="openPage('user/recharge')">
        <img src="https://api.iconify.design/solar:card-send-bold-duotone.svg?color=%2366cc88" alt="Isi Ulang">
        <div>Isi Ulang</div>
      </div>
      <div class="action-btn" onclick="openPage('/withdraw')">
        <img src="https://api.iconify.design/solar:wallet-money-bold-duotone.svg?color=%2366cc88" alt="Withdraw">
        <div>Withdraw</div>
      </div>
      <div class="action-btn" onclick="openPage('/promo')">
        <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%2366cc88" alt="Hadiah">
        <div>Hadiah</div>
      </div>
      <div class="action-btn" onclick="openPage('/my/vip')"> 
        <img src="https://api.iconify.design/solar:chart-square-bold-duotone.svg?color=%2366cc88" alt="Investasi Saya">
        <div>Investasi</div>
      </div>
    </div>

    <!-- Tabs -->
    <div class="tabs">
        <button class="tab active" onclick="switchTab(event, 'daily-income')">VIP</button>
    </div>

    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">
        <div id="daily-income" class="plan-list">
            <?php if($packageOne->count() > 0): ?>
                <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first(); ?>
                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span class="label">Pendapatan Perhari:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element->validity); ?> Hari</span></div>
                                <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>
                        <?php if($myVip): ?>
                            <button class="buy-btn" disabled>Aktif</button>
                        <?php elseif($element->status == 'coming'): ?>
                            <button class="buy-btn" disabled>Coming</button>
                        <?php else: ?>
                            <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">Beli Sekarang</button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p style="text-align:center;padding:20px;">No daily income plans available.</p>
            <?php endif; ?>
        </div>

        <div id="welfare-plan" class="plan-list" style="display:none;">
            <?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element['name']); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element['photo'])); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element['price'])); ?></span></div>
                            <div class="detail-item"><span class="label">Pendapatan Perhari :</span><span class="value"><?php echo e(price($element['daily_limit'])); ?></span></div>
                            <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element['validity']); ?> days</span></div>
                            <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></span></div>
                        </div>
                        <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">Beli Sekarang</button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

</div> <!-- Tutup main-container -->

<!-- Bottom Navbar -->
<div class="bottom-nav">
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>

<!-- Floating WhatsApp Icon (ke-remote CS) -->
<div class="draggable-icon" id="floatingCs" title="Hubungi CS" onclick="openWhatsAppCS()">
  <img src="https://api.iconify.design/logos:whatsapp.svg" alt="WA CS">
</div>

<!-- The communication popup will be injected by JS when needed -->

<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

// Slider
document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    if(slider){
        const slides=Array.from(slider.children);
        let dots=[];
        slides.forEach((_,i)=>{
            const dot=document.createElement('div');
            dot.classList.add('dot');
            dot.addEventListener('click',()=>goToSlide(i));
            dotsContainer.appendChild(dot);
            dots.push(dot);
        });
        let current=0;
        const goToSlide=(i)=>{
            current=i;
            slider.style.transform=`translateX(-${i*100}%)`;
            dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
        };
        if (typeof window.goToSlide === 'undefined') window.goToSlide = function(i){ goToSlide(i); };
        goToSlide(0);
        if(slides.length>1) setInterval(()=>goToSlide((current+1)%slides.length),3000);
    }
});

// Tabs
function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    const el = document.getElementById(id);
    if(el) el.style.display='flex';
    evt.currentTarget.classList.add('active');
}

/* ---------- New: Communication popup (Telegram channel + WhatsApp CS) ---------- */

/*
 Behavior:
 - Shows a centered popup offering "Telegram Channel" and "WhatsApp CS"
 - Can be closed with the X button or by clicking outside the box
 - Will auto-disappear after 10 seconds
 - On page refresh the popup will appear again (no persistence)
 - Does not overwrite existing functions; only adds new helpers
*/

/* Edit these links to your real channels/numbers */
const TELEGRAM_CHANNEL_URL = "https://t.me/+mHBZ_mbwcTBlZjNl";
const WHATSAPP_CS_URL = "https://t.me/+mHBZ_mbwcTBlZjNl"

function showCommPopup(){
  // avoid multiple popups
  if(document.getElementById('comm-popup')) return;

  const overlay = document.createElement('div');
  overlay.id = 'comm-popup';
  overlay.className = 'popup-whatsapp';
  overlay.innerHTML = `
    <div class="popup-box" id="popupBox">
      <button class="popup-close-x" aria-label="close">&times;</button>
      <div class="logo"><img src="hg.png" style="width:100%;height:100%;object-fit:cover;" alt=""></div>
      <h3>Gabung dan ikutin</h3>
      <p>Ikuti channel Telegram kami untuk update, atau hubungi CS lewat WhatsApp untuk bantuan cepat.</p>
      <div class="popup-actions">
        <a class="btn-telegram" href="${TELEGRAM_CHANNEL_URL}" target="_blank" rel="noopener noreferrer">
          <img src="https://api.iconify.design/logos:telegram.svg" style="width:18px;height:18px;" alt="">
          Telegram Channel
        </a>
        <a class="btn-whatsapp" href="${WHATSAPP_CS_URL}" target="_blank" rel="noopener noreferrer">
          <img src="https://api.iconify.design/logos:whatsapp.svg" style="width:18px;height:18px;" alt="">
          WhatsApp CS
        </a>
      </div>
      <div class="popup-small"></div>
    </div>
  `;

  document.body.appendChild(overlay);

  // close handlers
  const popupBox = document.getElementById('popupBox');
  overlay.querySelector('.popup-close-x').addEventListener('click', ()=> overlay.remove());
  overlay.addEventListener('click', (e)=>{
    if(!popupBox.contains(e.target)) overlay.remove();
  });

  // auto remove after 10s
  setTimeout(()=>{ if(document.getElementById('comm-popup')) document.getElementById('comm-popup').remove(); }, 10000);
}

/* Keep named function showWhatsAppPopup because original script referenced it.
   We'll map it to showCommPopup so existing calls keep working. */
function showWhatsAppPopup(){ showCommPopup(); }

/* small helper for the floating CS icon */
function openWhatsAppCS(){
  window.open(WHATSAPP_CS_URL, '_blank');
}

/* Initialize: show popup shortly after DOM ready */
document.addEventListener("DOMContentLoaded", ()=>{
    setTimeout(showWhatsAppPopup, 1000);
});


/* Optional: make the floating icon draggable (light implementation) */
(function makeDraggable(){
  const el = document.getElementById('floatingCs');
  if(!el) return;
  let isDown=false, startX=0, startY=0, origX=0, origY=0;
  el.addEventListener('mousedown', (e)=>{
    isDown=true; startX=e.clientX; startY=e.clientY;
    const rect = el.getBoundingClientRect();
    origX = rect.left; origY = rect.top;
    el.style.transition = 'none';
    e.preventDefault();
  });
  document.addEventListener('mousemove', (e)=>{
    if(!isDown) return;
    const dx = e.clientX - startX;
    const dy = e.clientY - startY;
    el.style.left = (origX + dx) + 'px';
    el.style.top = (origY + dy) + 'px';
    el.style.right = 'auto';
    el.style.bottom = 'auto';
  });
  document.addEventListener('mouseup', ()=>{ if(isDown){ isDown=false; el.style.transition='left 0.2s, top 0.2s'; } });
  // touch events
  el.addEventListener('touchstart', (ev)=>{
    isDown=true; const t = ev.touches[0]; startX=t.clientX; startY=t.clientY;
    const rect = el.getBoundingClientRect(); origX = rect.left; origY = rect.top;
  }, {passive:true});
  document.addEventListener('touchmove', (ev)=>{
    if(!isDown) return;
    const t = ev.touches[0]; const dx = t.clientX - startX; const dy = t.clientY - startY;
    el.style.left = (origX + dx) + 'px';
    el.style.top = (origY + dy) + 'px';
    el.style.right = 'auto';
    el.style.bottom = 'auto';
  }, {passive:true});
  document.addEventListener('touchend', ()=> isDown=false);
})();
</script>

</body>
</html>
<?php /**PATH /home/mnctrad1/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>