<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Login</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-world: #228B22; /* hijau daun */
      --secondary-world: #32CD32; /* hijau terang lembut */
      --text-dark: #0B3D0B; /* teks gelap */
      --bg-light: #ffffff; /* background putih */
      --bg-accent: #F0FFF0; /* hijau sangat soft untuk card */
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: radial-gradient(circle at top, var(--bg-accent) 0%, var(--bg-light) 70%, #ffffff 100%);
      color: var(--text-dark);
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    .page-wraper {
      width: 100%;
      max-width: 400px;
      background: rgba(50, 205, 50, 0.05);
      border-radius: 20px;
      backdrop-filter: blur(8px);
      box-shadow: 0 0 20px rgba(34, 139, 34, 0.2);
      padding: 30px 25px;
      text-align: center;
    }

    .welcome-title {
      font-size: 22px;
      font-weight: 600;
      color: var(--primary-world);
      margin-bottom: 10px;
    }

    .welcome-subtitle {
      font-size: 15px;
      color: var(--text-dark);
      margin-bottom: 25px;
      line-height: 1.4;
    }

    .tab-navigation {
      display: flex;
      margin-bottom: 25px;
      border-radius: 12px;
      overflow: hidden;
      background: rgba(34, 139, 34, 0.08);
      box-shadow: inset 0 0 10px rgba(34, 139, 34, 0.2);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      background: transparent;
      color: var(--text-dark);
      transition: all 0.3s ease;
      border: none;
    }

    .tab.active {
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: #ffffff;
      box-shadow: 0 0 10px rgba(34, 139, 34, 0.3);
    }

    .input-group {
      display: flex;
      align-items: center;
      background: rgba(34, 139, 34, 0.08);
      border: 1px solid rgba(34, 139, 34, 0.15);
      border-radius: 14px;
      margin-bottom: 20px;
      padding: 0 10px;
      transition: all 0.3s ease;
    }

    .input-group:focus-within {
      border-color: var(--primary-world);
      box-shadow: 0 0 8px rgba(34, 139, 34, 0.4);
      transform: scale(1.01);
    }

    .input-icon {
      width: 40px;
      text-align: center;
      color: var(--primary-world);
      font-size: 18px;
    }

    .input-field {
      flex: 1;
      padding: 12px 10px;
      border: none;
      background: transparent;
      color: var(--text-dark);
      font-size: 15px;
    }

    .input-field::placeholder {
      color: rgba(11, 61, 11, 0.6);
    }

    .input-field:focus {
      outline: none;
    }

    .forgot-link {
      display: block;
      text-align: right;
      font-size: 14px;
      color: var(--primary-world);
      text-decoration: none;
      margin-bottom: 20px;
      transition: all 0.3s;
    }

    .forgot-link:hover {
      color: var(--secondary-world);
      text-shadow: 0 0 6px rgba(34, 139, 34, 0.3);
    }

    .submit-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: #ffffff;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      box-shadow: 0 0 15px rgba(34, 139, 34, 0.2);
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, var(--secondary-world), #228B22);
      box-shadow: 0 0 25px rgba(34, 139, 34, 0.4);
      transform: scale(1.02);
    }

    @media (max-width: 450px) {
      .page-wraper {
        padding: 20px 15px;
      }
      .welcome-title {
        font-size: 20px;
      }
    }
  </style>
</head>

<body>

  <div class="page-wraper">
    <!-- Welcome text -->
    <h1 class="welcome-title">Selamat Datang di MNC Trade Syariah</h1>
    <p class="welcome-subtitle">Bersama kita bangun masa depan lebih cerah lagi</p>

    <!-- Tab Navigation -->
    <div class="tab-navigation">
      <button class="tab active">Log In</button>
      <a href="<?php echo e(route('register')); ?>" class="tab">Register</a>
    </div>

    <!-- Form Login -->
    <form action="<?php echo e(url('login')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="input-group">
        <i class="fas fa-mobile-alt input-icon"></i>
        <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
      </div>

      <div class="input-group">
        <i class="fas fa-lock input-icon"></i>
        <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
      </div>

      <a href="#" class="forgot-link">Lupa kata sandi?</a>

      <button type="submit" class="submit-btn">Masuk Sekarang</button>
    </form>
  </div>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/mnctrad1/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>