<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Tim</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
  --primary-green: #66cc88;
  --light-green: #cceedd;
  --bg: #f5f5f5;
  --text-dark: #1a1a1a;
  --text-light: #555;
  --card-bg: #ffffff;
}

/* RESET */
* { margin:0; padding:0; box-sizing:border-box; }
body {
  font-family:'Poppins',sans-serif;
  background: var(--bg);
  color: var(--text-dark);
  min-height:100vh;
}

/* CONTAINER */
.main-container {
  max-width:600px;
  margin:0 auto;
  position:relative;
  padding-bottom:120px;
  background:rgba(255,255,255,0.95);
  border-radius:15px;
  box-shadow:0 0 15px rgba(102,204,136,0.25);
}

/* HEADER */
.header {
  background: var(--primary-green);
  padding:16px 20px;
  display:flex;
  justify-content:center;
  align-items:center;
  position:relative;
  border-radius:15px 15px 0 0;
  color:#fff;
  box-shadow:0 5px 15px rgba(102,204,136,0.4);
}
.header .back-btn {
  position:absolute;
  left:20px;
  font-size:28px;
  color:#fff;
  cursor:pointer;
  transition:transform 0.3s;
}
.header .back-btn:hover { transform:scale(1.15); }
.header .header-title { font-size:1.4rem; font-weight:700; letter-spacing:0.5px; }

/* CONTENT */
.content-wrapper {
  padding:22px 15px 120px;
}

/* STAT BOX */
.stats-box {
  background:var(--card-bg);
  border-radius:20px;
  padding:24px;
  text-align:center;
  margin-bottom:16px;
  box-shadow:0 5px 15px rgba(102,204,136,0.25);
  border:1px solid #e0f0e8;
}
.stats-box .stat-label {
  font-size:14px;
  color:var(--text-light);
}
.stats-box .stat-value {
  font-size:26px;
  font-weight:700;
  color:var(--primary-green);
}
.stats-box .sub-stats {
  display:flex;
  justify-content:space-around;
  border-top:1px solid #e0e0e0;
  margin-top:12px;
  padding-top:12px;
}

/* REFERRAL BOX */
.referral-box {
  display:flex;
  justify-content:space-between;
  align-items:center;
  background:#ffffff;
  padding:16px 18px;
  border-radius:18px;
  margin:15px 0 20px;
  border:1px solid #cceedd;
  box-shadow:0 4px 15px rgba(102,204,136,0.25);
  transition:all 0.3s;
}
.referral-box:hover {
  transform:translateY(-3px);
  box-shadow:0 6px 20px rgba(102,204,136,0.4);
}
.referral-text {
  font-size:14px;
  color:var(--text-dark);
  flex:1;
  margin-right:10px;
  word-break:break-all;
}
.copy-btn {
  background: var(--primary-green);
  color:#fff;
  border:none;
  padding:10px 16px;
  border-radius:12px;
  font-weight:600;
  font-size:14px;
  cursor:pointer;
  transition:all 0.3s;
}
.copy-btn:hover {
  transform:scale(1.05);
  box-shadow:0 0 15px rgba(102,204,136,0.5);
}

/* LEVEL BOX */
.level-deposit-box {
  background:var(--card-bg);
  border-radius:16px;
  text-align:center;
  padding:16px;
  margin-bottom:18px;
  box-shadow:0 5px 15px rgba(102,204,136,0.2);
  border:1px solid #e0f0e8;
  transition:transform 0.3s;
}
.level-deposit-box:hover {
  transform:translateY(-2px);
  box-shadow:0 8px 20px rgba(102,204,136,0.4);
}
.level-deposit-box h3 {
  color:var(--primary-green);
  font-size:16px;
  margin-bottom:6px;
  font-weight:600;
}
.level-deposit-box p {
  font-size:18px;
  font-weight:700;
  color:var(--text-dark);
}

/* TABS */
.team-tabs {
  display:flex;
  background:#eaf9f0;
  border-radius:16px;
  padding:6px;
  margin-bottom:20px;
}
.tab-btn {
  flex:1;
  padding:12px;
  text-align:center;
  border:none;
  border-radius:12px;
  background:transparent;
  color:var(--text-light);
  font-weight:600;
  cursor:pointer;
  transition:all 0.3s;
}
.tab-btn.active {
  background:var(--primary-green);
  color:#fff;
  box-shadow:0 0 15px rgba(102,204,136,0.5);
}
.tab-content { display:none; }
.tab-content.active { display:block; }

/* USER CARDS */
.user-list {
  display:flex;
  flex-direction:column;
  gap:14px;
}
.user-card {
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:16px;
  border-radius:16px;
  background:var(--card-bg);
  border:1px solid #e0f0e8;
  box-shadow:0 4px 10px rgba(102,204,136,0.15);
  transition:all 0.3s;
}
.user-card:hover {
  transform:translateY(-3px);
  box-shadow:0 8px 20px rgba(102,204,136,0.3);
}
.user-info .user-id {
  font-weight:700;
  font-size:16px;
  color:var(--primary-green);
}
.user-info .join-date, .user-info .team-deposit {
  font-size:13px;
  color:var(--text-light);
}
.user-status {
  font-size:14px;
  font-weight:700;
  color:var(--primary-green);
}

/* NO RECORD */
.no-record {
  text-align:center;
  padding:40px 20px;
  background:var(--card-bg);
  border-radius:16px;
  color:var(--text-light);
  border:1px solid #e0f0e8;
}

/* BOTTOM NAV */
.bottom-nav {
  position:fixed;
  bottom:0;
  left:50%;
  transform:translateX(-50%);
  width:100%;
  max-width:600px;
  background:#fff;
  display:flex;
  justify-content:space-around;
  padding:12px 0;
  box-shadow:0 -2px 10px rgba(102,204,136,0.15);
  border-top:1px solid #d8f0e0;
  z-index:1000;
  border-radius:16px 16px 0 0;
}
.nav-item {
  display:flex;
  flex-direction:column;
  align-items:center;
  color:var(--text-light);
  cursor:pointer;
  transition:all 0.3s;
}
.nav-item.active .nav-label {
  color:var(--primary-green);
  font-weight:600;
}
.nav-item img {
  width:28px;
  height:28px;
  margin-bottom:4px;
  transition:all 0.3s;
}
.nav-item:hover img {
  transform:scale(1.2);
}
.nav-label {
  font-size:12px;
  font-weight:600;
}
</style>
</head>

<body>
<div class="main-container">

  <!-- HEADER -->
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">MNC TRADE SYARIAH</h1>
  </div>

  <!-- CONTENT -->
  <div class="content-wrapper">
    <!-- STATISTIK TEAM -->
    <div class="stats-box">
      <div class="main-stat">
        <div class="stat-label">Deposit Tim</div>
        <div class="stat-value"><?php echo e(price($totalDeposit1 + $totalDeposit2 + $totalDeposit3)); ?></div>
      </div>
      <div class="sub-stats">
        <div class="stat-item">
          <div class="stat-label">Total Asset</div>
          <div class="stat-value"><?php echo e(price($totalCommission1 + $totalCommission2 + $totalCommission3)); ?></div>
        </div>
        <div class="stat-item">
          <div class="stat-label">Total Anggota Tim:</div>
          <div class="stat-value"><?php echo e($team_size ?? 0); ?></div>
        </div>
      </div>
    </div>

    <!-- REFERRAL BOX -->
    <div class="referral-box">
      <div class="referral-text" id="referralLink"><?php echo e(url('register') . '?inviteCode=' . auth()->user()->ref_id); ?></div>
      <button class="copy-btn" onclick="copyReferral()">Salin <i class="fa fa-copy"></i></button>
    </div>

    <!-- TABS -->
    <div class="team-tabs">
      <button class="tab-btn active" onclick="switchTab(event, 'level-1')">1-level</button>
      <button class="tab-btn" onclick="switchTab(event, 'level-2')">2-level</button>
      <button class="tab-btn" onclick="switchTab(event, 'level-3')">3-level</button>
    </div>

    <!-- LEVEL 1 -->
    <div id="level-1" class="tab-content active">
      <div class="level-deposit-box">
        <h3>Total Deposit Level 1</h3>
        <p><?php echo e(price($totalDeposit1)); ?></p>
      </div>
      <?php if($first_level_users->count() > 0): ?>
      <div class="user-list">
        <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="user-card">
          <div class="user-info">
            <div class="user-id"><?php echo e($user->username); ?></div>
            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
          </div>
          <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Nonaktif'); ?></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <?php else: ?>
      <div class="no-record">Tidak ada data</div>
      <?php endif; ?>
    </div>

    <!-- LEVEL 2 -->
    <div id="level-2" class="tab-content">
      <div class="level-deposit-box">
        <h3>Total Deposit Level 2</h3>
        <p><?php echo e(price($totalDeposit2)); ?></p>
      </div>
      <?php if($second_level_users->count() > 0): ?>
      <div class="user-list">
        <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="user-card">
          <div class="user-info">
            <div class="user-id"><?php echo e($user->username); ?></div>
            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
          </div>
          <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Nonaktif'); ?></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <?php else: ?>
      <div class="no-record">Tidak ada data</div>
      <?php endif; ?>
    </div>

    <!-- LEVEL 3 -->
    <div id="level-3" class="tab-content">
      <div class="level-deposit-box">
        <h3>Total Deposit Level 3</h3>
        <p><?php echo e(price($totalDeposit3)); ?></p>
      </div>
      <?php if($third_level_users->count() > 0): ?>
      <div class="user-list">
        <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="user-card">
          <div class="user-info">
            <div class="user-id"><?php echo e($user->username); ?></div>
            <div class="team-deposit">Deposit Tim: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
          </div>
          <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Nonaktif'); ?></div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <?php else: ?>
      <div class="no-record">Tidak ada data</div>
      <?php endif; ?>
    </div>
  </div>

  <!-- BOTTOM NAV -->
  <div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
      <img src="https://api.iconify.design/solar:home-2-bold.svg" class="nav-icon">
      <div class="nav-label">Beranda</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/my/vip'">
      <img src="https://api.iconify.design/solar:chart-bold.svg" class="nav-icon">
      <div class="nav-label">Investasi</div>
    </div>
    <div class="nav-item active" onclick="window.location.href='/my-team'">
      <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg" class="nav-icon">
      <div class="nav-label">Tim</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/mine'">
      <img src="https://api.iconify.design/solar:user-circle-bold.svg" class="nav-icon">
      <div class="nav-label">Profil</div>
    </div>
  </div>
</div>

<script>
function switchTab(event, tabId) {
  document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
  document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
  document.getElementById(tabId).classList.add('active');
  event.currentTarget.classList.add('active');
}

function copyReferral() {
  const text = document.getElementById("referralLink").innerText;
  navigator.clipboard.writeText(text).then(() => {
    const btn = document.querySelector(".copy-btn");
    btn.innerHTML = "Disalin ✔";
    btn.style.background = "#4fdc8b";
    setTimeout(() => {
      btn.innerHTML = 'Salin <i class="fa fa-copy"></i>';
      btn.style.background = "var(--primary-green)";
    }, 2000);
  });
}
</script>
</body>
</html>
<?php /**PATH /home/mnctrad1/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>