<!DOCTYPE html>    
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>my VIP</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
  --primary-green: #66cc88; /* hijau lembut utama */
  --primary-green-dark: #4fb172;
  --soft-green: #e6f6ec;
  --white: #ffffff;
  --text-dark: #1e293b;
  --text-gray: #64748b;
  --shadow-light: rgba(102, 204, 136, 0.2);
}

/* GLOBAL */
* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
  width: 100%;
  min-height: 100%;
  background: linear-gradient(to bottom, var(--white) 0%, var(--soft-green) 100%);
  font-family: 'Poppins', sans-serif;
  color: var(--text-dark);
  -webkit-font-smoothing: antialiased;
  overflow-x: hidden;
}
a { text-decoration: none; color: inherit; }
img { user-select: none; }

.main-container { 
  width: 100%;
  max-width: 600px; 
  margin: 0 auto;
  min-height: 100vh;
  background: var(--white);
  position: relative;
  box-shadow: 0 0 12px var(--shadow-light);
  border-radius: 0 0 20px 20px;
}

/* HEADER */
.header { 
  background: linear-gradient(135deg, var(--primary-green), var(--primary-green-dark));
  padding: 18px 20px;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  border-bottom-left-radius: 25px;
  border-bottom-right-radius: 25px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}
.header .back-btn {
  position: absolute;
  left: 20px;
  font-size: 26px;
  color: #fff;
  cursor: pointer;
  font-weight: bold;
}
.header .header-title {
  font-size: 1.2rem;
  font-weight: 600;
  color: #fff;
}

/* TAB */
.tabs {
  display: flex;
  background: #ecfdf5;
  border-radius: 14px;
  padding: 5px;
  margin: 20px 15px;
  box-shadow: inset 0 1px 5px var(--shadow-light);
}
.tab {
  flex: 1;
  padding: 10px;
  text-align: center;
  font-size: 14px;
  font-weight: 600;
  border-radius: 10px;
  cursor: pointer;
  border: none;
  background: transparent;
  color: var(--text-gray);
  transition: all 0.3s ease;
}
.tab.active {
  background: linear-gradient(135deg, var(--primary-green), var(--primary-green-dark));
  color: #fff;
  box-shadow: 0 3px 12px var(--shadow-light);
}

/* CONTENT */
.content-wrapper { padding: 10px 15px 100px; }
.plan-list {
  display: flex;
  flex-direction: column;
  gap: 15px;
}
.plan-list.hidden { display: none; }

.plan-card {
  background: var(--white);
  border-radius: 18px;
  padding: 16px;
  box-shadow: 0 4px 10px var(--shadow-light);
  transition: transform 0.2s ease, box-shadow 0.3s ease;
}
.plan-card:hover { transform: translateY(-3px); box-shadow: 0 6px 14px var(--shadow-light); }

.plan-title {
  font-size: 1.05rem;
  font-weight: 600;
  color: var(--text-dark);
  margin-bottom: 10px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

/* VIP GROUP */
.vip-group {
  display: inline-flex;
  align-items: center;
  background: linear-gradient(135deg, var(--primary-green-dark), var(--primary-green));
  padding: 6px 10px;
  border-radius: 20px;
  color: #fff;
  font-size: 0.85rem;
  font-weight: 600;
  gap: 6px;
  box-shadow: 0 2px 8px var(--shadow-light);
  transition: all 0.3s ease;
}
.vip-group:hover { opacity: 0.9; transform: translateY(-2px); }

/* PLAN BODY */
.plan-body { display: flex; gap: 15px; align-items: center; }
.plan-image-container { width: 100px; height: 100px; border-radius: 12px; overflow: hidden; }
.plan-image {
  width: 100%; height: 100%; object-fit: cover;
  border-radius: 10px;
}
.plan-details { flex: 1; display: flex; flex-direction: column; }
.detail-item {
  display: flex;
  justify-content: space-between;
  font-size: 0.9rem;
  color: var(--text-gray);
  padding: 6px 0;
}
.detail-item .value { color: var(--primary-green-dark); font-weight: 600; }

/* BUTTON */
.action-btn {
  width: 100%;
  margin-top: 15px;
  padding: 12px;
  background: linear-gradient(135deg, var(--primary-green), var(--primary-green-dark));
  color: #fff;
  border: none;
  border-radius: 10px;
  font-size: 1rem;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.3s ease;
}
.action-btn:hover { opacity: 0.9; transform: translateY(-2px); }
.action-btn.countdown {
  background: #d1d5db;
  color: #475569;
  cursor: default;
}

/* NO RECORD */
.no-record {
  text-align: center;
  padding: 40px 20px;
  color: var(--text-gray);
  background: #f9fafb;
  border-radius: 14px;
  box-shadow: 0 3px 8px var(--shadow-light);
}

/* BOTTOM NAV */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 100%;
  max-width: 600px;
  background: var(--white);
  border-top: 2px solid var(--primary-green);
  display: flex;
  justify-content: space-around;
  padding: 10px 0;
  box-shadow: 0 -3px 10px var(--shadow-light);
  z-index: 1000;
}
.nav-item {
  display: flex; 
  flex-direction: column; 
  align-items: center; 
  color: var(--primary-green-dark);
  text-decoration: none;
  transition: all 0.3s ease;
}
.nav-item img {
  width: 28px; height: 28px; margin-bottom: 4px;
  filter: invert(65%) sepia(18%) saturate(500%) hue-rotate(90deg);
  transition: transform 0.3s ease;
}
.nav-item:hover img { transform: scale(1.1); }
.nav-label { font-size: 12px; font-weight: 500; }
</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <span class="back-btn" onclick="history.back()"></span>
    <h1 class="header-title">MNC TRADE SYARIAH</h1>
  </div>

  <div class="tabs">
    <button class="tab active" onclick="switchTab(event, 'daily-income')">VIP</button>
  </div>

  <?php
      use \App\Models\Package;
      use \App\Models\Purchase;
      use \App\Models\UserLedger;

      $purchasedPackageIds = Purchase::where('user_id', auth()->id())->where('status', 'active')->pluck('package_id');
      $packageOne = Package::whereIn('id', $purchasedPackageIds)->where('tab','vip')->get();
      $packagetwo = Package::whereIn('id', $purchasedPackageIds)->where('tab', 'fixed')->get();
      $packagethree = Package::whereIn('id', $purchasedPackageIds)->where('tab', 'event')->get();
  ?>  

  <div class="content-wrapper">
    <div id="daily-income" class="plan-list">
       <?php if($packageOne->count() > 0): ?>
           <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $myVip = Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
                    $last_claim = UserLedger::where(['user_id' => auth()->id(), 'reason' => 'daily_claim_'.$element->id])->latest()->first();
                    $lastPurchaseDate = $last_claim->created_at ?? $myVip->created_at; 
                    $diffInHours = $lastPurchaseDate->diffInHours(now());
                    $canClaim = !UserLedger::where(['user_id' => auth()->id(), 'reason' => 'daily_claim_'.$element->id])->whereDate('created_at', today())->exists();
                ?>  
                <div class="plan-card">
                    <div class="plan-title">
                        <span><?php echo e($element->name); ?></span>
                        <?php if($myVip): ?>
                        <a href="https://chat.whatsapp.com/LMaJWBWm8nt0GYxPuJYcr8?mode=ems_copy_t" target="_blank" class="vip-group">
                            <i class="fab fa-whatsapp"></i>
                            <span>Grup VIP</span>
                        </a>
                        <?php endif; ?>
                    </div>

                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span class="label">Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                            <div class="detail-item"><span class="label">Pendapatan Harian:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                            <div class="detail-item"><span class="label">Total Pendapatan:</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                        </div>
                    </div>

                    <?php if($diffInHours < 24): ?>
                        <button class="action-btn countdown" id="countdown-<?php echo e($element->id); ?>">00j 00m 00d</button>
                    <?php elseif($canClaim): ?>
                        <button class="action-btn" onclick="window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'">Klaim Sekarang</button>
                    <?php else: ?>
                        <button class="action-btn countdown" disabled>Sudah Diklaim</button>
                    <?php endif; ?>
                    
                    <script>
                        (function() {
                            let lastPurchaseDate = new Date("<?php echo e($lastPurchaseDate); ?>");
                            let endTime = new Date(lastPurchaseDate.getTime() + 24 * 60 * 60 * 1000);
                            const countdownEl = document.getElementById("countdown-<?php echo e($element->id); ?>");
                            if (!countdownEl) return;
                            function updateCountdown() {
                                let now = new Date().getTime();
                                let distance = endTime - now;
                                if (distance < 0) {
                                    clearInterval(countdownInterval);
                                    countdownEl.style.display = 'none';
                                    const claimButton = document.querySelector(`button[onclick*="vip_id=<?php echo e($element->id); ?>"]`);
                                    if (claimButton) claimButton.style.display = 'block';
                                    return;
                                }
                                let h = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                                let m = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                                let s = Math.floor((distance % (1000 * 60)) / 1000);
                                countdownEl.innerText = `${h.toString().padStart(2, '0')}j ${m.toString().padStart(2, '0')}m ${s.toString().padStart(2, '0')}d`;
                            }
                            if (countdownEl.classList.contains('countdown')) {
                                var countdownInterval = setInterval(updateCountdown, 1000);
                                updateCountdown();
                            }
                        })();
                    </script>
                </div>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       <?php else: ?>
           <div class="no-record">Tidak ada rencana harian aktif.</div>
       <?php endif; ?>
    </div>

    <div id="welfare-plan" class="plan-list hidden">
        <?php $welfarePackages = $packagetwo->merge($packagethree); ?>
        <?php if($welfarePackages->count() > 0): ?>
            <?php $__currentLoopData = $welfarePackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $myVip = Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
                ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span class="label">Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                            <div class="detail-item"><span class="label">Siklus:</span><span class="value"><?php echo e($element->validity); ?> hari</span></div>
                            <div class="detail-item"><span class="label">Total Keuntungan:</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                        </div>
                    </div>
                    <?php if($myVip->created_at->addDays($element->validity) <= now()): ?>
                        <button class="action-btn" onclick="window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'">Klaim Sekarang</button>
                    <?php else: ?>
                        <button class="action-btn countdown" disabled>Berjalan</button>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="no-record">Tidak ada rencana kesejahteraan aktif.</div>
        <?php endif; ?>
    </div>
  </div>
  
  <div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
      <img src="https://api.iconify.design/solar:home-2-bold.svg">
      <div class="nav-label">Home</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/my/vip'">
      <img src="https://api.iconify.design/solar:chart-bold.svg">
      <div class="nav-label">Investasi</div>
    </div>
    <div class="nav-item" onclick="window.location.href='/my-team'">
      <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg">
      <div class="nav-label">Team</div>
    </div>
    <div class="nav-item active" onclick="window.location.href='/mine'">
      <img src="https://api.iconify.design/solar:user-circle-bold.svg">
      <div class="nav-label">Profil</div>
    </div>
  </div>
</div>

<script src="/assets/app/js/jquery.js"></script>
<script>
function switchTab(evt, tabId) {
  document.querySelectorAll('.plan-list').forEach(c => c.classList.add('hidden'));
  document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
  const activeTab = document.getElementById(tabId);
  if (activeTab) activeTab.classList.remove('hidden');
  evt.currentTarget.classList.add('active');
}
</script>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/mnctrad1/public_html/resources/views/app/main/myvip.blade.php ENDPATH**/ ?>