<!DOCTYPE html>  
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <link rel="icon" type="image/png" href="<?php echo e(setting('logo')); ?>">
  <title>Register</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-blue: #00eaff;
      --deep-blue: #021526;
      --text-color: #ffffff;
      --light-blue: #0077ff;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: radial-gradient(circle at top, #021526 0%, #010b14 60%, #000 100%);
      color: var(--text-color);
      overflow-x: hidden;
      position: relative;
    }

    .particles {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      overflow: hidden;
      z-index: -1;
    }

    .particle {
      position: absolute;
      width: 6px;
      height: 6px;
      background: #00eaff;
      border-radius: 50%;
      animation: float 10s linear infinite;
      opacity: 0.6;
    }

    @keyframes float {
      from { transform: translateY(100vh) scale(0.5); opacity: 0; }
      50% { opacity: 1; }
      to { transform: translateY(-10vh) scale(1); opacity: 0; }
    }

    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: rgba(255, 255, 255, 0.06);
      border-radius: 20px;
      backdrop-filter: blur(12px);
      box-shadow: 0 0 25px rgba(0, 255, 255, 0.2);
      overflow: hidden;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      position: relative;
      z-index: 2;
    }

    .back-arrow {
      font-size: 24px;
      color: var(--text-color);
      text-decoration: none;
      position: absolute;
      left: 15px;
    }

    .header-title {
      font-size: 22px;
      font-weight: 600;
      text-align: center;
      flex-grow: 1;
      color: #00eaff;
      text-shadow: 0 0 12px rgba(0, 234, 255, 0.6);
    }

    .banner-container {
      position: relative;
      overflow: hidden;
    }

    .banner-image {
      width: 100%;
      display: block;
      border-bottom: 2px solid rgba(0, 234, 255, 0.3);
      box-shadow: 0 4px 20px rgba(0, 234, 255, 0.1);
    }

    .banner-shine {
      position: absolute;
      top: 0;
      left: -100%;
      width: 60%;
      height: 100%;
      background: linear-gradient(120deg, transparent, rgba(255, 255, 255, 0.35), transparent);
      animation: shineMove 4s infinite;
    }

    @keyframes shineMove {
      0% { left: -100%; }
      50%,100% { left: 120%; }
    }

    .auth-container {
      padding: 25px 25px 40px;
      margin-top: -15px;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      position: relative;
      z-index: 1;
    }

    .tab-navigation {
      display: flex;
      background: rgba(255, 255, 255, 0.08);
      border-radius: 12px;
      padding: 6px;
      margin-bottom: 25px;
      box-shadow: inset 0 0 10px rgba(0, 234, 255, 0.3);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 9px;
      cursor: pointer;
      background: transparent;
      color: var(--text-color);
      transition: all 0.3s ease;
    }

    .tab.active {
      background: linear-gradient(135deg, #00eaff, #0077ff);
      color: #fff;
      box-shadow: 0 0 12px rgba(0, 234, 255, 0.4);
    }

    .input-group {
      position: relative;
      margin-bottom: 22px;
      display: flex;
      align-items: center;
      background: rgba(255, 255, 255, 0.08);
      border: 1px solid rgba(0, 234, 255, 0.2);
      border-radius: 14px;
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .input-group:focus-within {
      border-color: #00eaff;
      box-shadow: 0 0 12px rgba(0, 234, 255, 0.5);
      transform: scale(1.01);
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: #00eaff;
      font-size: 18px;
      border-right: 1px solid rgba(0, 234, 255, 0.1);
    }

    .input-field {
      flex: 1;
      padding: 15px;
      font-size: 15px;
      background: transparent;
      border: none;
      color: #fff;
    }

    .input-field::placeholder {
      color: rgba(255, 255, 255, 0.5);
    }

    .captcha-container {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 22px;
    }

    .captcha-box {
      background: #0c2238;
      border-radius: 12px;
      padding: 10px 20px;
      font-size: 22px;
      font-weight: bold;
      letter-spacing: 5px;
      color: #00eaff;
      text-shadow: 0 0 8px rgba(0, 234, 255, 0.8);
      user-select: none;
      box-shadow: inset 0 0 12px rgba(0, 234, 255, 0.3);
    }

    .refresh-btn {
      background: transparent;
      border: none;
      color: #00eaff;
      font-size: 20px;
      cursor: pointer;
      transition: 0.3s;
    }

    .refresh-btn:hover {
      transform: rotate(180deg);
      color: #fff;
    }

    .error-message {
      color: #ff4e4e;
      text-align: center;
      margin-top: -10px;
      margin-bottom: 10px;
      font-weight: 600;
      text-shadow: 0 0 6px rgba(255, 0, 0, 0.6);
      display: none;
    }

    .submit-btn {
      width: 100%;
      padding: 15px;
      background: linear-gradient(135deg, #00eaff, #0077ff);
      color: #fff;
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      margin-top: 20px;
      box-shadow: 0 0 20px rgba(0, 234, 255, 0.3);
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, #00b8ff, #004aff);
      box-shadow: 0 0 30px rgba(0, 234, 255, 0.6);
      transform: scale(1.02);
    }
  </style>
</head>

<body>
  <div class="particles">
    <div class="particle" style="left:10%; animation-delay:0s;"></div>
    <div class="particle" style="left:30%; animation-delay:2s;"></div>
    <div class="particle" style="left:50%; animation-delay:4s;"></div>
    <div class="particle" style="left:70%; animation-delay:1s;"></div>
    <div class="particle" style="left:90%; animation-delay:3s;"></div>
  </div>

  <div class="page-wraper">
    <header class="header">
      <a href="javascript:history.back()" class="back-arrow">&#60;</a>
      <h1 class="header-title">Register</h1>
    </header>

    <div class="banner-container">
      <img src="/img/card1.jpg" alt="Banner" class="banner-image">
      <div class="banner-shine"></div>
    </div>

    <div class="auth-container">
      <div class="tab-navigation">
        <a href="<?php echo e(route('login')); ?>" class="tab">Log In</a>
        <button class="tab active">Register</button>
      </div>

      <form id="registerForm" action="<?php echo e(route('register')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-user input-icon"></i>
          <input type="text" name="name" class="input-field" placeholder="Username" required>
        </div>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password_confirmation" class="input-field" placeholder="Konfirmasi Kata Sandi" required>
        </div>

        <div class="input-group">
          <i class="fas fa-ticket-alt input-icon"></i>
          <input type="text" id="referralCode" name="ref_id" class="input-field" placeholder="Kode Refferal">
        </div>

        <div class="captcha-container">
          <div id="captchaBox" class="captcha-box"></div>
          <button type="button" class="refresh-btn" onclick="generateCaptcha()">
            <i class="fas fa-sync-alt"></i>
          </button>
        </div>

        <div class="input-group">
          <i class="fas fa-key input-icon"></i>
          <input type="text" name="otp" id="otpInput" class="input-field" placeholder="Masukkan Kode OTP dari Gambar" required>
        </div>

        <div id="errorMsg" class="error-message">⚠️ Kode OTP salah!</div>

        <button type="submit" class="submit-btn">Register</button>
      </form>
    </div>
  </div>

  <script>
    // Generate kode CAPTCHA
    function generateCaptcha() {
      const captchaBox = document.getElementById("captchaBox");
      const chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
      let otp = "";
      for (let i = 0; i < 6; i++) otp += chars.charAt(Math.floor(Math.random() * chars.length));
      captchaBox.textContent = otp;
      captchaBox.dataset.code = otp;
    }
    document.addEventListener("DOMContentLoaded", generateCaptcha);

    // Validasi OTP
    document.getElementById("registerForm").addEventListener("submit", function (e) {
      const userOtp = document.getElementById("otpInput").value.trim().toUpperCase();
      const correctOtp = document.getElementById("captchaBox").dataset.code;
      const errorMsg = document.getElementById("errorMsg");

      if (userOtp !== correctOtp) {
        e.preventDefault();
        errorMsg.style.display = "block";
        document.getElementById("otpInput").style.border = "1px solid #ff4e4e";
        generateCaptcha();
      } else {
        errorMsg.style.display = "none";
      }
    });

    // 🔹 Auto isi kode referral dari URL
    document.addEventListener("DOMContentLoaded", function () {
      const urlParams = new URLSearchParams(window.location.search);
      const inviteCode = urlParams.get("inviteCode");
      if (inviteCode) {
        document.getElementById("referralCode").value = inviteCode;
      }
    });
  </script>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/runnlvbg/card5dgtal.com/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>