<!DOCTYPE html>      
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Tim</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-color: #FFD600;       /* KUNING */
    --accent-color: #FFB800;        /* KUNING GELAP */
    --bg-color: #ffffff;            /* PUTIH */
    --card-bg: #ffffff;
    --text-color: #111111;
    --subtext-color: #666666;
    --border-color: #eaeaea;
    --hover-shadow: 0 8px 20px rgba(255, 214, 0, 0.35);
}

/* RESET */
* { margin:0; padding:0; box-sizing:border-box; }
html, body { 
    font-family:'Poppins', sans-serif; 
    background:var(--bg-color);
    color:var(--text-color);
    min-height:100vh;
}

/* CONTAINER */
.main-container { max-width:600px; margin:0 auto; position:relative; padding-bottom:120px; }

/* HEADER */
.header {
    background: var(--primary-color);
    padding:16px 20px;
    display:flex;
    justify-content:center;
    align-items:center;
    position:relative;
    box-shadow:0 5px 15px rgba(0,0,0,0.1);
    border-bottom:1px solid var(--border-color);
}
.header .back-btn { 
    position:absolute; 
    left:20px; 
    font-size:28px; 
    color:#000; 
    cursor:pointer; 
    transition:0.3s; 
}
.header .back-btn:hover { transform:scale(1.2); }
.header .header-title { font-size:1.5rem; font-weight:700; color:#000; }

/* REFERRAL BOX */
.referral-box {
    display:flex;
    justify-content:space-between;
    align-items:center;
    background:#fff;
    padding:16px 18px;
    border-radius:14px;
    margin:15px 0 20px;
    border:1px solid var(--border-color);
    box-shadow:0 6px 15px rgba(0,0,0,0.05);
    transition:0.3s;
}
.referral-box:hover { transform:translateY(-3px); box-shadow:var(--hover-shadow); }
.referral-text { font-size:14px; color:#444; flex:1; margin-right:10px; word-break:break-all; }
.copy-btn {
    background: var(--primary-color);
    color:#000;
    border:none;
    padding:10px 16px;
    border-radius:10px;
    font-weight:600;
    font-size:14px;
    cursor:pointer;
    transition:0.3s;
}
.copy-btn:hover { transform:scale(1.05); box-shadow:var(--hover-shadow); }

/* CONTENT WRAPPER */
.content-wrapper { padding:22px 15px 120px; }

/* STAT BOX */
.stats-box {
    background:#fff;
    border-radius:18px;
    padding:24px;
    text-align:center;
    margin-bottom:16px;
    border:1px solid var(--border-color);
    box-shadow:0 5px 15px rgba(0,0,0,0.05);
}
.stats-box .stat-label { font-size:14px; color:var(--subtext-color); }
.stats-box .stat-value { font-size:26px; font-weight:700; color:#000; }
.stats-box .sub-stats { 
    display:flex; 
    justify-content:space-around; 
    border-top:1px solid var(--border-color); 
    margin-top:12px; padding-top:12px; 
}

/* LEVEL BOX */
.level-deposit-box {
    background:#fff;
    border-radius:14px;
    text-align:center;
    padding:16px;
    margin-bottom:18px;
    border:1px solid var(--border-color);
    box-shadow:0 5px 12px rgba(0,0,0,0.05);
    transition:0.3s;
}
.level-deposit-box:hover { transform:translateY(-2px); box-shadow:var(--hover-shadow); }
.level-deposit-box h3 { color:#000; font-size:16px; margin-bottom:6px; font-weight:600; }
.level-deposit-box p { font-size:18px; font-weight:700; color:var(--primary-color); }

/* TABS */
.team-tabs {
    display:flex;
    background:#f8f8f8;
    border-radius:12px;
    padding:6px;
    margin-bottom:20px;
    border:1px solid var(--border-color);
}
.tab-btn {
    flex:1;
    padding:12px;
    text-align:center;
    border:none;
    border-radius:10px;
    background:transparent;
    color:#777;
    font-weight:600;
    cursor:pointer;
    transition:0.3s;
}
.tab-btn.active { 
    background: var(--primary-color); 
    color:#000; 
    box-shadow:var(--hover-shadow); 
}
.tab-content { display:none; }
.tab-content.active { display:block; }

/* USER CARDS */
.user-list { display:flex; flex-direction:column; gap:14px; }
.user-card {
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:16px;
    border-radius:14px;
    background:#fff;
    border:1px solid var(--border-color);
    box-shadow:0 5px 15px rgba(0,0,0,0.05);
    transition:0.3s;
}
.user-card:hover { transform:translateY(-3px); box-shadow:var(--hover-shadow); }
.user-info .user-id { font-weight:700; font-size:16px; color:#000; }
.user-info .join-date, .user-info .team-deposit { font-size:13px; color:#777; }
.user-status { font-size:14px; font-weight:700; color:#000; }

/* NO RECORD */
.no-record {
    text-align:center;
    padding:40px 20px;
    background:#fff;
    border-radius:14px;
    color:#777;
    border:1px solid var(--border-color);
}

/* BOTTOM NAV */
.bottom-nav {
    position:fixed;
    bottom:0;
    left:50%;
    transform:translateX(-50%);
    width:100%;
    max-width:600px;
    background:#fff;
    display:flex;
    justify-content:space-around;
    padding:12px 0;
    box-shadow:0 -3px 15px rgba(0,0,0,0.1);
    z-index:1000;
    border-top:1px solid var(--border-color);
    border-radius:16px 16px 0 0;
}
.nav-item { display:flex; flex-direction:column; align-items:center; color:#000; cursor:pointer; transition:0.3s; }
.nav-item.active .nav-label { color:#000; font-weight:700; }
.nav-item img { width:28px; height:28px; margin-bottom:4px; filter:brightness(0); transition:0.3s; }
.nav-item:hover img { transform:scale(1.2); }
.nav-label { font-size:12px; font-weight:600; }
</style>

</head>
<body>
<div class="main-container">

    <!-- HEADER -->
    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Good World Time Investment</h1>
    </div>

    <!-- CONTENT -->
    <div class="content-wrapper">
        <!-- STATISTIK TEAM -->
        <div class="stats-box">
            <div class="main-stat">
                <div class="stat-label">Deposit Tim</div>
                <div class="stat-value"><?php echo e(price($totalDeposit1 + $totalDeposit2 + $totalDeposit3)); ?></div>
            </div>
            <div class="sub-stats">
                <div class="stat-item">
                    <div class="stat-label">Total Asset</div>
                    <div class="stat-value"><?php echo e(price($totalCommission1 + $totalCommission2 + $totalCommission3)); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-label">Total Anggota Tim:</div>
                    <div class="stat-value"><?php echo e($team_size ?? 0); ?></div>
                </div>
            </div>
        </div>

        <!-- REFERRAL BOX -->
        <div class="referral-box">
            <div class="referral-text" id="referralLink"><?php echo e(url('register') . '?inviteCode=' . auth()->user()->ref_id); ?></div>
            <button class="copy-btn" onclick="copyReferral()">Salin <i class="fa fa-copy"></i></button>
        </div>

        <!-- TABS -->
        <div class="team-tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'level-1')">1-level 10%</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-2')">2-level  2%</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-3')">3-level  1%</button>
        </div>

        <!-- LEVEL 1 -->
        <div id="level-1" class="tab-content active">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 1</h3>
                <p><?php echo e(price($totalDeposit1)); ?></p>
            </div>
            <?php if($first_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 2 -->
        <div id="level-2" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 2</h3>
                <p><?php echo e(price($totalDeposit2)); ?></p>
            </div>
            <?php if($second_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 3 -->
        <div id="level-3" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 3</h3>
                <p><?php echo e(price($totalDeposit3)); ?></p>
            </div>
            <?php if($third_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit Tim: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                        <div class="user-status"><?php echo e($user->is_active ? 'Aktif' : 'Aktif'); ?></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>
    </div>

   <!-- BOTTOM NAV -->
<div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
        <div class="nav-icon">🏠</div>
        <div class="nav-label">Home</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my/vip'">
        <div class="nav-icon">📦</div>
        <div class="nav-label">Investasi</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my-team'">
        <div class="nav-icon">👥</div>
        <div class="nav-label">Team</div>
    </div>

    <div class="nav-item active" onclick="window.location.href='/mine'">
        <div class="nav-icon">👤</div>
        <div class="nav-label">Profil</div>
    </div>
</div>

</div>

<script>
function switchTab(event, tabId) {
    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.getElementById(tabId).classList.add('active');
    event.currentTarget.classList.add('active');
}

function copyReferral() {
    const text = document.getElementById("referralLink").innerText;
    navigator.clipboard.writeText(text).then(() => {
        const btn = document.querySelector(".copy-btn");
        btn.innerHTML = "Disalin ✔";
        btn.style.background = "#20ff88";
        setTimeout(() => {
            btn.innerHTML = 'Salin <i class="fa fa-copy"></i>';
            btn.style.background = "var(--accent-color)";
        }, 2000);
    });
}
</script>
</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>