<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Profil Saya</title>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-color: #007bff;
    --accent-color: #00e0ff;
    --bg-gradient: linear-gradient(135deg, #0a0f2c, #001a3d, #002f5a);
    --card-bg: rgba(255,255,255,0.07);
    --text-color: #ffffff;
    --subtext-color: #a9c4ff;
}

* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    font-family: 'Poppins', sans-serif;
    background: var(--bg-gradient);
    color: var(--text-color);
    min-height: 100vh;
    overflow-x: hidden;
}

.main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    position: relative;
    padding-bottom: 100px;
}

/* HEADER */
.header {
    background: linear-gradient(135deg, #002b5b, #004aad);
    padding: 18px 15px;
    text-align: center;
    position: relative;
    box-shadow: 0 4px 15px rgba(0,0,0,0.4);
    border-bottom: 1px solid rgba(255,255,255,0.1);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    top: 16px;
    font-size: 26px;
    color: var(--accent-color);
    cursor: pointer;
    font-weight: bold;
    transition: transform 0.3s ease;
}
.header .back-btn:hover { transform: scale(1.2); }
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: #fff;
}

/* CONTENT */
.content-wrapper {
    padding: 20px 15px 100px;
}

/* USER INFO */
.user-info-bar {
    display: flex;
    align-items: center;
    margin-bottom: 25px;
}
.user-info-bar .logo {
    width: 55px;
    height: 55px;
    border-radius: 10px;
    margin-right: 15px;
    border: 2px solid rgba(255,255,255,0.3);
    box-shadow: 0 0 8px rgba(0,234,255,0.3);
    object-fit: cover;
}
.user-info-bar .user-id {
    font-size: 15px;
    font-weight: 600;
    color: #fff;
    line-height: 1.3;
}

/* BALANCE CARD */
.balance-card {
    background: linear-gradient(145deg, rgba(0, 224, 255, 0.08), rgba(0, 180, 255, 0.05));
    border-radius: 18px;
    padding: 16px 20px;
    color: #fff;
    border: 1px solid rgba(255,255,255,0.1);
    box-shadow: 0 6px 20px rgba(0,0,0,0.25);
    margin-bottom: 22px;
    text-align: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    animation: fadeIn 0.8s ease-in-out;
}
.balance-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 0 25px rgba(0,224,255,0.3);
}
.balance-card .balance-header {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 8px;
}
.balance-card .balance-label {
    font-size: 15px;
    color: var(--subtext-color);
    font-weight: 600;
}
.balance-card .balance-icon {
    width: 24px;
    height: 24px;
    filter: drop-shadow(0 0 8px rgba(0,224,255,0.5)) brightness(1.8);
}
.balance-card .balance-amount {
    font-size: 26px;
    font-weight: 700;
    color: var(--accent-color);
    margin: 10px 0;
    animation: pulse 2s infinite;
}
.balance-card .sub-stats {
    display: flex;
    justify-content: space-between;
    font-size: 13px;
    color: var(--subtext-color);
}

/* Animations */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}
@keyframes pulse {
  0%, 100% { text-shadow: 0 0 5px #00e0ff; }
  50% { text-shadow: 0 0 15px #00e0ff; }
}

/* ACTION BUTTONS */
.action-buttons {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    margin-bottom: 25px;
}
.action-btn {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.1);
    border-radius: 14px;
    width: 50%;
    padding: 12px 5px;
    text-align: center;
    color: #fff;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
}
.action-btn:hover {
    background: rgba(255,255,255,0.15);
    transform: translateY(-3px);
    box-shadow: 0 0 20px rgba(0,224,255,0.3);
}
.action-btn img {
    width: 32px;
    height: 32px;
    margin-bottom: 6px;
    filter: drop-shadow(0 0 6px rgba(0,224,255,0.6)) brightness(2);
}

/* SERVICE MENU */
.service-menu .menu-title {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 12px;
    color: #fff;
}
.service-menu .menu-list {
    background: rgba(255,255,255,0.05);
    border-radius: 16px;
    padding: 10px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
    border: 1px solid rgba(255,255,255,0.05);
}
.menu-item {
    display: flex;
    align-items: center;
    padding: 12px;
    border-radius: 12px;
    transition: all 0.3s ease;
    margin-bottom: 8px;
    background: rgba(255,255,255,0.03);
}
.menu-item:hover {
    background: rgba(255,255,255,0.08);
    transform: translateY(-2px);
    box-shadow: 0 0 12px rgba(0,224,255,0.3);
}
.menu-item .menu-icon {
    width: 26px;
    height: 26px;
    margin-right: 12px;
    filter: drop-shadow(0 0 6px rgba(0,224,255,0.6)) brightness(2);
}
.menu-item .menu-text {
    flex-grow: 1;
    font-size: 14px;
    font-weight: 500;
    color: #fff;
}
.menu-item .menu-arrow {
    color: var(--subtext-color);
    font-size: 12px;
}

/* NAVBAR BAWAH */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, #002b5b, #004aad);
    display: flex;
    justify-content: space-around;
    padding: 8px 0;
    box-shadow: 0 -2px 15px rgba(0,0,0,0.4);
    z-index: 1000;
    border-top: 1px solid rgba(255,255,255,0.15);
}
.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: var(--subtext-color);
    text-decoration: none;
    transition: all 0.3s ease;
}
.nav-item.active .nav-label {
    color: var(--accent-color);
    font-weight: 600;
}
.nav-item img {
    width: 25px;
    height: 25px;
    margin-bottom: 3px;
    filter: brightness(2);
    transition: filter 0.3s ease, transform 0.3s ease;
}
.nav-item:hover img {
    transform: scale(1.1);
}
.nav-item.active img {
    filter: drop-shadow(0 0 10px var(--accent-color)) brightness(2.5);
}
.nav-label {
    font-size: 11px;
}
</style>
</head>
<body>

<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Halaman Saya</h1>
    </div>

    <div class="content-wrapper">
        <div class="user-info-bar">
            <img src="<?php echo e(setting('logo')); ?>" alt="Logo" class="logo">
            <div class="user-id">Nomor Telepon : <?php echo e(auth()->user()->phone); ?></div>
        </div>

        <div class="balance-card">
            <div class="balance-header">
                <div class="balance-label">Saldo Akun</div>
                <img src="https://api.iconify.design/solar:wallet-linear.svg?color=%2300e0ff" class="balance-icon" alt="Saldo">
            </div>
            <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
            <div class="sub-stats"> 
                <span>Penarikan: <?php echo e(price($approvedWithdraw ?? 0)); ?></span>
                <span>Deposit: <?php echo e(price($approvedDeposit ?? 0)); ?></span>
            </div>
        </div>

        <div class="action-buttons">
            <div class="action-btn" onclick="window.location.href='/user/recharge'">
                <img src="https://api.iconify.design/solar:wallet-bold.svg?color=%2300e0ff" alt="Isi Ulang">
                <div>Isi Ulang</div>
            </div>
            <div class="action-btn" onclick="window.location.href='/withdraw'">
                <img src="https://api.iconify.design/solar:money-bag-bold.svg?color=%2300e0ff" alt="Penarikan">
                <div>Penarikan</div>
            </div>
        </div>

        <!-- LAYANAN SAYA -->
        <div class="service-menu">
            <div class="menu-title">Layanan Saya</div>
            <div class="menu-list">
                <a href="/history" class="menu-item">
                    <img src="https://api.iconify.design/mdi:clipboard-text-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Catatan Akun</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/my/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:crown-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Produk Saya</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/invite" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-multiple-plus-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Undang & Informasi Tim</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-tie-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Gaji Agen</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/add/card" class="menu-item">
                    <img src="https://api.iconify.design/mdi:credit-card-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Kartu Bank & Kata Sandi</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/about-us" class="menu-item">
                    <img src="https://api.iconify.design/mdi:office-building-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Profil Perusahaan</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <!-- MENU DOWNLOAD APK -->
                <a href="/download-apk" class="menu-item">
                    <img src="https://api.iconify.design/mdi:download-circle-outline.svg?color=%2300e0ff" class="menu-icon">
                    <span class="menu-text">Download Aplikasi</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/logout" class="menu-item">
                    <img src="https://api.iconify.design/mdi:logout-variant.svg?color=%23ff5c5c" class="menu-icon">
                    <span class="menu-text" style="color:#ff5c5c;">Keluar Aman</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- NAVBAR BAWAH -->
    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my/vip'">
            <img src="https://api.iconify.design/solar:chart-bold.svg?color=white">
            <div class="nav-label">Investasi</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white">
            <div class="nav-label">Profil</div>
        </div>
    </div>

</div>
</body>
</html>
<?php /**PATH /home/runnlvbg/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>