<!DOCTYPE html>   
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Penarikan</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-green: #27ae60;
      --dark-green: #1b5e20;
      --soft-green: #a8e6cf;
      --white: #ffffff;
      --gray-text: #2f4f4f;
      --light-gray: #f2f7f3;
      --border: #dcefe3;
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }

    html, body {
      background: linear-gradient(135deg, #eaf8ef, #d7f3e1);
      overflow-x: hidden;
      width: 100%;
      color: var(--gray-text);
      font-family: 'Poppins', sans-serif;
    }

    a { text-decoration: none; color: inherit; }

    .main-container {
      width: 100%;
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: var(--white);
      border-radius: 20px;
      box-shadow: 0 4px 20px rgba(39,174,96,0.15);
      overflow: hidden;
      padding-bottom: 50px;
    }

    /* HEADER */
    .header {
      background: linear-gradient(135deg, #1b5e20, #27ae60);
      padding: 15px 20px;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      box-shadow: 0 2px 10px rgba(0,0,0,0.15);
      color: #fff;
    }

    .header .back-btn {
      position: absolute;
      left: 20px;
      font-size: 28px;
      color: #fff;
      cursor: pointer;
      font-weight: bold;
    }

    .header .header-title {
      font-size: 1.2rem;
      font-weight: 600;
    }

    /* CONTENT */
    .content-wrapper {
      padding: 20px 15px 80px;
    }

    /* CARD STYLE */
    .card {
      background: var(--light-gray);
      border-radius: 16px;
      padding: 20px;
      box-shadow: 0 3px 12px rgba(39,174,96,0.1);
      margin-bottom: 20px;
      border: 1px solid var(--border);
    }

    /* Balance Card */
    .balance-card { text-align: center; }
    .balance-label {
      font-size: 14px;
      color: #666;
      margin-bottom: 5px;
    }
    .balance-amount {
      font-size: 32px;
      font-weight: 700;
      color: var(--primary-green);
      text-shadow: 0 0 8px rgba(39,174,96,0.2);
    }

    /* Bank Card */
    .bank-card-display .card-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
    }

    .bank-card-display .card-title {
      font-size: 16px;
      font-weight: 600;
      color: var(--dark-green);
    }

    .bank-card-display .edit-btn {
      background: var(--white);
      color: var(--primary-green);
      border: 1px solid var(--primary-green);
      padding: 5px 12px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 13px;
      cursor: pointer;
      transition: 0.3s;
    }

    .bank-card-display .edit-btn:hover {
      background: var(--primary-green);
      color: #fff;
    }

    .bank-info .info-row {
      display: flex;
      justify-content: space-between;
      padding: 8px 0;
      border-bottom: 1px solid var(--border);
    }

    .info-row .label { color: #666; }
    .info-row .value { font-weight: 500; color: var(--dark-green); }

    /* FORM */
    .form-label {
      display: block;
      font-size: 14px;
      font-weight: 600;
      margin-bottom: 8px;
      color: var(--dark-green);
    }

    .form-control {
      width: 100%;
      height: 48px;
      padding: 0 15px;
      border-radius: 10px;
      border: 1px solid var(--border);
      background-color: #fff;
      color: var(--gray-text);
      font-size: 16px;
      font-weight: 500;
      transition: 0.3s;
    }

    .form-control:focus {
      outline: none;
      border-color: var(--primary-green);
      box-shadow: 0 0 6px rgba(39,174,96,0.3);
    }

    /* BUTTON */
    .submit-btn {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, #27ae60, #1b5e20);
      color: #fff;
      border: none;
      border-radius: 12px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-top: 15px;
      box-shadow: 0 4px 15px rgba(27,94,32,0.3);
      transition: transform 0.2s, opacity 0.3s;
    }

    .submit-btn:hover {
      transform: translateY(-2px);
      opacity: 0.9;
    }

    /* PILIHAN NOMINAL */
    .amount-options {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 10px;
      margin-top: 15px;
    }

    .amount-btn {
      padding: 12px 10px;
      background: #fff;
      border: 1px solid var(--border);
      border-radius: 10px;
      color: var(--dark-green);
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      font-size: 15px;
    }

    .amount-btn:hover,
    .amount-btn.active {
      background: linear-gradient(135deg, #27ae60, #1b5e20);
      color: #fff;
      box-shadow: 0 0 10px rgba(39,174,96,0.4);
      transform: translateY(-2px);
    }

    /* Info Section */
    .info-section {
      font-size: 13px;
      color: #444;
      line-height: 1.7;
    }

    .info-section strong { color: var(--dark-green); }

    .info-section .highlight {
      background: rgba(39,174,96,0.1);
      border-left: 4px solid var(--primary-green);
      padding: 8px 12px;
      border-radius: 8px;
      margin: 10px 0;
      color: var(--dark-green);
    }
  </style>
</head>
<body>
<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">Penarikan</h1>
  </div>

  <div class="content-wrapper">

    <div class="card balance-card">
      <div class="balance-label">Saldo Tersedia</div>
      <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>

    <?php if(auth()->user()->gateway_number && auth()->user()->gateway_method): ?>
      <?php
        $method = \App\Models\PaymentMethod::where('id', auth()->user()->gateway_method)->first();
      ?>

      <div class="card bank-card-display">
        <div class="card-header">
          <span class="card-title">Penarikan ke Rekening Bank</span>
          <button class="edit-btn" onclick="window.location.href='/add/card'">
            <i class="fas fa-edit"></i> Ubah
          </button>
        </div>
        <div class="bank-info">
          <div class="info-row">
            <span class="label">Nama Bank:</span>
            <span class="value"><?php echo e($method->name ?? 'N/A'); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nama Pemilik Rekening:</span>
            <span class="value"><?php echo e(auth()->user()->holder_name); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nomor Rekening:</span>
            <span class="value"><?php echo e(auth()->user()->gateway_number); ?></span>
          </div>
        </div>
      </div>

      <div class="card withdraw-form">
        <form action="<?php echo e(route('user.withdraw-confirm-submit')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <div class="form-group">
            <label class="form-label" for="withdrawAmount">Jumlah Penarikan</label>
            <input id="withdrawAmount" type="number" class="form-control" name="amount"
                   placeholder="Pilih nominal di bawah" readonly required>

            <div class="amount-options">
              <button type="button" class="amount-btn" data-amount="30000">Rp 30.000</button>
              <button type="button" class="amount-btn" data-amount="80000">Rp 80.000</button>
              <button type="button" class="amount-btn" data-amount="250000">Rp 250.000</button>
              <button type="button" class="amount-btn" data-amount="750000">Rp 750.000</button>
              <button type="button" class="amount-btn" data-amount="1500000">Rp 1.500.000</button>
              <button type="button" class="amount-btn" data-amount="3000000">Rp 3.000.000</button>
              <button type="button" class="amount-btn" data-amount="5000000">Rp 5.000.000</button>
              <button type="button" class="amount-btn" data-amount="10000000">Rp 10.000.000</button>
            </div>
          </div>

          <button type="submit" class="submit-btn">
            Konfirmasi Penarikan
          </button>
        </form>
      </div>

    <?php else: ?>
      <div class="card">
        <p>Anda belum menambahkan kartu bank. Silakan tambahkan kartu bank terlebih dahulu untuk melakukan penarikan.</p>
        <a href="/add/card" class="submit-btn" style="text-align: center; margin-top: 20px;">Tambah Kartu Bank</a>
      </div>
    <?php endif; ?>

    <div class="card info-section">
      <h4 style="margin-bottom: 10px;">💡 Informasi Penting Penarikan</h4>
      <div class="highlight">
        Pastikan data rekening Anda sudah benar agar dana dapat diterima tanpa kendala.
      </div>
      <p>1. Minimal penarikan: <strong>Rp 30.000</strong></p>
      <p>2. Maksimal penarikan: <strong>Rp 10.000.000</strong></p>
      <p>3. Biaya administrasi penarikan: <strong>10%</strong></p>
      <p>4. Waktu layanan penarikan: <strong>10:00 Pagi – 18:00 WIB Malam</strong></p>
      <p>5. Estimasi waktu proses: <strong>1–24 Jam (maksimal 24 jam)</strong></p>
      <div class="highlight">
        Tips: Lakukan penarikan di jam aktif agar dana lebih cepat diproses.
      </div>
    </div>
  </div>

</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
<script>
document.querySelectorAll('.amount-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    document.querySelectorAll('.amount-btn').forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
    document.getElementById('withdrawAmount').value = btn.dataset.amount;
  });
});
</script>
</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>