<!DOCTYPE html>   
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>Home</title>

<style>
:root {
    --primary-green: #66cc88; /* hijau muda nyaman */
    --dark-bg: #f5f5f5; /* putih lembut */
    --text-dark: #1a1a1a;
    --text-light: #555;
}

/* Reset */
* { margin:0; padding:0; box-sizing:border-box; }
body {
    font-family: 'Poppins', sans-serif;
    background: var(--dark-bg);
    color: var(--text-dark);
}

/* Container */
.main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    background: rgba(255,255,255,0.8);
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(102,204,136,0.3);
    padding-bottom: 80px;
}

/* Header */
.header {
    background: var(--primary-green);
    color: #fff;
    padding: 15px 20px;
    text-align: center;
    font-weight: 600;
    font-size: 1.2rem;
    position: relative;
    border-radius: 15px 15px 0 0;
}
.back-btn {
    position: absolute;
    left: 20px;
    font-size: 28px;
    cursor: pointer;
    color: #fff;
}

/* Slider */
.slider-container { overflow:hidden; position:relative; }
.slider { display:flex; transition: transform 0.5s ease; }
.slide { min-width:100%; }
.slide img { width:100%; height:200px; object-fit:cover; border-radius: 0 0 15px 15px; }

/* Dots */
.dots { display:flex; justify-content:center; margin-top:5px; }
.dot { width:10px; height:10px; margin:0 4px; background:#cceedd; border-radius:50%; cursor:pointer; }
.dot.active { background: var(--primary-green); }

/* Action Buttons */
.action-buttons {
    display:flex; justify-content:space-between; padding:10px;
    gap:5px;
}
.action-btn {
    flex:1; text-align:center; cursor:pointer; padding:5px;
}
.action-btn img { width:40px; height:40px; margin-bottom:3px; }
.action-btn div { font-size:12px; color:var(--text-dark); }

/* Tabs */
.tabs { display:flex; margin:10px; background: #e0f0e8; border-radius:12px; }
.tab { flex:1; padding:10px; text-align:center; cursor:pointer; border-radius:12px; font-weight:600; color:var(--text-light); }
.tab.active { background: var(--primary-green); color: #fff; }

/* Plan Cards */
.content-wrapper { padding:0 15px 90px; }
.plan-list { display:flex; flex-direction:column; gap:10px; }
.plan-card { background:#fff; border-radius:12px; padding:15px; box-shadow:0 2px 10px rgba(0,0,0,0.1); }
.plan-title { font-weight:600; color:var(--primary-green); margin-bottom:10px; }
.plan-body { display:flex; gap:10px; align-items:center; }
.plan-image-container { width:80px; height:80px; overflow:hidden; border-radius:12px; }
.plan-image { width:100%; height:100%; object-fit:cover; }
.plan-details { flex:1; font-size:0.9rem; color:var(--text-dark); }
.detail-item { display:flex; justify-content:space-between; margin-bottom:3px; }
.detail-item .value { color:var(--primary-green); font-weight:600; }
.buy-btn { width:100%; padding:10px; margin-top:8px; background:var(--primary-green); color:#fff; border:none; border-radius:50px; font-weight:600; cursor:pointer; }

/* Bottom Navbar */
.bottom-nav {
    position:fixed; bottom:0; left:50%; transform:translateX(-50%);
    width:100%; max-width:600px;
    background:#fff; display:flex; justify-content:space-around;
    padding:10px 0; border-top:1px solid #ccc;
}
.nav-item { display:flex; flex-direction:column; align-items:center; color:var(--text-dark); font-size:12px; cursor:pointer; }
.nav-item.active { color: var(--primary-green); font-weight:600; }
.nav-item img { width:24px; height:24px; margin-bottom:2px; }

/* Floating WhatsApp Icon */
.draggable-icon {
    position:fixed; bottom:80px; right:15px; width:60px; height:60px; border-radius:50%;
    background: var(--primary-green); display:flex; justify-content:center; align-items:center;
}
.draggable-icon img { width:70%; height:70%; }

/* POPUP WHATSAPP */
.popup-whatsapp {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0, 0, 0, 0.85);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999999;
  animation: fadeInPopup 0.4s ease-in-out;
}
@keyframes fadeInPopup {
  from { opacity: 0; transform: scale(0.95); }
  to { opacity: 1; transform: scale(1); }
}

.popup-box {
  background: linear-gradient(135deg, #021526, #004aad);
  border: 2px solid rgba(0, 234, 255, 0.4);
  border-radius: 20px;
  box-shadow: 0 0 30px rgba(0, 234, 255, 0.5);
  text-align: center;
  padding: 30px 25px;
  width: 90%;
  max-width: 330px;
  animation: slideUp 0.5s ease forwards;
  position: relative;
}
@keyframes slideUp {
  from { transform: translateY(40px); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}
.popup-box img {
  width: 80px;
  height: 80px;
  filter: drop-shadow(0 0 20px rgba(0, 255, 150, 0.8));
  animation: pulseGlow 2.5s infinite ease-in-out;
  margin-bottom: 15px;
}
@keyframes pulseGlow {
  0%, 100% {
    transform: scale(1);
    filter: drop-shadow(0 0 15px rgba(0, 255, 150, 0.7))
            drop-shadow(0 0 25px rgba(0, 255, 200, 0.4));
  }
  50% {
    transform: scale(1.08);
    filter: drop-shadow(0 0 30px rgba(0, 255, 180, 0.9))
            drop-shadow(0 0 40px rgba(0, 255, 255, 0.7));
  }
}
.popup-box {
  background: #ffffff; /* Putih lembut */
  border-radius: 20px;
  text-align: center;
  padding: 30px 25px;
  width: 90%;
  max-width: 330px;
  box-shadow: 0 0 30px rgba(102, 204, 136, 0.5); /* shadow hijau lembut */
}

.popup-box h3 {
  color: #66cc88; /* hijau sesuai tema */
  font-weight: 700;
  margin-bottom: 8px;
  text-shadow: 0 0 8px rgba(102, 204, 136, 0.5);
}

.popup-box p {
  color: #1a1a1a; /* teks gelap agar mudah dibaca */
  font-size: 14px;
  margin-bottom: 15px;
  line-height: 1.5;
}

.popup-box button {
  background: #66cc88; /* hijau tombol */
  color: white; /* tulisan putih */
  border: none;
  border-radius: 50px;
  padding: 10px 25px;
  font-weight: 600;
  box-shadow: 0 0 15px rgba(102, 204, 136, 0.5);
  cursor: pointer;
  transition: 0.3s ease;
}

.popup-box button:hover {
  transform: scale(1.05);
  box-shadow: 0 0 25px rgba(102, 204, 136, 0.8);
}

</style>
</head>

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="goBack()">←</span>
    MNC TRADE SYARIAH
    </div>

    <!-- Slider -->
    <div class="slider-container" id="main-slider-container">
        <div class="slider" id="main-slider">
            <?php $__currentLoopData = \App\Models\VipSlider::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="slide"><img src="<?php echo e(asset($slider->photo)); ?>" alt="Slider Image"></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="dots" id="slider-dots-container"></div>
    </div>

    <!-- Action Buttons -->
    <div class="action-buttons"> 
      <div class="action-btn" onclick="openPage('user/recharge')">
        <img src="https://api.iconify.design/solar:card-send-bold-duotone.svg?color=%2366cc88" alt="Isi Ulang">
        <div>Isi Ulang</div>
      </div>
      <div class="action-btn" onclick="openPage('/withdraw')">
        <img src="https://api.iconify.design/solar:wallet-money-bold-duotone.svg?color=%2366cc88" alt="Withdraw">
        <div>Withdraw</div>
      </div>
      <div class="action-btn" onclick="openPage('/promo')">
        <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%2366cc88" alt="Hadiah">
        <div>Hadiah</div>
      </div>
      <div class="action-btn" onclick="openPage('/my/vip')"> 
        <img src="https://api.iconify.design/solar:chart-square-bold-duotone.svg?color=%2366cc88" alt="Investasi Saya">
        <div>Investasi</div>
      </div>
      <div class="action-btn" onclick="openPage('WA')">
        <img src="https://api.iconify.design/solar:headphones-round-sound-bold-duotone.svg?color=%2366cc88" alt="Group">
        <div>Group</div>
      </div>
    </div>

    <!-- Tabs -->
    <div class="tabs">
        <button class="tab active" onclick="switchTab(event, 'daily-income')">VIP</button>
        <button class="tab" onclick="switchTab(event, 'welfare-plan')">Plus</button>
    </div>

    <?php
        use \App\Models\PackageCategory;
        use \App\Models\Package;
        $packageOne = Package::where('Status','!=','inactive')->where('tab','vip')->get();
        $packagetwo = Package::where('Status','!=','inactive')->where('tab','fixed')->get();
        $packagethree = Package::where('Status','!=','inactive')->where('tab','event')->get();
    ?>

    <div class="content-wrapper">
        <div id="daily-income" class="plan-list">
            <?php if($packageOne->count() > 0): ?>
                <?php $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $myVip = \App\Models\Purchase::where('user_id',auth()->id())->where('package_id',$element->id)->where('status','active')->first(); ?>
                    <div class="plan-card">
                        <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                        <div class="plan-body">
                            <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" class="plan-image"></div>
                            <div class="plan-details">
                                <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                                <div class="detail-item"><span class="label">Pendapatan Perhari:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                                <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element->validity); ?> Hari</span></div>
                                <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element->daily_limit * $element->validity)); ?></span></div>
                            </div>
                        </div>
                        <?php if($myVip): ?>
                            <button class="buy-btn" disabled>Aktif</button>
                        <?php elseif($element->status == 'coming'): ?>
                            <button class="buy-btn" disabled>Coming</button>
                        <?php else: ?>
                            <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element->id); ?>')">Beli Sekarang</button>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <p style="text-align:center;padding:20px;">No daily income plans available.</p>
            <?php endif; ?>
        </div>

        <div id="welfare-plan" class="plan-list" style="display:none;">
            <?php $__currentLoopData = array_merge($packagetwo->toArray(), $packagethree->toArray()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element['name']); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element['photo'])); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span class="label">Harga :</span><span class="value"><?php echo e(price($element['price'])); ?></span></div>
                            <div class="detail-item"><span class="label">Pendapatan Perhari :</span><span class="value"><?php echo e(price($element['daily_limit'])); ?></span></div>
                            <div class="detail-item"><span class="label">Siklus :</span><span class="value"><?php echo e($element['validity']); ?> days</span></div>
                            <div class="detail-item"><span class="label">Total Pendapatan :</span><span class="value"><?php echo e(price($element['daily_limit'] * $element['validity'])); ?></span></div>
                        </div>
                        <button class="buy-btn" onclick="openPage('/purchase/confirmation/<?php echo e($element['id']); ?>')">Beli Sekarang</button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

</div> <!-- Tutup main-container -->

<!-- Bottom Navbar -->
<div class="bottom-nav">
  <div class="nav-item" onclick="window.location.href='/'">
    <img src="https://api.iconify.design/solar:home-2-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Home</div>
  </div>
  <div class="nav-item" onclick="window.location.href='/my/vip'">
    <img src="https://api.iconify.design/solar:chart-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Investasi</div>
  </div>
  <div class="nav-item" onclick="window.location.href='/my-team'">
    <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Team</div>
  </div>
  <div class="nav-item active" onclick="window.location.href='/mine'">
    <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=%2366cc88" class="nav-icon">
    <div class="nav-label">Profil</div>
  </div>
</div>

<script>
function openPage(url){window.location.href=url;}
function goBack(){history.back();}

// Slider
document.addEventListener('DOMContentLoaded',()=>{
    const slider=document.getElementById('main-slider');
    const dotsContainer=document.getElementById('slider-dots-container');
    const slides=Array.from(slider.children);
    let dots=[];
    slides.forEach((_,i)=>{
        const dot=document.createElement('div');
        dot.classList.add('dot');
        dot.addEventListener('click',()=>goToSlide(i));
        dotsContainer.appendChild(dot);
        dots.push(dot);
    });
    let current=0;
    const goToSlide=(i)=>{
        current=i;
        slider.style.transform=`translateX(-${i*100}%)`;
        dots.forEach((d,idx)=>d.classList.toggle('active',idx===current));
    };
    goToSlide(0);
    if(slides.length>1)setInterval(()=>goToSlide((current+1)%slides.length),3000);
});

// Tabs
function switchTab(evt,id){
    document.querySelectorAll('.plan-list').forEach(p=>p.style.display='none');
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(id).style.display='flex';
    evt.currentTarget.classList.add('active');
}

// Popup WhatsApp
function showWhatsAppPopup() {
  if (document.querySelector('.popup-whatsapp')) return;
  const popup = document.createElement("div");
  popup.className = "popup-whatsapp";
  popup.innerHTML = `
    <div class="popup-box" id="popupBox">
      <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
      <h3>💳 Berinvestasilah Sekarang!</h3>
      <p>
        Gunakan peluang emas dengan kartu kredit Anda.  
        Dapatkan promo eksklusif dan panduan investasi cerdas langsung di grup WhatsApp resmi kami. 🚀
      </p>
      <button id="joinNow">Gabung Sekarang</button>
    </div>
  `;
  document.body.appendChild(popup);

  document.getElementById("joinNow").addEventListener("click", () => {
    window.open("WAAAA", "_blank");
    popup.remove();
  });
  popup.addEventListener("click", (e) => {
    if (!document.getElementById("popupBox").contains(e.target)) popup.remove();
  });
  setTimeout(()=>popup.remove(),10000);
}
document.addEventListener("DOMContentLoaded",()=>{setTimeout(showWhatsAppPopup,1000);});
</script>

</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>