<?php    
    $paymentMethods = \App\Models\PaymentMethod::where('status', 1)->orderBy('id', 'desc')->get();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui, viewport-fit=cover">
<title>Isi Ulang Saldo</title>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
/* =========================
   THEME HITAM + MAROON + FOTO FULL
========================= */
:root {
  --primary-gradient: linear-gradient(135deg, #450A0A, #7F1D1D);
  --background-overlay: rgba(0, 0, 0, 0.82);
  --text-color: #F5F5F5;
  --card-bg: rgba(15, 10, 10, 0.88);
  --accent-color: #FCA5A5;
  --shadow: 0 12px 35px rgba(0,0,0,0.85);
  --hover-shadow: 0 18px 50px rgba(127,29,29,0.65);
}

/* RESET */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

/* BODY BACKGROUND FOTO FULL */
body {
  font-family: 'Poppins', sans-serif;
  color: var(--text-color);
  background:
    linear-gradient(var(--background-overlay), var(--background-overlay)),
    url("huhu.jpg") no-repeat center center fixed;
  background-size: cover;
  overflow-x: hidden;
}

/* LINK */
a {
  text-decoration: none;
  color: inherit;
}

/* MAIN CONTAINER */
.main-container {
  max-width: 600px;
  margin: 0 auto;
  min-height: 100vh;
  padding-bottom: 120px;
}

/* =========================
   HEADER
========================= */
.header {
  background: var(--primary-gradient);
  padding: 18px 15px;
  text-align: center;
  position: relative;
  border-bottom-left-radius: 25px;
  border-bottom-right-radius: 25px;
  box-shadow: var(--shadow);
  backdrop-filter: blur(10px);
}

.header .back-btn {
  position: absolute;
  left: 20px;
  top: 18px;
  font-size: 26px;
  font-weight: 700;
  cursor: pointer;
  color:#FECACA;
  transition: transform 0.3s;
}

.header .back-btn:hover {
  transform: scale(1.2);
}

.header .header-title {
  font-size: 1.5rem;
  font-weight: 700;
  color:#FFF;
}

/* =========================
   BALANCE CARD
========================= */
.balance-card {
  background: var(--primary-gradient);
  border-radius: 22px;
  padding: 25px 20px;
  text-align: center;
  box-shadow: var(--hover-shadow);
  margin-bottom: 25px;
  transition: 0.3s;
}

.balance-card:hover {
  transform: translateY(-6px);
}

.balance-amount {
  font-size: 36px;
  font-weight: 800;
  color:#FFF;
  text-shadow: 0 0 18px rgba(127,29,29,0.8);
}

.balance-label {
  font-size: 15px;
  color:#FCA5A5;
}

/* =========================
   FORM CONTAINER
========================= */
.recharge-form-container {
  background: var(--card-bg);
  border-radius: 20px;
  padding: 22px;
  backdrop-filter: blur(15px);
  box-shadow: var(--shadow);
  border:1px solid rgba(255,255,255,0.06);
}

/* LABEL */
.form-label {
  font-weight: 600;
  margin-bottom: 8px;
  display: block;
  color:#FECACA;
}

/* INPUT */
.form-control {
  width: 100%;
  height: 55px;
  border-radius: 14px;
  font-size: 18px;
  font-weight: 700;
  text-align: center;
  background: rgba(5, 5, 5, 0.9);
  border: 2px solid rgba(127,29,29,0.45);
  color: #FFF;
  transition: 0.3s;
}

.form-control:focus {
  outline: none;
  border-color: var(--accent-color);
  box-shadow: 0 0 18px rgba(127,29,29,0.7);
}

/* =========================
   PAYMENT SELECT
========================= */
.payment-select {
  width: 100%;
  height: 55px;
  border-radius: 14px;
  font-size: 18px;
  font-weight: 700;
  text-align: center;
  background: rgba(5, 5, 5, 0.9);
  border: 2px solid rgba(127,29,29,0.45);
  color: #FFF;
  appearance: none;
  transition: 0.3s;
}

.payment-select:focus {
  outline: none;
  border-color: var(--accent-color);
  box-shadow: 0 0 18px rgba(127,29,29,0.7);
}

/* =========================
   BUTTON
========================= */
.recharge-btn {
  margin-top: 30px;
  width: 100%;
  padding: 16px;
  font-size: 18px;
  font-weight: 700;
  border-radius: 14px;
  border: none;
  background: var(--primary-gradient);
  color: #FFF;
  cursor: pointer;
  box-shadow: 0 10px 30px rgba(127,29,29,0.55);
  transition: 0.3s;
}

.recharge-btn:hover {
  transform: scale(1.05);
  box-shadow: 0 15px 45px rgba(127,29,29,0.85);
}

/* =========================
   INFO SECTION
========================= */
.info-section {
  margin-top: 25px;
  background: var(--card-bg);
  border-radius: 18px;
  padding: 18px 15px;
  backdrop-filter: blur(15px);
  box-shadow: var(--shadow);
  position: relative;
}

.info-section::before {
  content: "";
  position: absolute;
  left: 0;
  top: 0;
  width: 5px;
  height: 100%;
  background: var(--accent-color);
  border-radius: 5px 0 0 5px;
}

.info-section h3 {
  font-size: 18px;
  margin-bottom: 10px;
  color: var(--accent-color);
}

.info-section ul {
  list-style: none;
}

.info-section ul li {
  margin-bottom: 8px;
  display: flex;
  align-items: center;
  color:#F5F5F5;
}

.info-section ul li i {
  margin-right: 8px;
  color: var(--accent-color);
}

</style>
</head>

<body>
<div class="main-container">
  <div class="header">
    <h1 class="header-title">Isi Ulang Saldo</h1>
  </div>

  <div class="content-wrapper">
    <div class="balance-card">
      <p class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></p>
      <span class="balance-label">Saldo Saat Ini</span>
    </div>

    <div class="recharge-form-container">
      <form method="POST" action="<?php echo e(url('topup')); ?>">
        <?php echo csrf_field(); ?>
        <label class="form-label" for="topupAmount">Masukkan Nominal</label>
        <input id="topupAmount" type="number" min="100000" class="form-control" name="amount" placeholder="Minimal Rp 100.000" required>


        <!-- PILIH METODE PEMBAYARAN -->
        <div class="payment-methods-container">
          <h5>Pilih Metode Pembayaran</h5>
          <select class="payment-select" name="payment_method_id" required>
            <option value="" disabled selected>Pilih Pembayaran</option>
            <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($method->id); ?>"><?php echo e($method->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <button type="submit" class="recharge-btn">Konfirmasi Isi Ulang</button>
      </form>
    </div>

    <div class="info-section">
      <h3><i class="fa-solid fa-circle-info"></i> Kebijakan Isi Ulang</h3>
      <ul>
        <li><i class="fa-solid fa-check-circle"></i> Minimal isi ulang adalah <b>Rp 100.000</b>.</li>
        <li><i class="fa-solid fa-lock"></i> Gunakan metode pembayaran resmi di halaman ini.</li>
        <li><i class="fa-solid fa-shield"></i> Dana Anda aman, transaksi terenkripsi.</li>
        <li><i class="fa-solid fa-headset"></i> Jika saldo belum masuk, hubungi layanan pelanggan 24 jam.</li>
      </ul>
    </div>
  </div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<script>
function setAmount(amount){
  $('#topupAmount').val(amount);
  $('.amount-btn').removeClass('active');
  $('.amount-btn[data-amount="'+amount+'"]').addClass('active');
}
</script>
</body>
</html>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/main/recharge/index.blade.php ENDPATH**/ ?>