<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Task Request Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User Info</th>
                                        <th>Team Invest</th>
                                        <th>Bonus</th>
                                        <th>Team size</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $user = \App\Models\User::where('id', $row->user_id)->first();
                                            $task = \App\Models\Task::where('id', $row->task_id)->first();
                                        ?>
                                        <?php if($user && $task): ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td>
                                                    Ref: <?php echo e($user->ref_id); ?><br />
                                                    Phone: <?php echo e($user->phone); ?><br />
                                                    <a target="_blank" href="<?php echo e(route('admin.customer.login', $user->id)); ?>" class="btn btn-sm btn-success">Login</a>
                                                </td>
                                                <td><?php echo e(price($row->team_invest)); ?></td>
                                                <td><?php echo e(price($task->bonus)); ?></td>
                                                <td><?php echo e($row->team_size); ?></td>
                                                <td>
                                                    <?php if($row->status == 'approved'): ?>
                                                        <span class="text-success"><?php echo e($row->status); ?></span>
                                                    <?php elseif($row->status == 'rejected'): ?>
                                                        <span class="text-danger"><?php echo e($row->status); ?></span>
                                                    <?php else: ?>
                                                        <span style="color: #ee9a0b"><?php echo e($row->status); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('task.request.status', [$row->id,'approved'])); ?>" class="btn btn-success">Approved</a>
                                                    <a href="<?php echo e(route('task.request.status', [$row->id,'rejected'])); ?>" class="btn btn-danger">Rejected</a>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/runnlvbg/card5dgtal.com/resources/views/admin/pages/task_request.blade.php ENDPATH**/ ?>