<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>VIP Investment</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<style>
:root {
    --primary-color: #7F1D1D;      /* maroon utama */
    --secondary-color: #450A0A;    /* maroon gelap */
    --background-color: #000000;   /* hitam full */
    --text-color: #F5F5F5;
    --light-text-color: #FCA5A5;

    --white-color: rgba(15,15,15,0.9);
    --gray-bg: rgba(20,10,10,0.9);

    --success-color: #22c55e;
    --pending-color: #eab308;
    --failed-color: #ef4444;
}

* {
    margin:0;
    padding:0;
    box-sizing:border-box;
}

html, body {
    background: radial-gradient(circle at top, #1a1a1a 0%, #000000 70%);
    width:100%;
    overflow-x:hidden;
}

body {
    font-family:'Poppins',sans-serif;
    color:var(--text-color);
    -webkit-font-smoothing:antialiased;
}

a { text-decoration:none; color:inherit; }

/* MAIN */
.main-container { 
    width:100%;
    max-width:600px; 
    margin:0 auto;
    background:transparent;
    min-height:100vh;
    position:relative;
}

/* HEADER */
.header { 
    background:linear-gradient(135deg,var(--secondary-color),var(--primary-color));
    padding:15px 20px;
    display:flex;
    align-items:center;
    justify-content:center;
    position:relative;
    box-shadow:0 10px 30px rgba(127,29,29,.6);
}
.header .back-btn {
    position:absolute;
    left:20px;
    font-size:26px;
    color:#FFE4E6;
    cursor:pointer;
    font-weight:bold;
}
.header .header-title {
    font-size:1.2rem;
    font-weight:600;
    color:#FFFFFF;
}

/* TABS */
.tabs { 
    display:flex;
    background:var(--gray-bg);
    border-radius:14px;
    padding:5px;
    margin:20px 15px;
    backdrop-filter:blur(14px);
    box-shadow:inset 0 1px 3px rgba(0,0,0,.7);
}
.tab {
    flex:1;
    padding:10px;
    text-align:center;
    font-size:14px;
    font-weight:600;
    cursor:pointer;
    border:none;
    background:transparent;
    color:var(--light-text-color);
    transition:.3s ease;
    border-radius:12px;
}
.tab.active {
    background:linear-gradient(135deg,var(--primary-color),#991B1B);
    color:#FFFFFF;
    box-shadow:0 6px 20px rgba(127,29,29,.6);
}

/* CONTENT */
.content-wrapper {
    padding:10px 15px 120px;
}

/* ======================================
   PLAN CARD  FULL RAPIIIII VERSION
   TANPA UBAH FUNCTION
====================================== */

/* CARD UTAMA */
.plan-card{
    background:rgba(15,15,15,.95);
    border-radius:20px;
    padding:16px;
    display:flex;
    flex-direction:column;
    gap:14px;
    position:relative;
    box-shadow:0 12px 35px rgba(0,0,0,.8);
    border:1px solid rgba(255,255,255,0.05);
}

/* JUDUL */
.plan-title{
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap:10px;
    font-size:1.05rem;
    font-weight:700;
    color:#fff;
}

/* BODY GRID */
.plan-body{
    display:grid;
    grid-template-columns:90px 1fr;
    gap:14px;
    align-items:stretch;
}

/* IMAGE */
.plan-image-container{
    width:90px;
    height:90px;
    border-radius:14px;
    overflow:hidden;
    background:#050505;
    border:1px solid rgba(255,255,255,0.08);
    box-shadow:inset 0 0 10px rgba(0,0,0,.9);
}
.plan-image{
    width:100%;
    height:100%;
    object-fit:cover;
}

/* DETAIL GRID */
.plan-details{
    display:grid;
    grid-template-columns:repeat(2,1fr);
    gap:10px;
}

/* BOX DETAIL */
.detail-item{
    background:rgba(0,0,0,0.55);
    border:1px solid rgba(255,255,255,0.08);
    border-radius:12px;
    padding:8px 10px;
    display:flex;
    flex-direction:column;
    justify-content:center;
    gap:4px;
    min-height:52px;
}

/* LABEL */
.detail-item span:first-child{
    font-size:.72rem;
    font-weight:500;
    color:#FCA5A5;
    opacity:.95;
}

/* VALUE */
.detail-item .value{
    font-size:.85rem;
    font-weight:800;
    color:#FFFFFF;
    white-space:nowrap;
}

/* BUTTON */
.action-btn{
    width:100%;
    margin-top:8px;
    padding:12px;
    border-radius:14px;
    background:linear-gradient(135deg,#7F1D1D,#991B1B);
    color:#fff;
    font-size:.95rem;
    font-weight:700;
    border:none;
    cursor:pointer;
    box-shadow:0 6px 20px rgba(127,29,29,.6);
    transition:.3s ease;
}
.action-btn:hover{
    transform:translateY(-2px);
}

/* COUNTDOWN */
.action-btn.countdown{
    background:#050505;
    color:#FCA5A5;
    border:1px dashed rgba(127,29,29,.6);
    box-shadow:none;
    cursor:default;
}

/* VIP BADGE */
.vip-group{
    display:inline-flex;
    align-items:center;
    gap:6px;
    padding:6px 12px;
    border-radius:999px;
    background:linear-gradient(135deg,#991B1B,#7F1D1D);
    font-size:.75rem;
    font-weight:700;
    color:#fff;
    box-shadow:0 4px 14px rgba(127,29,29,.6);
}

/* NO DATA */
.no-record{
    text-align:center;
    padding:40px 20px;
    background:rgba(15,15,15,.9);
    border-radius:16px;
    color:#FCA5A5;
    font-size:.9rem;
    border:1px solid rgba(255,255,255,.06);
}

/* RESPONSIVE */
@media(max-width:480px){
    .plan-body{
        grid-template-columns:70px 1fr;
    }
    .plan-image-container{
        width:70px;
        height:70px;
    }
    .plan-details{
        grid-template-columns:1fr;
    }
}
dow:0 8px 25px rgba(0,0,0,.7);
}

</style>
</head>
<body>

<div class="main-container">
    <div class="header">
        <span class="back-btn" onclick="history.back()"></span>
        <h1 class="header-title">oto</h1>
    </div>

    <div class="tabs">
        <button class="tab active" onclick="switchTab(event,'daily-income')">Daftar invest anda</button>
    </div>

    <div class="content-wrapper">
        <?php
            use \App\Models\Package;
            use \App\Models\Purchase;
            use \App\Models\UserLedger;

            $userId = auth()->id();
            $purchasedPackageIds = Purchase::where('user_id',$userId)->where('status','active')->pluck('package_id');
            $packageOne = Package::whereIn('id',$purchasedPackageIds)->where('tab','vip')->get();
            $packagetwo = Package::whereIn('id',$purchasedPackageIds)->where('tab','fixed')->get();
            $packagethree = Package::whereIn('id',$purchasedPackageIds)->where('tab','event')->get();
        ?>

        <!-- HARiAN -->
        <div id="daily-income" class="plan-list">
            <?php $__empty_1 = true; $__currentLoopData = $packageOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $myVip = Purchase::where('user_id',$userId)->where('package_id',$element->id)->first();
                    $last_claim = UserLedger::where(['user_id'=>$userId,'reason'=>'daily_claim_'.$element->id])->latest()->first();
                    $lastPurchaseDate = $last_claim->created_at ?? $myVip->created_at;
                    $diffInHours = $lastPurchaseDate->diffInHours(now());
                    $canClaim = !UserLedger::where(['user_id'=>$userId,'reason'=>'daily_claim_'.$element->id])->whereDate('created_at', today())->exists();
                ?>
                <div class="plan-card">
                    <div class="plan-title">
                        <span><?php echo e($element->name); ?></span>
                        <?php if($myVip): ?>
                        <a href="https://chat.whatsapp.com/I9gwgmZIMEEIja29Fncism" target="_blank" class="vip-group">
                            <i class="fab fa-whatsapp"></i> Grup VIP
                        </a>
                        <?php endif; ?>
                    </div>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span>Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                            <div class="detail-item"><span>Pendapatan Harian:</span><span class="value"><?php echo e(price($element->daily_limit)); ?></span></div>
                            <div class="detail-item"><span>Total Pendapatan:</span><span class="value"><?php echo e(price($element->daily_limit*$element->validity)); ?></span></div>
                            <div class="detail-item"><span>Dibeli pada:</span><span class="value"><?php echo e($myVip->created_at->format('d M Y H:i')); ?></span></div>
                        </div>
                    </div>

                    <?php if($diffInHours < 24): ?>
                        <button class="action-btn countdown" id="countdown-<?php echo e($element->id); ?>">00j 00m 00d</button>
                    <?php elseif($canClaim): ?>
                        <button class="action-btn" onclick="window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'">Klaim Sekarang</button>
                    <?php else: ?>
                        <button class="action-btn countdown" disabled>Sudah Diklaim</button>
                    <?php endif; ?>

                    <script>
                        (function(){
                            let lastPurchaseDate = new Date("<?php echo e($lastPurchaseDate); ?>");
                            let endTime = new Date(lastPurchaseDate.getTime()+24*60*60*1000);
                            const countdownEl = document.getElementById("countdown-<?php echo e($element->id); ?>");
                            if(!countdownEl) return;
                            function updateCountdown(){
                                let now=new Date().getTime();
                                let distance=endTime-now;
                                if(distance<0){
                                    clearInterval(countdownInterval);
                                    countdownEl.style.display='none';
                                    const claimButton=document.querySelector(`button[onclick*="vip_id=<?php echo e($element->id); ?>"]`);
                                    if(claimButton) claimButton.style.display='block';
                                    return;
                                }
                                let h=Math.floor((distance%(1000*60*60*24))/(1000*60*60));
                                let m=Math.floor((distance%(1000*60*60))/(1000*60));
                                let s=Math.floor((distance%(1000*60))/1000);
                                countdownEl.innerText=`${h.toString().padStart(2,'0')}j ${m.toString().padStart(2,'0')}m ${s.toString().padStart(2,'0')}d`;
                            }
                            var countdownInterval=setInterval(updateCountdown,1000);
                            updateCountdown();
                        })();
                    </script>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="no-record">Tidak ada rencana harian aktif.</div>
            <?php endif; ?>
        </div>

        <!-- MINGGUAN -->
        <div id="welfare-plan" class="plan-list hidden">
            <?php $welfarePackages = $packagetwo->merge($packagethree); ?>
            <?php $__empty_1 = true; $__currentLoopData = $welfarePackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $myVip = Purchase::where('user_id',$userId)->where('package_id',$element->id)->first();
                    $endDate = $myVip->created_at->addDays($element->validity);
                ?>
                <div class="plan-card">
                    <h3 class="plan-title"><?php echo e($element->name); ?></h3>
                    <div class="plan-body">
                        <div class="plan-image-container"><img src="<?php echo e(asset($element->photo)); ?>" alt="<?php echo e($element->name); ?>" class="plan-image"></div>
                        <div class="plan-details">
                            <div class="detail-item"><span>Harga:</span><span class="value"><?php echo e(price($element->price)); ?></span></div>
                            <div class="detail-item"><span>Siklus:</span><span class="value"><?php echo e($element->validity); ?> hari</span></div>
                            <div class="detail-item"><span>Total Keuntungan:</span><span class="value"><?php echo e(price($element->daily_limit*$element->validity)); ?></span></div>
                            <div class="detail-item"><span>Dibeli pada:</span><span class="value"><?php echo e($myVip->created_at->format('d M Y H:i')); ?></span></div>
                            <div class="detail-item"><span>Selesai pada:</span><span class="value"><?php echo e($endDate->format('d M Y H:i')); ?></span></div>
                        </div>
                    </div>

                    <button class="action-btn countdown" id="countdown-weekly-<?php echo e($element->id); ?>">Berjalan</button>

                    <script>
                        (function(){
                            let endDate = new Date("<?php echo e($endDate); ?>");
                            const countdownEl = document.getElementById("countdown-weekly-<?php echo e($element->id); ?>");
                            if(!countdownEl) return;
                            function updateCountdown(){
                                let now=new Date().getTime();
                                let distance=endDate-now;
                                if(distance<0){
                                    clearInterval(countdownInterval);
                                    countdownEl.innerText='Klaim Sekarang';
                                    countdownEl.disabled=false;
                                    countdownEl.classList.remove('countdown');
                                    countdownEl.onclick=function(){ window.location.href='/my/vip?vip_id=<?php echo e($element->id); ?>'; }
                                    return;
                                }
                                let d=Math.floor(distance/(1000*60*60*24));
                                let h=Math.floor((distance%(1000*60*60*24))/(1000*60*60));
                                let m=Math.floor((distance%(1000*60*60))/(1000*60));
                                let s=Math.floor((distance%(1000*60))/1000);
                                countdownEl.innerText=`${d}d ${h.toString().padStart(2,'0')}j ${m.toString().padStart(2,'0')}m ${s.toString().padStart(2,'0')}d`;
                            }
                            var countdownInterval=setInterval(updateCountdown,1000);
                            updateCountdown();
                        })();
                    </script>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="no-record">Tidak ada rencana mingguan aktif.</div>
            <?php endif; ?>
        </div>
    </div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function switchTab(evt,tabId){
    document.querySelectorAll('.plan-list').forEach(c=>c.classList.add('hidden'));
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.getElementById(tabId).classList.remove('hidden');
    evt.currentTarget.classList.add('active');
}
</script>

</body>
</html>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/main/vip.blade.php ENDPATH**/ ?>