<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui, viewport-fit=cover">
<title>Dashboard</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
    body{
        margin:0;
        padding:0;
        background:#ffffff;
        font-family:'Poppins', sans-serif;
        color:#222;
        padding-bottom:80px;
    }

    /* WRAPPER */
    .main-container{
        max-width:520px;
        margin:18px auto;
        padding:0 14px;
    }

    /* HEADER */
    .header{
        background:#fffbea;
        border:2px solid #ffe066;
        border-radius:14px;
        padding:14px 18px;
        box-shadow:0 0 12px rgba(255,220,0,0.25);
        display:flex;
        align-items:center;
        gap:12px;
        margin-bottom:18px;
    }
    .back-btn{
        font-size:22px;
        cursor:pointer;
        font-weight:700;
        color:#d69b00;
    }
    .header-title{
        font-size:18px;
        font-weight:700;
        color:#c59000;
    }

    /* USER INFO */
    .user-info-bar{
        background:#fffbed;
        border:2px solid #ffe066;
        border-radius:14px;
        padding:14px;
        display:flex;
        align-items:center;
        gap:14px;
        margin-bottom:18px;
        box-shadow:0 0 12px rgba(255,210,0,0.25);
    }
    .user-info-bar .logo{
        width:54px;
        height:54px;
        object-fit:cover;
        border-radius:50%;
        border:2px solid #ffd54a;
        box-shadow:0 0 6px rgba(255,200,0,0.6);
    }
    .user-id{
        font-size:14px;
        font-weight:600;
        color:#b88600;
    }

    /* SALDO */
    .balance-card{
        background:#fffdf2;
        border:2px solid #ffe066;
        border-radius:14px;
        padding:18px;
        margin-bottom:20px;
        box-shadow:0 0 14px rgba(255,220,0,0.35);
    }
    .balance-header{
        display:flex;
        justify-content:space-between;
        align-items:center;
        margin-bottom:10px;
    }
    .balance-label{
        font-size:15px;
        font-weight:700;
        color:#c68d00;
    }
    .balance-amount{
        font-size:26px;
        font-weight:700;
        color:#ffb600;
        margin-bottom:12px;
    }
    .balance-icon{
        width:28px;
    }

    .sub-stats{
        display:flex;
        justify-content:space-between;
        gap:10px;
    }
    .sub-stat{
        width:50%;
        background:#fff8d1;
        padding:10px;
        border-radius:10px;
        border:1px solid #ffe066;
        text-align:center;
    }
    .label{
        font-size:12px;
        color:#8f6b00;
    }
    .value{
        font-size:14px;
        font-weight:700;
        color:#d59800;
    }

    /* GRID MENU */
    .action-buttons{
        background:#fffef5;
        border:2px solid #ffe066;
        border-radius:14px;
        padding:18px 15px;
        display:grid;
        grid-template-columns:repeat(3,1fr);
        gap:16px;
        box-shadow:0 0 14px rgba(255,220,0,0.25);
        margin-bottom:20px;
    }
    .action-btn{
        text-align:center;
        cursor:pointer;
        padding:10px 0;
        border-radius:12px;
        background:#fffdf0;
        border:1px solid #ffef99;
        transition:0.25s;
    }
    .action-btn:hover{
        background:#fff6c5;
        transform:scale(1.06);
    }
    .action-btn img{
        width:42px;
        margin-bottom:6px;
    }
    .action-btn div{
        font-size:13px;
        font-weight:600;
        color:#c58d00;
    }

    /* LOGOUT ITEM */
    .menu-item{
        display:flex;
        align-items:center;
        gap:10px;
        padding:12px;
        border-radius:14px;
        margin-top:10px;
        background:#fff5f5;
        border:1px solid #ffb3b3;
        text-decoration:none;
    }
    .menu-item img{
        width:36px;
    }
    .menu-text{
        font-size:14px;
        font-weight:700;
    }

    /* BOTTOM NAV */
    .bottom-nav{
        position:fixed;
        bottom:0;
        left:0;
        width:100%;
        background:#ffffff;
        border-top:2px solid rgba(255,215,0,0.55);
        display:flex;
        justify-content:space-around;
        padding:10px 0 8px;
        box-shadow:0 -3px 12px rgba(255,220,0,0.25);
        z-index:999;
    }
    .nav-item{
        text-align:center;
        font-size:13px;
        cursor:pointer;
        color:#666;
    }
    .nav-icon{
        font-size:22px;
        margin-bottom:3px;
        color:#bfa200;
        transition:0.25s;
    }
    .nav-item.active .nav-icon{
        color:#ffd000;
        text-shadow:0 0 8px rgba(255,210,0,0.6);
    }
    .nav-item:hover .nav-icon{
        transform:scale(1.15);
        color:#ffe14d;
    }
    .nav-label{
        font-size:12px;
    }
</style>
</head>
<body>

<div class="main-container">

    <!-- HEADER -->
    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">FINANCE WORLD</h1>
    </div>

    <!-- USER INFO -->
    <div class="user-info-bar">
        <img src="images (2).jpg" alt="Logo" class="logo">
        <div class="user-id">ID : <?php echo e(auth()->user()->phone); ?></div>
    </div>

    <!-- SALDO -->
    <div class="balance-card">
        <div class="balance-header">
            <div class="balance-label">Saldo Akun</div>
            <img src="https://api.iconify.design/solar:wallet-linear.svg?color=%2300e0ff" class="balance-icon">
        </div>

        <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>

        <div class="sub-stats">
            <div class="sub-stat">
                <div class="label">Total Penarikan</div>
                <div class="value">
                    <?php echo e(price(\App\Models\Withdrawal::where('user_id', auth()->id())->where('status', 'approved')->sum('amount'))); ?>

                </div>
            </div>
            <div class="sub-stat">
                <div class="label">Total Deposit</div>
                <div class="value">
                    <?php echo e(price(\App\Models\Deposit::where('user_id', auth()->id())->where('status', 'approved')->sum('amount'))); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- GRID MENU -->
    <div class="action-buttons">
        <div class="action-btn" onclick="window.location.href='/user/recharge'">
            <img src="https://api.iconify.design/solar:wallet-bold.svg?color=%23ffcc00">
            <div>Isi Ulang</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/withdraw'">
            <img src="https://api.iconify.design/solar:money-bag-bold.svg?color=%23ffcc00">
            <div>Penarikan</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/history'">
            <img src="https://api.iconify.design/mdi:clipboard-text-outline.svg?color=%23ffcc00">
            <div>Catatan</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/vip'">
            <img src="https://api.iconify.design/mdi:crown-outline.svg?color=%23ffcc00">
            <div>Produk</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/promo'">
    <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%23ffcc00">
    <div>Hadiah</div>
</div>


        <div class="action-btn" onclick="window.location.href='/add/card'">
            <img src="https://api.iconify.design/mdi:credit-card-outline.svg?color=%23ffcc00">
            <div>Kartu Bank</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/about-us'">
            <img src="https://api.iconify.design/mdi:office-building-outline.svg?color=%23ffcc00">
            <div>Tentang</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/download'">
            <img src="https://api.iconify.design/mdi:download-circle-outline.svg?color=%23ffcc00">
            <div>Download</div>
        </div>

        <div class="action-btn" onclick="window.location.href='/checkin'">
            <img src="https://api.iconify.design/mdi:calendar-check-outline.svg?color=%23ffcc00">
            <div>Check-in</div>
        </div>
    </div>

    <!-- LOGOUT -->
    <a href="/logout" class="menu-item">
        <img src="https://api.iconify.design/mdi:logout-variant.svg?color=%23ff5c5c">
        <span class="menu-text" style="color:#ff5c5c;">Keluar</span>
    </a>

</div>

<!-- BOTTOM NAV -->
<div class="bottom-nav">
    <div class="nav-item" onclick="window.location.href='/'">
        <div class="nav-icon">🏠</div>
        <div class="nav-label">Home</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my/vip'">
        <div class="nav-icon">📦</div>
        <div class="nav-label">Investasi</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my-team'">
        <div class="nav-icon">👥</div>
        <div class="nav-label">Team</div>
    </div>

    <div class="nav-item active" onclick="window.location.href='/mine'">
        <div class="nav-icon">👤</div>
        <div class="nav-label">Profil</div>
    </div>
</div>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>