
<!DOCTYPE html>  
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Atur Bank</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
/* ===============================
   ROOT  TEMA HITAM & MAROON
================================ */
:root {
    --primary-color: #7F1D1D;        /* maroon utama */
    --accent-color: #450A0A;         /* maroon gelap */
    --accent-light: #FCA5A5;         /* maroon terang */
    --text-color: #F8FAFC;           /* teks terang */
    --subtext-color: #E5E7EB;        /* teks sekunder */
    --card-bg: rgba(10, 10, 10, 0.82); /* card hitam transparan */
    --border-color: rgba(127,29,29,0.45);
    --input-bg: rgba(5, 5, 5, 0.9);
    --overlay: rgba(0, 0, 0, 0.82);
}

/* RESET */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* ===============================
   BODY  FULL BACKGROUND FOTO
================================ */
html, body {
    width: 100%;
    height: 100%;
    font-family: 'Poppins', sans-serif;
    color: var(--text-color);
    background:
        linear-gradient(var(--overlay), var(--overlay)),
        url("bg.jpg") no-repeat center center fixed;
    background-size: cover;
}

/* ===============================
   MAIN CONTAINER
================================ */
.main-container {
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    padding-bottom: 90px;
}

/* ===============================
   HEADER
================================ */
.header {
    background: linear-gradient(135deg, #7F1D1D, #450A0A);
    color: var(--text-color);
    padding: 18px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 8px 30px rgba(0,0,0,0.85);
    backdrop-filter: blur(12px);
}

.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    font-weight: 700;
    cursor: pointer;
    transition: transform 0.25s;
}

.header .back-btn:hover {
    transform: scale(1.2);
}

.header .header-title {
    font-size: 1.4rem;
    font-weight: 800;
}

/* ===============================
   CONTENT
================================ */
.content-wrapper {
    padding: 25px 15px 40px;
}

/* ===============================
   FORM CARD
================================ */
.form-container {
    background: var(--card-bg);
    border-radius: 20px;
    padding: 25px 20px;
    border: 1px solid var(--border-color);
    box-shadow: 0 12px 40px rgba(0,0,0,0.85);
    backdrop-filter: blur(18px);
    animation: fadeIn 0.4s ease-in-out;
}

/* LABEL */
.form-label {
    display: block;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 6px;
    color: var(--accent-light);
}

/* INPUT */
.form-control {
    width: 100%;
    height: 50px;
    padding: 0 15px;
    border-radius: 14px;
    border: 1px solid var(--border-color);
    background: var(--input-bg);
    color: var(--text-color);
    font-size: 15px;
    transition: 0.3s;
}

.form-control:focus {
    border-color: var(--accent-light);
    box-shadow: 0 0 16px rgba(127,29,29,0.75);
    outline: none;
}

/* SELECT ARROW */
select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' stroke='%23FCA5A5' viewBox='0 0 16 16'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    background-size: 14px 10px;
}

/* ===============================
   SUBMIT BUTTON
================================ */
.submit-btn {
    width: 100%;
    padding: 15px;
    background: linear-gradient(135deg, #7F1D1D, #450A0A);
    color: var(--text-color);
    border: none;
    border-radius: 16px;
    font-size: 16px;
    font-weight: 800;
    cursor: pointer;
    margin-top: 18px;
    box-shadow: 0 10px 35px rgba(127,29,29,0.6);
    transition: 0.3s;
}

.submit-btn:hover {
    transform: translateY(-3px) scale(1.03);
    box-shadow: 0 18px 55px rgba(127,29,29,0.9);
}


/* ===============================
   ANIMATION
================================ */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(12px); }
    to { opacity: 1; transform: translateY(0); }
}



  </style>
</head>

<body>
<div class="main-container">

  <div class="header">
    <span class="back-btn" onclick="history.back()"></span>
    <h1 class="header-title">Informasi Bank</h1>
  </div>


  <div class="content-wrapper">
    <div class="form-container">
      <form action="<?php echo e(route('setup.gateway.submit')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="form-group">
          <label class="form-label" for="holderName">Nama Pemilik Rekening</label>
          <input id="holderName" class="form-control" name="holdername" value="<?php echo e(auth()->user()->holder_name); ?>" placeholder="Masukkan Nama Pemilik Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="accountNumber">Nomor Rekening</label>
          <input id="accountNumber" class="form-control" name="gateway_number" value="<?php echo e(auth()->user()->gateway_number); ?>" placeholder="Masukkan Nomor Rekening" required>
        </div>

        <div class="form-group">
          <label class="form-label" for="bankCode">Nama Bank</label>
          <select id="bankCode" class="form-control" name="gateway_method" required>
            <?php
              $methods = \App\Models\PaymentMethod::select('id','name')->where('status', 'active')->groupBy('name')->get();
            ?>
            <option value="">Pilih Bank</option>
            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($element->id); ?>" <?php echo e((auth()->user()->gateway_method == $element->id) ? 'selected' : ''); ?>>
                <?php echo e($element->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <button type="submit" class="submit-btn">
          Simpan Informasi
        </button>
      </form>
    </div>
  </div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
</body>
</html>
<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/add_bank.blade.php ENDPATH**/ ?>