<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <link rel="icon" type="image/png" href="<?php echo e(setting('logo')); ?>">
  <title>Login</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --primary-world: #1E90FF; /* biru laut */
      --secondary-world: #00BFFF; /* biru langit */
      --text-light: #ffffff;
      --bg-dark: #010101;
      --bg-dark-alt: #111111;
    }

    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: radial-gradient(circle at top, var(--bg-dark-alt) 0%, var(--bg-dark) 70%, #000 100%);
      color: var(--text-light);
      overflow-x: hidden;
      position: relative;
    }

    .particles {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      overflow: hidden;
      z-index: -1;
    }

    .particle {
      position: absolute;
      width: 6px;
      height: 6px;
      background: var(--primary-world);
      border-radius: 50%;
      animation: float 10s linear infinite;
      opacity: 0.6;
    }

    @keyframes float {
      from {
        transform: translateY(100vh) scale(0.5);
        opacity: 0;
      }

      50% {
        opacity: 1;
      }

      to {
        transform: translateY(-10vh) scale(1);
        opacity: 0;
      }
    }

    .page-wraper {
      max-width: 600px;
      margin: 0 auto;
      min-height: 100vh;
      background: rgba(0, 191, 255, 0.05);
      border-radius: 20px;
      backdrop-filter: blur(12px);
      box-shadow: 0 0 25px rgba(30, 144, 255, 0.2);
      overflow: hidden;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      padding: 15px;
      position: relative;
      z-index: 2;
    }

    .back-arrow {
      font-size: 24px;
      color: var(--text-light);
      text-decoration: none;
      position: absolute;
      left: 15px;
    }

    .header-title {
      font-size: 22px;
      font-weight: 600;
      text-align: center;
      flex-grow: 1;
      color: var(--primary-world);
      text-shadow: 0 0 12px rgba(30, 144, 255, 0.6);
    }

    .banner-container {
      position: relative;
      overflow: hidden;
    }

    .banner-image {
      width: 100%;
      display: block;
      border-bottom: 2px solid rgba(30, 144, 255, 0.3);
      box-shadow: 0 4px 20px rgba(30, 144, 255, 0.1);
    }

    .banner-shine {
      position: absolute;
      top: 0;
      left: -100%;
      width: 60%;
      height: 100%;
      background: linear-gradient(120deg, transparent, rgba(255, 255, 255, 0.2), transparent);
      animation: shineMove 4s infinite;
    }

    @keyframes shineMove {
      0% {
        left: -100%;
      }

      50% {
        left: 120%;
      }

      100% {
        left: 120%;
      }
    }

    .auth-container {
      padding: 25px 25px 40px;
      margin-top: -15px;
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      position: relative;
      z-index: 1;
    }

    .tab-navigation {
      display: flex;
      background: rgba(30, 144, 255, 0.08);
      border-radius: 12px;
      padding: 6px;
      margin-bottom: 25px;
      box-shadow: inset 0 0 10px rgba(30, 144, 255, 0.3);
    }

    .tab {
      flex: 1;
      padding: 12px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      border-radius: 9px;
      cursor: pointer;
      background: transparent;
      color: var(--text-light);
      transition: all 0.3s ease;
      text-decoration: none;
    }

    .tab.active {
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: var(--text-light);
      box-shadow: 0 0 12px rgba(30, 144, 255, 0.4);
    }

    .input-group {
      position: relative;
      margin-bottom: 22px;
      display: flex;
      align-items: center;
      background: rgba(30, 144, 255, 0.08);
      border: 1px solid rgba(30, 144, 255, 0.2);
      border-radius: 14px;
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .input-group:focus-within {
      border-color: var(--primary-world);
      box-shadow: 0 0 12px rgba(30, 144, 255, 0.5);
      transform: scale(1.01);
    }

    .input-icon {
      width: 50px;
      text-align: center;
      color: var(--primary-world);
      font-size: 18px;
      border-right: 1px solid rgba(30, 144, 255, 0.1);
    }

    .input-field {
      flex: 1;
      padding: 15px;
      font-size: 15px;
      background: transparent;
      border: none;
      color: var(--text-light);
    }

    .input-field::placeholder {
      color: rgba(255, 255, 255, 0.5);
    }

    .input-field:focus {
      outline: none;
    }

    .forgot-link {
      display: block;
      text-align: right;
      font-size: 14px;
      color: var(--primary-world);
      text-decoration: none;
      margin-top: 5px;
      transition: all 0.3s;
    }

    .forgot-link:hover {
      color: var(--secondary-world);
      text-shadow: 0 0 8px rgba(30, 144, 255, 0.7);
    }

    .submit-btn {
      width: 100%;
      padding: 15px;
      background: linear-gradient(135deg, var(--primary-world), var(--secondary-world));
      color: var(--text-light);
      border: none;
      border-radius: 50px;
      font-size: 18px;
      font-weight: 600;
      cursor: pointer;
      margin-top: 20px;
      box-shadow: 0 0 20px rgba(30, 144, 255, 0.3);
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(135deg, var(--secondary-world), #1C86EE);
      box-shadow: 0 0 30px rgba(30, 144, 255, 0.6);
      transform: scale(1.02);
    }
  </style>
</head>

<body>
  <!-- Partikel biru dunia -->
  <div class="particles">
    <div class="particle" style="left:10%; animation-delay:0s;"></div>
    <div class="particle" style="left:30%; animation-delay:2s;"></div>
    <div class="particle" style="left:50%; animation-delay:4s;"></div>
    <div class="particle" style="left:70%; animation-delay:1s;"></div>
    <div class="particle" style="left:90%; animation-delay:3s;"></div>
  </div>

  <div class="page-wraper">
    <!-- Header -->
    <header class="header">
      <a href="javascript:history.back()" class="back-arrow">&#60;</a>
      <h1 class="header-title">Login</h1>
    </header>

    <!-- Banner -->
    <div class="banner-container">
      <img src="/img/1.jpeg" alt="Banner" class="banner-image">
      <div class="banner-shine"></div>
    </div>

    <!-- Form Login -->
    <div class="auth-container">
      <div class="tab-navigation">
        <button class="tab active">Log In</button>
        <a href="<?php echo e(route('register')); ?>" class="tab">Register</a>
      </div>

      <form action="<?php echo e(url('login')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="input-group">
          <i class="fas fa-mobile-alt input-icon"></i>
          <input type="tel" name="phone" class="input-field" placeholder="Nomor Telepon" required>
        </div>

        <div class="input-group">
          <i class="fas fa-lock input-icon"></i>
          <input type="password" name="password" class="input-field" placeholder="Kata Sandi" required>
        </div>

        <a href="#" class="forgot-link">Lupa kata sandi?</a>

        <button type="submit" class="submit-btn">Masuk Sekarang</button>
      </form>
    </div>
  </div>

  <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/financew/public_html/resources/views/app/auth/login.blade.php ENDPATH**/ ?>