<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>mine</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --gold: #e8c26b;
    --gold-light: #ffeb9c;
    --gold-deep: #b9932f;
    --text-dark: #2b2b2b;
    --subtext-dark: #5a5a5a;
}

* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    font-family: 'Poppins', sans-serif;
    background: #ffffff;
    color: var(--text-dark);
    min-height: 100vh;
    overflow-x: hidden;
}

.main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    position: relative;
    padding-bottom: 100px;
}

/* HEADER */
.header {
    background: linear-gradient(135deg, var(--gold-light), var(--gold), var(--gold-deep));
    padding: 18px 15px;
    text-align: center;
    position: relative;
    box-shadow: 0 4px 10px rgba(0,0,0,0.15);
    border-bottom: 1px solid rgba(0,0,0,0.1);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    top: 16px;
    font-size: 26px;
    color: #4a3b14;
    cursor: pointer;
    font-weight: bold;
    transition: transform 0.3s ease;
}
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: #4a3b14;
}

/* BALANCE NEW BOX */
.balance-card {
    background: #fff9e6;
    border-radius: 18px;
    padding: 20px;
    color: #4a3b14;
    border: 1px solid var(--gold);
    box-shadow: 0 6px 20px rgba(0,0,0,0.12);
    margin: 25px 0;
    transition: .3s ease;
}
.balance-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 0 25px rgba(200,160,40,0.3);
}

/* NEW merged logo + id + saldo layout */
.balance-top {
    display: flex;
    align-items: center;
    margin-bottom: 18px;
}
.balance-top img {
    width: 65px;
    height: 65px;
    border-radius: 12px;
    border: 2px solid var(--gold);
    margin-right: 15px;
    object-fit: cover;
    box-shadow: 0 0 8px rgba(200,160,40,0.4);
}
.balance-top .user-info {
    display: flex;
    flex-direction: column;
}
.user-info .user-id {
    font-size: 15px;
    font-weight: 600;
    color: #4a3b14;
    margin-bottom: 5px;
}

/* saldo */
.balance-amount {
    font-size: 28px;
    font-weight: 700;
    color: var(--gold-deep);
}
.balance-label {
    font-size: 14px;
    font-weight: 600;
    color: #7a6a38;
}

.sub-stats {
    display: flex;
    justify-content: space-between;
    margin-top: 18px;
    font-size: 13px;
    color: #7a6a38;
}

.sub-stat .value {
    font-weight: 700;
    color: var(--gold-deep);
}

/* ACTION BUTTONS */
.action-buttons {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    margin-bottom: 25px;
}
.action-btn {
    background: #fff6d5;
    border: 1px solid var(--gold);
    border-radius: 14px;
    width: 50%;
    padding: 12px 5px;
    text-align: center;
    color: #4a3b14;
    font-weight: 600;
    cursor: pointer;
    transition: all .3s ease;
    box-shadow: 0 4px 13px rgba(0,0,0,0.12);
}
.action-btn:hover { transform: translateY(-3px); }

/* MENU */
.menu-title {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 12px;
    color: #4a3b14;
}
.menu-list {
    background: #fff7db;
    border-radius: 16px;
    padding: 10px;
    border: 1px solid var(--gold-light);
    box-shadow: 0 4px 12px rgba(0,0,0,0.12);
}
.menu-item {
    display: flex;
    align-items: center;
    padding: 12px;
    border-radius: 12px;
    margin-bottom: 8px;
    background: #fff;
    border: 1px solid #f5e3a3;
    transition: .3s ease;
}
.menu-item:hover { background: #fff3c4; }

/* NAVBAR */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, var(--gold-light), var(--gold-deep));
    display: flex;
    justify-content: space-around;
    padding: 8px 0;
    box-shadow: 0 -2px 15px rgba(0,0,0,0.25);
}
.nav-item img { width: 25px; }
</style>
</head>
<body>

<div class="main-container">

    <div class="header">
        <span class="" onclick="history.back()">‹</span>
        <h1 class="header-title">FD225WAT</h1>
    </div>

    <div class="content-wrapper">

        <!-- NEW BALANCE CARD (logo + id + saldo) -->
        <div class="balance-card">

            <div class="balance-top">
                <img src="WHATT.jpg" alt="logo">
                <div class="user-info">
                    <div class="user-id">ID : <?php echo e(auth()->user()->phone); ?></div>
                    <div class="balance-label">Saldo Akun</div>
                    <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
                </div>
            </div>

            <div class="sub-stats">
                <div class="sub-stat">
                    <div class="label">Total Penarikan</div>
                    <div class="value"><?php echo e(price(\App\Models\Withdrawal::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?></div>
                </div>
                <div class="sub-stat">
                    <div class="label">Total Deposit</div>
                    <div class="value"><?php echo e(price(\App\Models\Deposit::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?></div>
                </div>
            </div>

        </div>

        <!-- BUTTONS -->
        <div class="action-buttons">
            <div class="action-btn" onclick="window.location.href='/user/recharge'">
                <img src="https://api.iconify.design/solar:wallet-bold.svg">
                <div>Isi Ulang</div>
            </div>
            <div class="action-btn" onclick="window.location.href='/withdraw'">
                <img src="https://api.iconify.design/solar:money-bag-bold.svg">
                <div>Penarikan</div>
            </div>
        </div>

        <!-- MENU -->
        <div class="service-menu">
            <div class="menu-title">Layanan Saya</div>
            <div class="menu-list">
                <a href="/history" class="menu-item">
                    <img src="https://api.iconify.design/mdi:clipboard-text-outline.svg" class="menu-icon">
                    <span class="menu-text">Catatan Akun</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/my/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:crown-outline.svg" class="menu-icon">
                    <span class="menu-text">Produk Saya</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/invite" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-multiple-plus-outline.svg" class="menu-icon">
                    <span class="menu-text">Undang & Informasi Tim</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-tie-outline.svg" class="menu-icon">
                    <span class="menu-text">Gaji Agen</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/add/card" class="menu-item">
                    <img src="https://api.iconify.design/mdi:credit-card-outline.svg" class="menu-icon">
                    <span class="menu-text">Kartu Bank</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/about-us" class="menu-item">
                    <img src="https://api.iconify.design/mdi:office-building-outline.svg" class="menu-icon">
                    <span class="menu-text">Tentang kami</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="x" class="menu-item">
                    <img src="https://api.iconify.design/mdi:download-circle-outline.svg" class="menu-icon">
                    <span class="menu-text">Download Aplikasi</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>

                <a href="/logout" class="menu-item">
                    <img src="https://api.iconify.design/mdi:logout-variant.svg" class="menu-icon">
                    <span class="menu-text" style="color:#ff5c5c;">Keluar</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
            </div>
        </div>

    </div>

    <!-- NAVBAR -->
    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img src="https://api.iconify.design/solar:home-2-bold.svg">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my/vip'">
            <img src="https://api.iconify.design/solar:chart-bold.svg">
            <div class="nav-label">Investasi</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg">
            <div class="nav-label">Profil</div>
        </div>
    </div>

</div>
</body>
</html>
<?php /**PATH /home/speedeku/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>