<!DOCTYPE html>    
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>Catatan Akun</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(setting('logo')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <style>
        :root {
            --primary-color: #2563eb;
            --secondary-color: #1e40af;
            --background-color: #0f172a;
            --text-color: #ffffff;
            --light-text-color: #94a3b8;
            --card-color: #1e293b;
            --success-color: #22c55e;
            --pending-color: #f59e0b;
            --failed-color: #ef4444;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        html, body {
            background: var(--background-color);
            width: 100%;
            overflow-x: hidden;
        }

        body {
            font-family: 'Poppins', sans-serif;
            color: var(--text-color);
            -webkit-font-smoothing: antialiased;
            animation: fadeIn 0.8s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(15px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .main-container { 
            width: 100%;
            max-width: 600px; 
            margin: 0 auto;
            min-height: 100vh;
            background: var(--background-color);
        }

        .header { 
            background: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
            padding: 18px 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            box-shadow: 0 4px 15px rgba(0,0,0,0.4);
            border-bottom-left-radius: 20px;
            border-bottom-right-radius: 20px;
        }

        .header .back-btn {
            position: absolute;
            left: 20px;
            font-size: 26px;
            color: #fff;
            cursor: pointer;
            transition: transform 0.3s;
        }

        .header .back-btn:hover { transform: scale(1.2); }

        .header .header-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #fff;
            text-shadow: 0 0 8px rgba(255,255,255,0.25);
        }

        .content-wrapper { padding: 20px 15px 120px; animation: fadeIn 1s ease; }

        .record-tabs {
            display: flex;
            background: var(--card-color);
            border-radius: 14px;
            padding: 6px;
            margin-bottom: 22px;
            box-shadow: inset 0 1px 4px rgba(255,255,255,0.06);
        }

        .tab-btn {
            flex: 1;
            padding: 10px 0;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            background: transparent;
            color: var(--light-text-color);
            transition: all 0.35s ease;
            border-radius: 10px;
        }

        .tab-btn.active {
            background: linear-gradient(135deg, var(--primary-color), #3b82f6);
            color: #fff;
            box-shadow: 0 4px 15px rgba(59,130,246,0.4);
            transform: scale(1.02);
        }

        .tab-content { display: none; animation: fadeIn 0.8s ease; }
        .tab-content.active { display: block; }

        .record-list { display: flex; flex-direction: column; gap: 16px; }

        .record-card {
            background: var(--card-color);
            border-radius: 18px;
            padding: 16px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 4px 18px rgba(0,0,0,0.45);
            transition: all 0.35s ease;
            position: relative;
            overflow: hidden;
        }

        .record-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(37,99,235,0.3);
        }

        .record-card.type-income { border-left: 4px solid var(--success-color); }
        .record-card.type-expense { border-left: 4px solid var(--failed-color); }
        .record-card.type-commission { border-left: 4px solid var(--primary-color); }

        .record-icon-area {
            width: 52px; height: 52px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 22px; flex-shrink: 0;
        }

        .icon-income { background-color: rgba(34,197,94,0.15); color: var(--success-color); }
        .icon-expense { background-color: rgba(239,68,68,0.15); color: var(--failed-color); }
        .icon-commission { background-color: rgba(59,130,246,0.15); color: var(--primary-color); }

        .record-details {
            flex: 1;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-left: 12px;
        }

        .record-info .record-reason { font-weight: 600; font-size: 15px; color: #fff; }
        .record-info .record-date { font-size: 13px; color: var(--light-text-color); }

        .record-summary { text-align: right; }
        .record-summary .record-amount { font-size: 17px; font-weight: 700; display: block; margin-bottom: 5px; }
        .record-amount.amount-positive { color: var(--success-color); }
        .record-amount.amount-negative { color: var(--failed-color); }

        .record-summary .record-status {
            font-weight: 600;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 12px;
            text-transform: capitalize;
        }

        .status-approved, .status-successful { background-color: rgba(34,197,94,0.15); color: var(--success-color); }
        .status-pending, .status-processing { background-color: rgba(245,158,11,0.15); color: var(--pending-color); }
        .status-rejected { background-color: rgba(239,68,68,0.15); color: var(--failed-color); }

        .no-record {
            text-align: center;
            padding: 50px 25px;
            color: var(--light-text-color);
            background: var(--card-color);
            border-radius: 14px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.35);
        }
    </style>
</head>   

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Catatan Akun</h1>
    </div>

    <?php
        $deposits = \App\Models\Deposit::where('user_id', auth()->id())
            ->orderByDesc('created_at')
            ->get()
            ->map(fn($item) => (object)[
                'type' => 'deposit',
                'reason' => 'Deposit',
                'amount' => $item->amount,
                'status' => $item->status,
                'created_at' => $item->created_at
            ]);

        $withdrawals = \App\Models\Withdrawal::where('user_id', auth()->id())
            ->orderByDesc('created_at')
            ->get()
            ->map(fn($item) => (object)[
                'type' => 'withdrawal',
                'reason' => 'Penarikan',
                'amount' => $item->amount,
                'status' => $item->status,
                'created_at' => $item->created_at
            ]);

        $commissions = \App\Models\UserLedger::where('user_id', auth()->id())
            ->whereNotIn('reason', ['payment_approved', 'withdraw_request', 'withdraw_approved', 'payment_rejected', 'user_deposit'])
            ->orderByDesc('created_at')
            ->get()
            ->map(function ($item) {
                $pert = strtolower($item->perticulation ?? '');
                $reasonText = match(true) {
                    str_contains($item->reason, 'purchase_commission') => 'Komisi Pembelian Produk',
                    str_contains($item->reason, 'team_rebate') && (str_contains($pert, 'level 1') || str_contains($pert, 'lv1') || str_contains($pert, 'l1')) => 'Rabat Profit Harian Level 1 (4%)',
                    str_contains($item->reason, 'team_rebate') && (str_contains($pert, 'level 2') || str_contains($pert, 'lv2') || str_contains($pert, 'l2')) => 'Rabat Profit Harian Level 2 (2%)',
                    str_contains($item->reason, 'team_rebate') && (str_contains($pert, 'level 3') || str_contains($pert, 'lv3') || str_contains($pert, 'l3')) => 'Rabat Profit Harian Level 3 (1%)',
                    str_contains($item->reason, 'daily_income') => 'Hasil Profit Harian Pribadi',
                    default => 'Komisi / Rabat'
                };

                return (object)[
                    'type' => 'commission',
                    'reason' => $reasonText,
                    'amount' => $item->amount,
                    'status' => $item->status ?? 'Disetujui',
                    'created_at' => $item->created_at
                ];
            });

        $allRecords = $deposits->concat($withdrawals)->concat($commissions)->sortByDesc('created_at');
    ?>

    <div class="content-wrapper">
        <div class="record-tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'all')">Semua</button>
            <button class="tab-btn" onclick="switchTab(event, 'deposit')">Deposit</button>
            <button class="tab-btn" onclick="switchTab(event, 'withdrawal')">Penarikan</button>
            <button class="tab-btn" onclick="switchTab(event, 'commission')">Komisi</button>
        </div>

        <?php
            function renderRecordCard($record) {
                $status = strtolower($record->status ?? 'disetujui');
                $statusClass = 'status-' . $status;
                $isIncome = in_array($record->type, ['deposit', 'commission']);
                $isExpense = $record->type === 'withdrawal';
                $cardClass = $isIncome ? 'type-income' : ($isExpense ? 'type-expense' : 'type-commission');
                $iconClass = $isIncome ? 'icon-income' : ($isExpense ? 'icon-expense' : 'icon-commission');
                $icon = $isIncome ? 'fa-arrow-down' : ($isExpense ? 'fa-arrow-up' : 'fa-star');
                $amountClass = $isIncome ? 'amount-positive' : 'amount-negative';
                $amountPrefix = $isIncome ? '+' : '-';

                echo '
                <div class="record-card ' . $cardClass . '">
                    <div class="record-icon-area ' . $iconClass . '">
                        <i class="fas ' . $icon . '"></i>
                    </div>
                    <div class="record-details">
                        <div class="record-info">
                            <div class="record-reason">' . ucfirst($record->reason) . '</div>
                            <div class="record-date">' . $record->created_at->format('d M Y, H:i') . '</div>
                        </div>
                        <div class="record-summary">
                            <span class="record-amount ' . $amountClass . '">' . $amountPrefix . price($record->amount) . '</span>
                            <span class="record-status ' . $statusClass . '">' . ucfirst($status) . '</span>
                        </div>
                    </div>
                </div>';
            }
        ?>

        
        <div id="all" class="tab-content active">
            <?php if($allRecords->count() > 0): ?>
                <div class="record-list">
                    <?php $__currentLoopData = $allRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php renderRecordCard($record); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Belum ada catatan transaksi.</div>
            <?php endif; ?>
        </div>

        
        <div id="deposit" class="tab-content">
            <?php if($deposits->count() > 0): ?>
                <div class="record-list">
                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php renderRecordCard($record); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Belum ada catatan deposit.</div>
            <?php endif; ?>
        </div>

        
        <div id="withdrawal" class="tab-content">
            <?php if($withdrawals->count() > 0): ?>
                <div class="record-list">
                    <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php renderRecordCard($record); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Belum ada catatan penarikan.</div>
            <?php endif; ?>
        </div>

        
        <div id="commission" class="tab-content">
            <?php if($commissions->count() > 0): ?>
                <div class="record-list">
                    <?php $__currentLoopData = $commissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php renderRecordCard($record); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Belum ada catatan komisi.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="/assets/app/js/jquery.js"></script>
<script>
    function switchTab(event, tabId) {
        document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
        document.getElementById(tabId).classList.add('active');
        event.currentTarget.classList.add('active');
    }
</script>
</body>
</html>
<?php /**PATH /home/runnlvbg/card5dgtal.com/resources/views/app/main/history.blade.php ENDPATH**/ ?>