<!DOCTYPE html>      
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>Tim</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --gold-main: #d4af37;
    --gold-light: #ffdd75;
    --gold-soft: #f8e9b0;
    --white-bg: #ffffff;
    --text-dark: #404040;
    --subtext: #777;
    --card-bg: rgba(255,255,255,0.6);
    --border-light: rgba(0,0,0,0.08);
}

/* RESET */
* { margin:0; padding:0; box-sizing:border-box; }
html, body { 
    font-family:'Poppins', sans-serif; 
    background: var(--white-bg);
    color: var(--text-dark); 
    min-height:100vh;
}

/* CONTAINER */
.main-container { 
    max-width:600px; 
    margin:0 auto; 
    position:relative; 
    padding-bottom:120px;
}

/* HEADER */
.header {
    background: linear-gradient(135deg,#fff3ca,#ffe7a0,#ffdf7b);
    padding:16px 20px;
    display:flex;
    justify-content:center;
    align-items:center;
    position:relative;
    box-shadow:0 5px 20px rgba(0,0,0,0.15);
    border-bottom:1px solid var(--border-light);
    border-radius:0 0 20px 20px;
}
.header .back-btn { 
    position:absolute; 
    left:20px; 
    font-size:28px; 
    color:#b58b25; 
    cursor:pointer; 
    transition:transform 0.3s; 
}
.header .back-btn:hover { transform:scale(1.2); }
.header .header-title { 
    font-size:1.5rem; 
    font-weight:700; 
    color:#6d520d;
}

/* REFERRAL BOX */
.referral-box {
    display:flex;
    justify-content:space-between;
    align-items:center;
    background:var(--card-bg);
    padding:16px 18px;
    border-radius:16px;
    margin:15px 0 20px;
    border:1px solid var(--border-light);
    box-shadow:0 8px 20px rgba(0,0,0,0.1);
    backdrop-filter:blur(6px);
}
.referral-text { 
    font-size:14px; 
    color:var(--text-dark); 
    flex:1; 
    margin-right:10px; 
    word-break:break-all;
}
.copy-btn {
    background: var(--gold-main);
    color:#fff;
    border:none;
    padding:10px 16px;
    border-radius:12px;
    font-weight:600;
    cursor:pointer;
    transition:0.3s;
}
.copy-btn:hover {
    background: var(--gold-light);
    box-shadow:0 0 12px var(--gold-light);
}

/* CONTENT */
.content-wrapper { padding:22px 15px 120px; }

/* STAT BOX */
.stats-box {
    background:#fff9e8;
    border-radius:20px;
    padding:24px;
    text-align:center;
    margin-bottom:18px;
    border:1px solid var(--border-light);
    box-shadow:0 5px 20px rgba(0,0,0,0.1);
}
.stats-box .stat-label { font-size:14px; color:var(--subtext); }
.stats-box .stat-value { font-size:26px; font-weight:700; color:var(--gold-main); }
.stats-box .sub-stats { 
    display:flex; 
    justify-content:space-around; 
    border-top:1px solid var(--border-light); 
    margin-top:12px; 
    padding-top:12px; 
}

/* LEVEL BOX */
.level-deposit-box {
    background:#fffefa;
    border-radius:16px;
    text-align:center;
    padding:16px;
    margin-bottom:18px;
    border:1px solid var(--border-light);
    box-shadow:0 5px 15px rgba(0,0,0,0.08);
}
.level-deposit-box h3 { 
    color: var(--gold-main); 
    font-size:16px; 
    margin-bottom:6px; 
    font-weight:600; 
}
.level-deposit-box p { 
    font-size:18px; 
    font-weight:700; 
    color:#6d520d;
}

/* TABS */
.team-tabs {
    display:flex;
    background:#fff2c7;
    border-radius:16px;
    padding:6px;
    margin-bottom:20px;
}
.tab-btn {
    flex:1;
    padding:12px;
    text-align:center;
    border:none;
    border-radius:12px;
    background:transparent;
    color:#8d7a3a;
    font-weight:600;
    cursor:pointer;
    transition:0.3s;
}
.tab-btn.active { 
    background:var(--gold-main); 
    color:#fff; 
    box-shadow:0 0 18px rgba(212,175,55,0.6);
}
.tab-content { display:none; }
.tab-content.active { display:block; }

/* USER CARDS */
.user-list { display:flex; flex-direction:column; gap:14px; }
.user-card {
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:16px;
    border-radius:16px;
    background:#ffffff;
    border:1px solid var(--border-light);
    box-shadow:0 5px 18px rgba(0,0,0,0.07);
}
.user-info .user-id { font-weight:700; font-size:16px; color:#333; }
.user-info .join-date, 
.user-info .team-deposit { font-size:13px; color:var(--subtext); }
.user-status { 
    font-size:14px; 
    font-weight:700; 
    color: var(--gold-main); 
}

/* NO RECORD */
.no-record {
    text-align:center;
    padding:40px 20px;
    background:#fff9e8;
    border-radius:16px;
    color:var(--subtext);
}

/* BOTTOM NAV */
.bottom-nav {
    position:fixed;
    bottom:0;
    left:50%;
    transform:translateX(-50%);
    width:100%;
    max-width:600px;
    background:linear-gradient(135deg,#fff0ca,#ffe395,#ffdb78);
    display:flex;
    justify-content:space-around;
    padding:12px 0;
    box-shadow:0 -2px 18px rgba(0,0,0,0.15);
    border-top:1px solid var(--border-light);
    border-radius:16px 16px 0 0;
}
.nav-item { 
    display:flex; 
    flex-direction:column; 
    align-items:center; 
    color:#8e7b3d; 
    cursor:pointer; 
}
.nav-item.active .nav-label { 
    color: var(--gold-main); 
    font-weight:600; 
}
.nav-item img { 
    width:28px; 
    height:28px; 
    margin-bottom:4px; 
}
.nav-label { font-size:12px; font-weight:600; }

</style>
</head>
<body>
<div class="main-container">

    <!-- HEADER -->
    <div class="header">
        <span class="" onclick="history.back()">‹</span>
        <h1 class="header-title">FD225WAT</h1>
    </div>

    <!-- CONTENT -->
    <div class="content-wrapper">
        <!-- STATISTIK TEAM -->
        <div class="stats-box">
            <div class="main-stat">
                <div class="stat-label">Deposit Tim</div>
                <div class="stat-value"><?php echo e(price($totalDeposit1 + $totalDeposit2 + $totalDeposit3)); ?></div>
            </div>
            <div class="sub-stats">
                <div class="stat-item">
                    <div class="stat-label">Total Asset</div>
                    <div class="stat-value"><?php echo e(price($totalCommission1 + $totalCommission2 + $totalCommission3)); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-label">Total Anggota Tim:</div>
                    <div class="stat-value"><?php echo e($team_size ?? 0); ?></div>
                </div>
            </div>
        </div>

        <!-- REFERRAL BOX -->
        <div class="referral-box">
            <div class="referral-text" id="referralLink"><?php echo e(url('register') . '?inviteCode=' . auth()->user()->ref_id); ?></div>
            <button class="copy-btn" onclick="copyReferral()">Salin <i class="fa fa-copy"></i></button>
        </div>

        <!-- TABS -->
        <div class="team-tabs">
            <button class="tab-btn active" onclick="switchTab(event, 'level-1')">1-level</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-2')">2-level</button>
            <button class="tab-btn" onclick="switchTab(event, 'level-3')">3-level</button>
        </div>

        <!-- LEVEL 1 -->
        <div id="level-1" class="tab-content active">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 1</h3>
                <p><?php echo e(price($totalDeposit1)); ?></p>
            </div>
            <?php if($first_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 2 -->
        <div id="level-2" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 2</h3>
                <p><?php echo e(price($totalDeposit2)); ?></p>
            </div>
            <?php if($second_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>

        <!-- LEVEL 3 -->
        <div id="level-3" class="tab-content">
            <div class="level-deposit-box">
                <h3>Total Deposit Level 3</h3>
                <p><?php echo e(price($totalDeposit3)); ?></p>
            </div>
            <?php if($third_level_users->count() > 0): ?>
                <div class="user-list">
                    <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="user-card">
                        <div class="user-info">
                            <div class="user-id"><?php echo e($user->username); ?></div>
                            <div class="team-deposit">Deposit Tim: <?php echo e(price($user->team_deposit ?? 0)); ?></div>
                            <div class="join-date">Bergabung: <?php echo e($user->created_at->format('d M, Y')); ?></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-record">Tidak ada data</div>
            <?php endif; ?>
        </div>
    </div>

    <!-- BOTTOM NAV -->
    <div class="bottom-nav">
      <div class="nav-item" onclick="window.location.href='/'">
        <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white" class="nav-icon">
        <div class="nav-label">Beranda</div>
      </div>
      <div class="nav-item" onclick="window.location.href='/my/vip'">
        <img src="https://api.iconify.design/solar:chart-bold.svg?color=white" class="nav-icon">
        <div class="nav-label">Investasi</div>
      </div>
      <div class="nav-item" onclick="window.location.href='/my-team'">
        <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white" class="nav-icon">
        <div class="nav-label">Tim</div>
      </div>
      <div class="nav-item active" onclick="window.location.href='/mine'">
        <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white" class="nav-icon">
        <div class="nav-label">Profil</div>
      </div>
    </div>

</div>

<script>
function switchTab(event, tabId) {
    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.getElementById(tabId).classList.add('active');
    event.currentTarget.classList.add('active');
}

function copyReferral() {
    const text = document.getElementById("referralLink").innerText;
    navigator.clipboard.writeText(text).then(() => {
        const btn = document.querySelector(".copy-btn");
        btn.innerHTML = "Disalin ✔";
        btn.style.background = "#20ff88";
        setTimeout(() => {
            btn.innerHTML = 'Salin <i class="fa fa-copy"></i>';
            btn.style.background = "var(--accent-color)";
        }, 2000);
    });
}
</script>
</body>
</html>
<?php /**PATH /home/speedeku/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>