<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover" />
    <title>Home</title>
    <style>
        :root {
            --gold: #f7c600;
            --gold-dark: #c49a00;
            --white: #ffffff;
            --soft-bg: #f9f9f9;
            --text-dark: #333;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--soft-bg);
            color: var(--text-dark);
            overflow-x: hidden;
            position: relative;
        }

        .main-container {
            max-width: 600px;
            margin: 0 auto;
            min-height: 100vh;
            background: white;
            border-radius: 20px;
            box-shadow: 0 0 20px rgba(0,0,0,0.08);
            position: relative;
            animation: fadeIn 1s ease-in-out;
            padding-bottom: 80px;
        }

        @keyframes fadeIn {
            from {opacity: 0; transform: translateY(10px);}
            to {opacity: 1; transform: translateY(0);}
        }

        .header {
            background: linear-gradient(135deg, #f7c600, #e3b100);
            color: #fff;
            padding: 15px 20px;
            text-align: center;
            font-weight: 600;
            font-size: 1.2rem;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            box-shadow: 0 0 15px rgba(247,198,0,0.4);
        }

        .desc-box {
            padding: 18px;
            margin: 15px;
            background: #ffffff;
            border-radius: 14px;
            border: 1px solid rgba(247,198,0,0.4);
            box-shadow: 0 0 12px rgba(247,198,0,0.25);
            text-align: center;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .desc-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--gold-dark);
            text-shadow: 0 0 4px rgba(247,198,0,0.5);
        }

        /* BOTTOM NAV GOLD */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 600px;
            background: #ffffff;
            border-top: 2px solid rgba(247,198,0,0.5);
            box-shadow: 0 -4px 15px rgba(0,0,0,0.08);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            z-index: 9999;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #555;
            font-size: 12px;
            transition: 0.3s;
        }

        .nav-icon { 
            font-size: 26px;
            margin-bottom: 4px; 
            color: var(--gold-dark);
        }

        .nav-item.active {
            font-weight: 600;
            color: var(--gold-dark);
        }

        /* POPUP WELCOME */
        .welcome-popup {
            position: fixed;
            top: 0; left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 10000;
            animation: fadeIn 0.5s ease-in-out;
        }

        .popup-content {
            background: var(--white);
            padding: 25px 20px;
            border-radius: 15px;
            max-width: 350px;
            width: 90%;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
            position: relative;
        }

        .popup-content h2 {
            color: var(--gold-dark);
            font-size: 20px;
            margin-bottom: 15px;
        }

        .popup-content p {
            font-size: 16px;
            margin-bottom: 20px;
        }

        .popup-buttons a {
            display: inline-block;
            margin: 5px 10px;
            padding: 10px 20px;
            background: var(--gold);
            color: var(--white);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: 0.3s;
        }

        .popup-buttons a:hover {
            background: var(--gold-dark);
        }

        .popup-close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 18px;
            font-weight: bold;
            color: #333;
            cursor: pointer;
        }

    </style>
</head>
<body>

<div class="main-container">

    <div class="header">Good World Time Investment</div>

    <!-- DESKRIPSI -->
    <div class="desc-box">
        <div class="desc-title">Good World Time Investment</div>
        <br>
        Good World Time adalah platform investasi global berbasis teknologi modern 
        yang menyediakan layanan cepat, aman, dan transparan. Dengan berbagai peluang 
        investasi yang stabil, kami membantu pengguna mencapai pertumbuhan finansial 
        jangka panjang secara efektif.
        <br><br>
        Misi kami adalah menciptakan ekosistem investasi terpercaya dan mudah diakses 
        bagi siapa pun di seluruh dunia.
        <br><br>
        <span style="color: var(--gold-dark); font-weight: 600;">
            Good World Time — Invest Your Future With Confidence.
        </span>
    </div>

</div> <!-- END main-container -->

<!-- BOTTOM NAV -->
<div class="bottom-nav">
    <div class="nav-item active" onclick="window.location.href='/'">
        <div class="nav-icon">🏠</div>
        <div class="nav-label">Home</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my/vip'">
        <div class="nav-icon">📦</div>
        <div class="nav-label">Investasi</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/my-team'">
        <div class="nav-icon">👥</div>
        <div class="nav-label">Team</div>
    </div>

    <div class="nav-item" onclick="window.location.href='/mine'">
        <div class="nav-icon">👤</div>
        <div class="nav-label">Profil</div>
    </div>
</div>

<!-- WELCOME POPUP -->
<div class="welcome-popup" id="welcomePopup">
    <div class="popup-content">
        <span class="popup-close" onclick="closePopup()">×</span>
        <h2>Selamat Datang</h2>
        <p>Senang melihatmu di Good World Time Investment. Hubungi kami melalui:</p>
        <div class="popup-buttons">
            <a href="https://wa.me/6281234567890" target="_blank">WhatsApp</a>
            <a href="https://t.me/username" target="_blank">Telegram</a>
        </div>
    </div>
</div>

<script>
    function closePopup() {
        document.getElementById('welcomePopup').style.display = 'none';
    }
</script>

</body>
</html>
<?php /**PATH /home/wfworlds/public_html/resources/views/app/main/index.blade.php ENDPATH**/ ?>