<!doctype html>
<html lang="en">
<head>
    <meta data-n-head="ssr" charset="utf-8">
    <meta data-n-head="ssr" name="viewport" content="width=device-width, initial-scale=1">
    <meta data-n-head="ssr" data-hid="description" name="description" content="<?php echo e(env('APP_NAME')); ?> APP">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('public/team.css')); ?>">

    <style>
        .lvmenu {
            font-size: 30px !important;
            font-style: italic;
            padding: 7px 0 !important;
        }
        .button[data-v-87511f80] {
            border-radius: 50px;
        }

        /* ========================= FOOTER BARU ========================= */

        .footer_menu {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #ffffff;
    padding: 10px 0 8px;
    border-top: 2px solid #00c853;
    box-shadow: 0 -4px 15px rgba(0, 200, 83, 0.2);
    z-index: 999;
}

.footer_menu .content {
    display: flex;
    justify-content: space-around;
    align-items: center;
}

.footer_menu .item {
    display: flex;
    flex-direction: column;
    align-items: center;
    font-size: 12px;
    color: #555;
    text-decoration: none;
    transition: 0.3s;
    opacity: 0.8;
}

.footer_menu .item img {
    width: 26px;
    height: 26px;
    margin-bottom: 2px;
    transition: 0.3s;
    filter: brightness(0.7);
}

.footer_menu .item.active {
    opacity: 1;
    color: #00c853;
    font-weight: 600;
}

.footer_menu .item.active img {
    transform: scale(1.12);
    filter: brightness(1.2) drop-shadow(0 0 6px #00c853);
}

.footer_menu .item:hover {
    opacity: 1;
    color: #00e676;
}

.footer_menu .item:hover img {
    filter: brightness(1) drop-shadow(0 0 4px #00e676);
}


        /* =============================================================== */
    </style>
</head>
<body>

<div id="__nuxt">
    <div id="__layout">
        <div>
            <section data-v-85a3c862="" class="team-page flex flex-col">

                <div data-v-c8cd6cfa="" data-v-85a3c862="" class="header-wrapper fixed w-full team-page-header">
                    <header data-v-c8cd6cfa="" class="header w-full relative flex items-center dark">
                        <div data-v-c8cd6cfa="" class="left absolute" onclick="window.location.href='<?php echo e(route('dashboard')); ?>'">
                            <svg data-v-c8cd6cfa="" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                 viewBox="0 0 24 24" fill="none">
                                <path data-v-c8cd6cfa=""
                                      d="M23 12C23 11.4477 22.5523 11 22 11L4.83 11L9.71 6.12C10.1017 5.72829 10.1006 5.09284 9.70749 4.70251C9.31635 4.31412 8.68476 4.31524 8.295 4.705L2.06667 10.9333C1.47756 11.5224 1.47756 12.4776 2.06667 13.0667L8.29468 19.2947C8.68422 19.6842 9.31578 19.6842 9.70532 19.2947C10.0946 18.9054 10.0949 18.2743 9.70595 17.8847L4.83 13L22 13C22.5523 13 23 12.5523 23 12Z"
                                      fill="currentColor"></path>
                            </svg>
                        </div>
                        <div data-v-c8cd6cfa="" class="title bold flex-1">My Team</div>
                    </header>
                </div>

                <div data-v-85a3c862="" class="team-page-content flex flex-col flex-1">

                    <div data-v-85a3c862="" class="team-page-tabs">
                        <div data-v-85a3c862="" class="team-page-tabs-values flex">
                            <div data-v-85a3c862="" data-key="0" class="lvmenu active" onclick="lvMenu(this, 'lv1')">LV1</div>
                            <div data-v-85a3c862="" data-key="1" class="lvmenu" onclick="lvMenu(this, 'lv2')">LV2</div>
                            <div data-v-85a3c862="" data-key="2" class="lvmenu" onclick="lvMenu(this, 'lv3')">LV3</div>
                        </div>

                        <div data-v-85a3c862="" class="team-page-tabs-details">
                            <div data-v-85a3c862="" class="team-page-tabs-tips">
                                If the friend you refer makes the first investment, you can get
                                <span data-v-85a3c862="">unlimited money</span>
                            </div>

                            <div data-v-85a3c862="" class="team-page-tabs-statistics flex items-center justify-between">
                                <div data-v-85a3c862="" class="flex flex-col items-center flex-1">
                                    <div data-v-85a3c862="" class="value bold teamsize"><?php echo e($first_level_users->count()); ?></div>
                                    <div data-v-85a3c862="" class="label">Team Size</div>
                                </div>

                                <div data-v-85a3c862="" class="flex flex-col items-center flex-1">
                                    <div data-v-85a3c862="" class="value bold totalDeposit"><?php echo e(price($totalDeposit1)); ?></div>
                                    <div data-v-85a3c862="" class="label">Total Deposit</div>
                                </div>

                                <div data-v-85a3c862="" class="flex flex-col items-center flex-1">
                                    <div data-v-85a3c862="" class="value bold totalDeposit"><?php echo e(price($totalWithdraw1 + $totalWithdraw2 + $totalWithdraw3)); ?></div>
                                    <div data-v-85a3c862="" class="label">Total Withdraw</div>
                                </div>
                            </div>

                            <button data-v-87511f80="" data-v-85a3c862="" type=""
                                    onclick="copyLink('<?php echo e(url('register').'?inviteCode='.auth()->user()->ref_id); ?>')"
                                    class="w-full button flex items-center justify-center relative button-primary default">

                                <svg data-v-85a3c862="" data-v-87511f80="" xmlns="http://www.w3.org/2000/svg" width="21"
                                     height="20" viewBox="0 0 21 20" fill="none">
                                    <path data-v-85a3c862="" data-v-87511f80="" fill="white"></path>
                                </svg>
                                Copy Link to Invite Friends
                            </button>
                        </div>
                    </div>

                    <div data-v-85a3c862="" class="team-page-content-details lv1Record">
                        <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $deposit = \App\Models\Deposit::where('user_id', $element->id)->where('status', 'approved')->first();
                            ?>
                            <div data-v-85a3c862="" class="team-page-content-details-item flex items-center justify-between">
                                <div data-v-85a3c862="">
                                    <div data-v-85a3c862="" class="cid">ID: <?php echo e($element->ref_id); ?></div>
                                    <div data-v-85a3c862="" class="date"><?php echo e($element->created_at); ?></div>
                                </div>
                                <div data-v-85a3c862="" class="status"
                                     style="<?php if($deposit): ?> color:green;border: 1px solid green; <?php else: ?> color:red;border: 1px solid red; <?php endif; ?>">
                                    <?php if($deposit): ?> Active <?php else: ?> In-Active <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div data-v-85a3c862="" style="display: none;" class="team-page-content-details lv2Record">
                        <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $deposit = \App\Models\Deposit::where('user_id', $element->id)->where('status', 'approved')->first();
                            ?>
                            <div data-v-85a3c862="" class="team-page-content-details-item flex items-center justify-between">
                                <div data-v-85a3c862="">
                                    <div data-v-85a3c862="" class="cid">ID: <?php echo e($element->ref_id); ?></div>
                                    <div data-v-85a3c862="" class="date"><?php echo e($element->created_at); ?></div>
                                </div>
                                <div data-v-85a3c862="" class="status"
                                     style="<?php if($deposit): ?> color:green;border: 1px solid green; <?php else: ?> color:red;border: 1px solid red; <?php endif; ?>">
                                    <?php if($deposit): ?> Active <?php else: ?> In-Active <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div data-v-85a3c862="" style="display: none;" class="team-page-content-details lv3Record">
                        <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $deposit = \App\Models\Deposit::where('user_id', $element->id)->where('status', 'approved')->first();
                            ?>
                            <div data-v-85a3c862="" class="team-page-content-details-item flex items-center justify-between">
                                <div data-v-85a3c862="">
                                    <div data-v-85a3c862="" class="cid">ID: <?php echo e($element->ref_id); ?></div>
                                    <div data-v-85a3c862="" class="date"><?php echo e($element->created_at); ?></div>
                                </div>
                                <div data-v-85a3c862="" class="status"
                                     style="<?php if($deposit): ?> color:green;border: 1px solid green; <?php else: ?> color:red;border: 1px solid red; <?php endif; ?>">
                                    <?php if($deposit): ?> Active <?php else: ?> In-Active <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
            </section>
        </div>
    </div>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    function copyLink(text) {
        const body = document.body;
        const input = document.createElement("input");
        body.append(input);
        input.style.opacity = 0;
        input.value = text.replaceAll(' ', '');
        input.select();
        input.setSelectionRange(0, input.value.length);
        document.execCommand("Copy");
        input.blur();
        input.remove();
        message('Copied success..')
    }
</script>

<script>
    var teamSizeOne = '<?php echo e($first_level_users->count()); ?>';
    var teamSizeTwo = '<?php echo e($second_level_users->count()); ?>';
    var teamSizeThree = '<?php echo e($third_level_users->count()); ?>';

    var lv1TotalDeposit = '<?php echo e(price($totalDeposit1)); ?>';
    var lv2TotalDeposit = '<?php echo e(price($totalDeposit2)); ?>';
    var lv3TotalDeposit = '<?php echo e(price($totalDeposit3)); ?>';

    function lvMenu(_this, lv){
        let lvmenus = document.querySelectorAll('.lvmenu');
        let lv1Record = document.querySelector('.lv1Record');
        let lv2Record = document.querySelector('.lv2Record');
        let lv3Record = document.querySelector('.lv3Record');

        let teamsize = document.querySelector('.teamsize');
        let totalDeposit = document.querySelector('.totalDeposit');

        for (let i=0; i<lvmenus.length; i++){
            lvmenus[i].classList.remove('active');
        }

        if (lv == 'lv1'){
            lv2Record.style.display = 'none';
            lv3Record.style.display = 'none';
            lv1Record.style.display = 'block';

            totalDeposit.innerHTML = lv1TotalDeposit;
            teamsize.innerHTML = teamSizeOne;
        }
        if (lv == 'lv2'){
            lv1Record.style.display = 'none';
            lv3Record.style.display = 'none';
            lv2Record.style.display = 'block';

            totalDeposit.innerHTML = lv2TotalDeposit;
            teamsize.innerHTML = teamSizeTwo;
        }
        if (lv == 'lv3'){
            lv1Record.style.display = 'none';
            lv2Record.style.display = 'none';
            lv3Record.style.display = 'block';

            totalDeposit.innerHTML = lv3TotalDeposit;
            teamsize.innerHTML = teamSizeThree;
        }

        _this.classList.add('active');
    }
</script>

<!-- ==================== FOOTER TAMPAK BARU & ELEGAN ==================== -->
<div class="footer_menu">
    <div class="content">
        <a href="/" class="item <?php echo e(request()->is('/') ? 'active' : ''); ?>">
            <img src="/public/site/img/footer/home_active.png" />
            <p>Home</p>
        </a>

        <a href="/vip" class="item <?php echo e(request()->is('vip') ? 'active' : ''); ?>">
            <img src="/public/site/img/footer/invest.png" />
            <p>Invest</p>
        </a>

        <a href="/my-team" class="item <?php echo e(request()->is('my-team') ? 'active' : ''); ?>">
            <img src="/public/site/img/footer/notice.png" />
            <p>Team</p>
        </a>

        <a href="/mine" class="item <?php echo e(request()->is('mine') ? 'active' : ''); ?>">
            <img src="/public/site/img/footer/account.png" />
            <p>Account</p>
        </a>
    </div>
</div>
<!-- ===================================================================== -->

</body>
</html>
<?php /**PATH /home/finewatt/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>