<!DOCTYPE html>   
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
  <title>Penarikan</title>

  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
/* ===============================
   ROOT – TEMA HITAM & MAROON FULL
================================ */
:root {
  --primary-color: #7F1D1D;          /* maroon utama */
  --primary-dark: #450A0A;           /* maroon gelap */
  --accent-color: #FCA5A5;           /* maroon terang */
  --text-dark: #F8FAFC;              /* teks utama */
  --text-light: #E5E7EB;             /* teks sekunder */
  --card-bg: rgba(10, 10, 10, 0.85); /* card hitam transparan */
  --border-color: rgba(127,29,29,0.45);
  --overlay: rgba(0, 0, 0, 0.85);    /* overlay foto */
}

/* RESET */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

/* ===============================
   BODY – BACKGROUND FOTO FULL
================================ */
body {
  font-family: 'Poppins', sans-serif;
  color: var(--text-dark);
  width: 100%;
  min-height: 100vh;
  background:
    linear-gradient(var(--overlay), var(--overlay)),
    url("bg.jpg") no-repeat center center fixed;
  background-size: cover;
}

/* ===============================
   MAIN CONTAINER
================================ */
.main-container {
  width: 100%;
  max-width: 600px;
  margin: auto;
  padding-bottom: 90px;
  background: transparent;
}

/* ===============================
   HEADER
================================ */
.header {
  background: linear-gradient(135deg, #7F1D1D, #450A0A);
  padding: 15px 20px;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  box-shadow: 0 10px 35px rgba(0,0,0,0.85);
  border-radius: 0 0 18px 18px;
  backdrop-filter: blur(12px);
}

.header .back-btn {
  position: absolute;
  left: 20px;
  font-size: 26px;
  color: var(--text-dark);
  cursor: pointer;
  font-weight: bold;
  transition: transform .25s;
}

.header .back-btn:hover {
  transform: scale(1.2);
}

.header-title {
  font-size: 1.35rem;
  font-weight: 800;
  color: var(--text-dark);
}

/* ===============================
   CONTENT
================================ */
.content-wrapper {
  padding: 20px 15px;
}

/* ===============================
   CARD
================================ */
.card {
  background: var(--card-bg);
  border: 1px solid var(--border-color);
  box-shadow: 0 12px 40px rgba(0,0,0,0.9);
  border-radius: 18px;
  padding: 20px;
  margin-bottom: 20px;
  backdrop-filter: blur(18px);
}

/* ===============================
   SALDO
================================ */
.balance-label {
  font-size: 14px;
  color: var(--text-light);
}

.balance-amount {
  font-size: 34px;
  font-weight: 800;
  color: var(--accent-color);
  margin-top: 5px;
  text-shadow: 0 0 14px rgba(127,29,29,0.8);
}

/* ===============================
   BANK INFO
================================ */
.bank-card-display .card-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 15px;
}

.card-title {
  font-size: 16px;
  font-weight: 700;
  color: var(--text-dark);
}

.edit-btn {
  background: linear-gradient(135deg, #7F1D1D, #450A0A);
  border: none;
  padding: 6px 14px;
  border-radius: 10px;
  color: var(--text-dark);
  font-weight: 700;
  font-size: 13px;
  cursor: pointer;
  transition: .25s;
}

.edit-btn:hover {
  box-shadow: 0 0 18px rgba(127,29,29,0.8);
}

/* INFO ROW */
.info-row {
  display: flex;
  justify-content: space-between;
  padding: 7px 0;
  font-size: 14px;
  color: var(--text-dark);
}

.info-row .label {
  color: var(--text-light);
}

/* ===============================
   INPUT
================================ */
.form-label {
  display: block;
  font-size: 14px;
  font-weight: 600;
  margin-bottom: 6px;
  color: var(--accent-color);
}

.form-control {
  width: 100%;
  height: 48px;
  border-radius: 12px;
  padding: 0 15px;
  border: 1px solid var(--border-color);
  background: rgba(5, 5, 5, 0.9);
  font-size: 16px;
  color: var(--text-dark);
  font-weight: 600;
  transition: .3s;
}

.form-control:focus {
  outline: none;
  border-color: var(--accent-color);
  box-shadow: 0 0 16px rgba(127,29,29,0.8);
}

/* ===============================
   NOMINAL BUTTON
================================ */
.amount-options {
  display: grid;
  grid-template-columns: repeat(2, 1fr);
  gap: 10px;
  margin-top: 14px;
}

.amount-btn {
  padding: 12px 10px;
  background: rgba(5, 5, 5, 0.9);
  border: 1px solid var(--border-color);
  border-radius: 14px;
  font-weight: 700;
  cursor: pointer;
  font-size: 15px;
  transition: .25s;
  color: var(--text-dark);
}

.amount-btn:hover,
.amount-btn.active {
  background: linear-gradient(135deg, #7F1D1D, #450A0A);
  border-color: var(--accent-color);
  box-shadow: 0 10px 30px rgba(127,29,29,0.85);
  transform: translateY(-2px);
}

/* ===============================
   SUBMIT BUTTON
================================ */
.submit-btn {
  width: 100%;
  background: linear-gradient(135deg, #7F1D1D, #450A0A);
  border: none;
  border-radius: 14px;
  padding: 15px;
  font-size: 16px;
  font-weight: 800;
  margin-top: 15px;
  cursor: pointer;
  transition: .3s;
  color: var(--text-dark);
  box-shadow: 0 12px 35px rgba(127,29,29,0.7);
}

.submit-btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 18px 55px rgba(127,29,29,0.95);
}

/* ===============================
   INFO
================================ */
.info-section {
  font-size: 14px;
  color: var(--text-dark);
  line-height: 1.6;
}

.highlight {
  background: rgba(15, 5, 5, 0.95);
  border-left: 4px solid var(--accent-color);
  padding: 12px;
  border-radius: 12px;
  margin: 10px 0;
}


  </style>
</head>
<body>

<div class="main-container">

  <!-- HEADER -->
  <div class="header">
    <span class="back-btn" onclick="history.back()">‹</span>
    <h1 class="header-title">Penarikan</h1>
  </div>

  <div class="content-wrapper">

    <!-- SALDO -->
    <div class="card balance-card">
      <div class="balance-label">Saldo Tersedia</div>
      <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>

    <?php if(auth()->user()->gateway_number && auth()->user()->gateway_method): ?>

      <!-- BANK -->
      <div class="card bank-card-display">
        <div class="card-header">
          <span class="card-title">Penarikan ke Rekening Bank</span>
          <button class="edit-btn" onclick="window.location.href='/add/card'">
            ✏️ Ubah
          </button>
        </div>

        <div class="bank-info">
          <div class="info-row">
            <span class="label">Nama Bank</span>
            <span><?php echo e($method->name ?? 'N/A'); ?></span>
          </div>
          <div class="info-row">
            <span class="label">Nama Pemilik</span>
            <span><?php echo e(auth()->user()->holder_name); ?></span>
          </div>
          <div class="info-row">
            <span class="label">No Rekening</span>
            <span><?php echo e(auth()->user()->gateway_number); ?></span>
          </div>
        </div>
      </div>

      <!-- FORM -->
      <div class="card withdraw-form">
        <form action="<?php echo e(route('user.withdraw-confirm-submit')); ?>" method="POST">
          <?php echo csrf_field(); ?>

          <label class="form-label">Jumlah Penarikan</label>

          <!-- INPUT (BISA DIKETIK) -->
          <input
            id="withdrawAmount"
            type="text"
            class="form-control"
            placeholder="Masukkan nominal (Rp)"
            autocomplete="off"
            required
          >

          <!-- INPUT ASLI UNTUK SUBMIT -->
          <input type="hidden" name="amount" id="amountValue">

          <!-- INFO HITUNG -->
          <div class="info-section" style="margin-top:15px">
            <p>Biaya Admin (10%): <strong id="fee">Rp 0</strong></p>
            <p>Diterima: <strong id="receive">Rp 0</strong></p>
          </div>

          <button type="submit" class="submit-btn">Konfirmasi Penarikan</button>
        </form>
      </div>

    <?php else: ?>
      <div class="card">
        <p>Anda belum menambahkan kartu bank.</p>
        <a href="/add/card" class="submit-btn" style="display:block;text-align:center;margin-top:15px;">Tambah Kartu Bank</a>
      </div>
    <?php endif; ?>
 <!-- INFORMASI -->
    <div class="card info-section">
      <h4>⚠️ Informasi Penting</h4>

      <div class="highlight">Pastikan data rekening benar.</div>

      <p>1. Minimal penarikan: <strong>Rp 20.000</strong></p>
      <p>2. Maksimal penarikan: <strong>Rp 20.000.000</strong></p>
      <p>3. Biaya admin: <strong>10%</strong></p>
      <p>4. Jam layanan: <strong>10.00 – 18.00 WIB</strong></p>
      <p>5. Proses: <strong>1–24 Jam</strong></p>


  </div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<!-- ================= SCRIPT ================= -->
<script>
const inputDisplay = document.getElementById('withdrawAmount');
const inputReal = document.getElementById('amountValue');
const buttons = document.querySelectorAll('.amount-btn');
const feeText = document.getElementById('fee');
const receiveText = document.getElementById('receive');

function formatRupiah(num) {
  return 'Rp ' + num.toLocaleString('id-ID');
}

function updateCalc(amount) {
  if (!amount || amount < 30000) {
    feeText.innerText = 'Rp 0';
    receiveText.innerText = 'Rp 0';
    return;
  }
  const fee = Math.floor(amount * 0.1);
  const receive = amount - fee;

  feeText.innerText = formatRupiah(fee);
  receiveText.innerText = formatRupiah(receive);
}

/* Klik tombol cepat */
buttons.forEach(btn => {
  btn.addEventListener('click', () => {
    buttons.forEach(b => b.classList.remove('active'));
    btn.classList.add('active');

    const amount = parseInt(btn.dataset.amount);
    inputDisplay.value = formatRupiah(amount);
    inputReal.value = amount;
    updateCalc(amount);
  });
});

/* Ketik manual */
inputDisplay.addEventListener('input', () => {
  buttons.forEach(b => b.classList.remove('active'));

  let raw = inputDisplay.value.replace(/\D/g,'');
  raw = Math.min(raw, 10000000);

  inputReal.value = raw;
  inputDisplay.value = raw ? formatRupiah(parseInt(raw)) : '';
  updateCalc(parseInt(raw));
});
</script>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>