<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
<title>mine</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-green: #66cc88;
    --soft-green: #a8e6b0;
    --white: #ffffff;
    --text-dark: #222;
    --subtext: #555;
    --card-shadow: rgba(102, 204, 136, 0.2);
}

* { margin: 0; padding: 0; box-sizing: border-box; }
html, body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(180deg, #ffffff, #e9f8ee);
    color: var(--text-dark);
    min-height: 100vh;
    overflow-x: hidden;
}

.main-container {
    max-width: 600px;
    margin: 0 auto;
    min-height: 100vh;
    position: relative;
    padding-bottom: 100px;
}

/* HEADER */
.header {
    background: linear-gradient(135deg, #5fbf7b, #66cc88);
    padding: 18px 15px;
    text-align: center;
    position: relative;
    box-shadow: 0 3px 10px rgba(102, 204, 136, 0.4);
    border-bottom: 1px solid rgba(255,255,255,0.3);
}
.header .back-btn {
    position: absolute;
    left: 20px;
    top: 16px;
    font-size: 26px;
    color: var(--white);
    cursor: pointer;
    font-weight: bold;
    transition: transform 0.3s ease;
}
.header .back-btn:hover { transform: scale(1.2); }
.header .header-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--white);
}

/* CONTENT */
.content-wrapper {
    padding: 20px 15px 100px;
}

/* USER INFO */
.user-info-bar {
    display: flex;
    align-items: center;
    margin-bottom: 25px;
}
.user-info-bar .logo {
    width: 55px;
    height: 55px;
    border-radius: 12px;
    margin-right: 15px;
    border: 2px solid #66cc88;
    box-shadow: 0 0 8px rgba(102,204,136,0.3);
    object-fit: cover;
}
.user-info-bar .user-id {
    font-size: 15px;
    font-weight: 600;
    color: var(--text-dark);
}

/* BALANCE CARD */
.balance-card {
    background: #ffffff;
    border-radius: 18px;
    padding: 16px 20px;
    color: var(--text-dark);
    border: 1px solid rgba(102,204,136,0.3);
    box-shadow: 0 6px 15px var(--card-shadow);
    margin-bottom: 22px;
    text-align: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.balance-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 0 20px rgba(102,204,136,0.25);
}
.balance-card .balance-header {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 8px;
}
.balance-card .balance-label {
    font-size: 15px;
    color: var(--subtext);
    font-weight: 600;
}
.balance-card .balance-icon {
    width: 24px;
    height: 24px;
    filter: drop-shadow(0 0 5px rgba(102,204,136,0.4));
}
.balance-card .balance-amount {
    font-size: 26px;
    font-weight: 700;
    color: #28a745;
    margin: 10px 0;
}
.balance-card .sub-stats {
    display: flex;
    justify-content: space-between;
    font-size: 13px;
    color: var(--subtext);
}

/* ACTION BUTTONS */
.action-buttons {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    margin-bottom: 25px;
}
.action-btn {
    background: #f9fdf9;
    border: 1px solid rgba(102,204,136,0.3);
    border-radius: 14px;
    width: 50%;
    padding: 12px 5px;
    text-align: center;
    color: #333;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 10px rgba(102,204,136,0.15);
}
.action-btn:hover {
    background: #e8fbe9;
    transform: translateY(-3px);
    box-shadow: 0 0 15px rgba(102,204,136,0.3);
}
.action-btn img {
    width: 32px;
    height: 32px;
    margin-bottom: 6px;
    filter: drop-shadow(0 0 4px rgba(102,204,136,0.5));
}

/* SERVICE MENU */
.service-menu .menu-title {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 12px;
    color: #333;
}
.service-menu .menu-list {
    background: #ffffff;
    border-radius: 16px;
    padding: 10px;
    box-shadow: 0 3px 10px rgba(102,204,136,0.15);
    border: 1px solid rgba(102,204,136,0.2);
}
.menu-item {
    display: flex;
    align-items: center;
    padding: 12px;
    border-radius: 12px;
    transition: all 0.3s ease;
    margin-bottom: 8px;
    background: #f9fdf9;
}
.menu-item:hover {
    background: #e8fbe9;
    transform: translateY(-2px);
    box-shadow: 0 0 12px rgba(102,204,136,0.2);
}
.menu-item .menu-icon {
    width: 26px;
    height: 26px;
    margin-right: 12px;
    filter: drop-shadow(0 0 4px rgba(102,204,136,0.4));
}
.menu-item .menu-text {
    flex-grow: 1;
    font-size: 14px;
    font-weight: 500;
    color: #333;
}
.menu-item .menu-arrow {
    color: var(--subtext);
    font-size: 12px;
}

/* NAVBAR BAWAH */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 100%;
    max-width: 600px;
    background: linear-gradient(135deg, #66cc88, #5fbf7b);
    display: flex;
    justify-content: space-around;
    padding: 8px 0;
    box-shadow: 0 -2px 15px rgba(102,204,136,0.4);
    z-index: 1000;
    border-top: 1px solid rgba(255,255,255,0.15);
}
.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: #e9f9ec;
    text-decoration: none;
    transition: all 0.3s ease;
}
.nav-item.active .nav-label {
    color: #ffffff;
    font-weight: 600;
}
.nav-item img {
    width: 25px;
    height: 25px;
    margin-bottom: 3px;
    filter: brightness(1.8);
    transition: transform 0.3s ease;
}
.nav-item:hover img {
    transform: scale(1.1);
}
.nav-label {
    font-size: 11px;
}
</style>
</head>
<body>

<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">MNC TRADE SYARIAH</h1>
    </div>

    <div class="content-wrapper">
        <div class="user-info-bar">
            <img src="AAS.png" alt="Logo" class="logo">
            <div class="user-id">ID : <?php echo e(auth()->user()->phone); ?></div>
        </div>

        <div class="balance-card">
            <div class="balance-header">
                <div class="balance-label">Saldo Akun</div>
                <img src="https://api.iconify.design/solar:wallet-linear.svg?color=%2366cc88" class="balance-icon" alt="Saldo">
            </div>
            <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
            <div class="sub-stats"> 
                <span>Penarikan: <?php echo e(price($approvedWithdraw ?? 0)); ?></span>
                <span>Deposit: <?php echo e(price($approvedDeposit ?? 0)); ?></span>
            </div>
        </div>

        <div class="action-buttons">
            <div class="action-btn" onclick="window.location.href='/user/recharge'">
                <img src="https://api.iconify.design/solar:wallet-bold.svg?color=%2366cc88" alt="Isi Ulang">
                <div>Isi Ulang</div>
            </div>
            <div class="action-btn" onclick="window.location.href='/withdraw'">
                <img src="https://api.iconify.design/solar:money-bag-bold.svg?color=%2366cc88" alt="Penarikan">
                <div>Penarikan</div>
            </div>
        </div>

        <div class="service-menu">
            <div class="menu-title">Layanan Saya</div>
            <div class="menu-list">
                <a href="/history" class="menu-item">
                    <img src="https://api.iconify.design/mdi:clipboard-text-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Catatan Akun</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/my/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:crown-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Produk Saya</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/invite" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-multiple-plus-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Undang & Informasi Tim</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/vip" class="menu-item">
                    <img src="https://api.iconify.design/mdi:account-tie-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Gaji Agen</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/add/card" class="menu-item">
                    <img src="https://api.iconify.design/mdi:credit-card-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Kartu Bank</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/about-us" class="menu-item">
                    <img src="https://api.iconify.design/mdi:office-building-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Tentang Kami</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="S" class="menu-item">
                    <img src="https://api.iconify.design/mdi:download-circle-outline.svg?color=%2366cc88" class="menu-icon">
                    <span class="menu-text">Download Aplikasi</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
                <a href="/logout" class="menu-item">
                    <img src="https://api.iconify.design/mdi:logout-variant.svg?color=%23ff5c5c" class="menu-icon">
                    <span class="menu-text" style="color:#ff5c5c;">Keluar</span>
                    <i class="fas fa-chevron-right menu-arrow"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- NAVBAR BAWAH -->
    <div class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='/'">
            <img src="https://api.iconify.design/solar:home-2-bold.svg?color=white">
            <div class="nav-label">Home</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my/vip'">
            <img src="https://api.iconify.design/solar:chart-bold.svg?color=white">
            <div class="nav-label">Investasi</div>
        </div>
        <div class="nav-item" onclick="window.location.href='/my-team'">
            <img src="https://api.iconify.design/solar:users-group-rounded-bold.svg?color=white">
            <div class="nav-label">Team</div>
        </div>
        <div class="nav-item active" onclick="window.location.href='/mine'">
            <img src="https://api.iconify.design/solar:user-circle-bold.svg?color=white">
            <div class="nav-label">Profil</div>
        </div>
    </div>
</div>
</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>