<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<title>Gaji Agen VIP</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
    --primary-green: #198754;        /* hijau lembut elegan */
    --accent-green: #3cb371;         /* hijau pastel alami */
    --light-bg: #f8f9fa;             /* putih lembut */
    --card-bg: #ffffff;              /* putih bersih */
    --text-dark: #1f2937;            /* teks utama */
    --subtext: #4b5563;              /* teks sekunder */
}

/* Reset */
* { margin: 0; padding: 0; box-sizing: border-box; }

body {
    font-family: 'Poppins', sans-serif;
    background: var(--light-bg);
    color: var(--text-dark);
    min-height: 100vh;
}

/* HEADER */
.header { 
    background: linear-gradient(135deg, var(--primary-green), #2e8b57);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    border-bottom-left-radius: 15px;
    border-bottom-right-radius: 15px;
}
.header .back-btn {
    position: absolute;
    left: 20px;
    font-size: 26px;
    color: #fff;
    cursor: pointer;
    font-weight: bold;
}
.header .header-title {
    font-size: 1.2rem;
    font-weight: 600;
    color: #fff;
}

/* KONTEN */
.content-wrapper { 
    padding: 25px 15px 80px; 
}

/* KARTU UTAMA */
.salary-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    animation: fadeInUp 0.8s ease both;
    position: relative;
    border: 1px solid rgba(25,135,84,0.15);
}

/* Ikon */
.salary-icon {
    font-size: 50px;
    color: var(--accent-green);
    margin-bottom: 15px;
    text-align: center;
    animation: pulse 2s infinite ease-in-out;
}

/* TEKS BRAND */
.brand-glow {
    text-align: center;
    font-size: 1.2rem;
    font-weight: 700;
    letter-spacing: 1.5px;
    margin: 10px 0 5px;
    background: linear-gradient(90deg, var(--primary-green), #3cb371, var(--primary-green));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* TABEL */
.salary-table {
    width: 100%;
    margin-top: 20px;
    border-collapse: collapse;
    border-radius: 10px;
    overflow: hidden;
    background: rgba(25,135,84,0.03);
}
.salary-table th, .salary-table td {
    padding: 12px 10px;
    text-align: center;
    border-bottom: 1px solid rgba(0,0,0,0.05);
}
.salary-table th {
    background: rgba(25,135,84,0.15);
    color: #0f5132;
    font-weight: 600;
}
.salary-table td {
    color: var(--subtext);
    font-weight: 500;
}
.salary-table tr:hover {
    background: rgba(25,135,84,0.07);
}

/* DESKRIPSI */
.salary-desc {
    font-size: 1rem;
    line-height: 1.7;
    text-align: justify;
    color: var(--text-dark);
}

/* INFO TAMBAHAN */
.info-box {
    background: rgba(25,135,84,0.08);
    border-left: 4px solid var(--accent-green);
    border-radius: 10px;
    padding: 12px 15px;
    margin-top: 20px;
    color: var(--subtext);
    font-style: italic;
    text-align: center;
}

/* TOMBOL HUBUNGI MANAJER */
.contact-manager {
    text-align: center;
    margin-top: 25px;
}
.contact-btn {
    display: inline-flex;
    align-items: center;
    background: linear-gradient(135deg, var(--primary-green), #3cb371);
    color: #fff;
    font-weight: 600;
    border: none;
    border-radius: 12px;
    padding: 12px 24px;
    font-size: 16px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 10px rgba(25,135,84,0.25);
}
.contact-btn i {
    margin-right: 8px;
    font-size: 18px;
}
.contact-btn:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 18px rgba(25,135,84,0.35);
}

/* ANIMASI */
@keyframes fadeInUp {
    from {opacity: 0; transform: translateY(20px);}
    to {opacity: 1; transform: translateY(0);}
}
@keyframes pulse {
    0%, 100% {transform: scale(1); opacity: 1;}
    50% {transform: scale(1.15); opacity: 0.8;}
}
</style>
</head>

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()">‹</span>
        <h1 class="header-title">Informasi Gaji Agen</h1>
    </div>

    <div class="content-wrapper">
        <div class="salary-card">
            <div class="salary-icon"><i class="fas fa-hand-holding-usd"></i></div>
            <div class="brand-glow">MNC TRADE SYARIAH</div>

            <h2 class="salary-title" style="text-align:center; color:#198754; margin-bottom:10px;">Program Gaji Agen</h2>
            
            <p class="salary-desc">
                MNC TRADE SYARIAH memberikan penghargaan kepada setiap agen aktif dengan sistem gaji mingguan berdasarkan jumlah <strong>anggota aktif di Level 1</strong>.
                Gaji dihitung otomatis dari jumlah anggota aktif dan <strong>dibayarkan setiap hari Senin</strong> pada minggu berikutnya.
                Semakin banyak anggota aktif, semakin besar penghasilan mingguan Anda.
            </p>

            <table class="salary-table">
                <thead>
                    <tr>
                        <th>Jumlah Anggota Aktif (Level 1)</th>
                        <th>Gaji Mingguan</th>
                    </tr>
                </thead>
                <tbody>
                    <tr><td>10 Anggota</td><td>Rp 35.000</td></tr>
                    <tr><td>15 Anggota</td><td>Rp 50.000</td></tr>
                    <tr><td>25 Anggota</td><td>Rp 125.000</td></tr>
                    <tr><td>35 Anggota</td><td>Rp 200.000</td></tr>
                    <tr><td>50 Anggota</td><td>Rp 450.000</td></tr>
                </tbody>
            </table>

            <div class="info-box">
                💡 <strong>Catatan:</strong> Gaji dihitung hanya dari anggota aktif di <strong>Level 1</strong> dan dibayarkan otomatis setiap <strong>hari Senin</strong>.
            </div>

            <div class="contact-manager">
                <button class="contact-btn" onclick="window.location.href='telegram'">
                    <i class="fas fa-headset"></i> Hubungi Manajer
                </button>
                <p style="color:var(--subtext); font-size:13px; margin-top:8px;">
                    Hubungi manajer Anda untuk mengonfirmasi dan menerima gaji mingguan.
                </p>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<?php /**PATH /home/mnctrade/public_html/resources/views/app/main/vip.blade.php ENDPATH**/ ?>