<!DOCTYPE html>    
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <title>Tentang Kami</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
:root {
  --primary-color: #7f1d1d;        /* maroon utama */
  --accent-color: #991b1b;         /* maroon terang */
  --deep-maroon: #450a0a;          /* maroon gelap */
  --background-color: #020202;     /* hitam full */
  --text-color: #f8fafc;           /* putih lembut */
  --text-muted: #9ca3af;           /* abu */
  --card-bg: rgba(8,8,8,0.85);     /* hitam kaca */
}

/* RESET */
* { margin: 0; padding: 0; box-sizing: border-box; }

/* BACKGROUND */
html, body {
  background:
    linear-gradient(
      rgba(2,2,2,0.92),
      rgba(2,2,2,0.98)
    ),
    url("logoa.jpg") center / cover no-repeat fixed;
  width: 100%;
  overflow-x: hidden;
}

body {
  font-family: 'Poppins', sans-serif;
  color: var(--text-color);
  -webkit-font-smoothing: antialiased;
}

/* MAIN */
.main-container { 
  width: 100%;
  max-width: 600px; 
  margin: 0 auto;
  background: transparent;
  min-height: 100vh;
  position: relative;
}

/* HEADER */
.header { 
  background: linear-gradient(
    135deg,
    var(--primary-color),
    var(--deep-maroon)
  );
  padding: 15px 20px;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  box-shadow: 0 12px 40px rgba(127,29,29,0.55);
}

.header .back-btn {
  position: absolute;
  left: 20px;
  font-size: 26px;
  color: #fca5a5;
  cursor: pointer;
  font-weight: bold;
}

.header .header-title {
  font-size: 1.25rem;
  font-weight: 600;
  color: #fee2e2;
}

/* CONTENT */
.content-wrapper { 
  padding: 25px 15px 60px; 
}

/* MOVING TEXT BOX */
.animated-box {
  background: linear-gradient(
    135deg,
    rgba(127,29,29,0.25),
    rgba(69,10,10,0.45)
  );
  border: 1.5px solid rgba(127,29,29,0.5);
  border-radius: 16px;
  padding: 18px 25px;
  margin-bottom: 25px;
  text-align: center;
  box-shadow: 0 0 35px rgba(127,29,29,0.45);
  backdrop-filter: blur(14px);
}

/* RUNNING TEXT */
.animated-text {
  font-weight: 600;
  font-size: 1.05rem;
  background: linear-gradient(
    90deg,
    #450a0a,
    #f87171,
    #450a0a
  );
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  white-space: nowrap;
  animation: moveText 8s linear infinite;
}

@keyframes moveText {
  0% { transform: translateX(100%); }
  100% { transform: translateX(-100%); }
}

/* COMPANY CARD */
.company-card {
  background: var(--card-bg);
  border-radius: 18px;
  padding: 25px;
  box-shadow: 0 14px 45px rgba(0,0,0,0.7);
  transition: 0.35s ease;
  animation: fadeInUp 0.8s ease both;
  backdrop-filter: blur(18px);
  border: 1px solid rgba(127,29,29,0.35);
}

.company-card:hover { 
  transform: translateY(-6px);
  box-shadow: 0 22px 60px rgba(127,29,29,0.45);
}

/* IMAGE */
.company-image {
  width: 100%;
  height: 200px;
  border-radius: 14px;
  object-fit: cover;
  margin-bottom: 20px;
}

/* TEXT */
.company-title {
  font-size: 1.4rem;
  font-weight: 600;
  color: #f87171;
  margin-bottom: 12px;
}

.company-content {
  font-size: 1rem;
  line-height: 1.7;
  color: #d1d5db;
  text-align: justify;
}

/* ANIMATION */
@keyframes fadeInUp {
  from {opacity: 0; transform: translateY(20px);}
  to {opacity: 1; transform: translateY(0);}
}

</style>
</head>   

<body>
<div class="main-container">

    <div class="header">
        <span class="back-btn" onclick="history.back()"></span>
        <h1 class="header-title">Tentang Kami</h1>
    </div>

    <div class="content-wrapper">

        <!-- KOTAK TEKS BERGERAK -->
        <div class="animated-box">
            <div class="animated-text">taglichesgeld resmi dari ojk dan akan aman untuk jangka lama</div>
        </div>

        <!-- BAGIAN UTAMA -->
        <div class="company-card">
            <img src="Gemini_Generated_Image_jd5c1ejd5c1ejd5c.png" alt="Tentang Kami" class="company-image">
            <h2 class="company-title">taglichesgeld</h2>
            <p class="company-content">
                <strong>taglichesgeld</strong> adalah pionir dalam dunia <em>taglichesgeld</em> inovasi finansial masa depan yang menghubungkan kenyamanan kartu kredit dengan potensi investasi digital yang menguntungkan.  
                <br><br>
                Kami menghadirkan sistem investasi cerdas berbasis transaksi kartu kredit yang transparan, cepat, dan aman. Setiap transaksi bukan hanya pengeluaran, tetapi juga peluang untuk menumbuhkan nilai finansial Anda melalui portofolio investasi otomatis dan real-time.
                <br><br>
                Dengan dukungan teknologi <em>AI FinTech</em> dan jaringan global, kami berkomitmen menciptakan ekosistem keuangan yang dinamis — di mana pengguna dapat:
                <ul style="margin-left:20px; margin-top:10px;">
                    <li>Mengubah transaksi kartu kredit menjadi aset produktif.</li>
                    <li>Memperoleh imbal hasil kompetitif dari sistem investasi digital otomatis.</li>
                    <li>Menikmati pengalaman finansial tanpa batas dengan keamanan tingkat tinggi.</li>
                    <li>Mengakses analitik keuangan real-time untuk strategi investasi cerdas.</li>
                </ul>
                <br>
                <strong>Visi Kami:</strong> Menjadi jembatan utama antara dunia pembayaran dan investasi digital  menciptakan kebebasan finansial melalui inovasi berkelanjutan.  
                <br><br>
                <strong>Misi Kami:</strong> Memberdayakan setiap individu untuk berinvestasi lebih mudah, cepat, dan aman hanya dengan kartu kredit mereka.
                <br><br>
                <em>taglichesgeld</em> bukan sekadar platform  kami adalah revolusi baru dalam cara dunia mengelola uang, menumbuhkan peluang, dan membangun masa depan finansial yang lebih cerah.
            </p>
        </div>

    </div>
</div>

</body>
</html>
<?php /**PATH /home/nnmuetur/public_html/resources/views/app/main/about.blade.php ENDPATH**/ ?>