<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimal-ui, viewport-fit=cover">
<title>Mine</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --maroon-dark:#3B0A0A;
  --maroon-main:#7F1D1D;
  --maroon-soft:#991B1B;
  --maroon-border:#B91C1C;
  --maroon-accent:#FCA5A5;

  --black-main:#0B0B0B;
  --black-soft:#121212;
}

*{box-sizing:border-box}

body{
  margin:0;
  font-family:'Poppins',sans-serif;
  color:#F5F5F5;
  padding-bottom:90px;

 /* HITAM GRADIENT */
background:radial-gradient(circle at top, #1a1a1a 0%, #000000 70%);


/* WRAPPER */
.main-container{
  max-width:520px;
  margin:18px auto;
  padding:0 14px;
}

/* HEADER */
.header{
  background:rgba(20,10,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  border-radius:14px;
  padding:14px 18px;
  display:flex;
  align-items:center;
  gap:12px;
  margin-bottom:18px;
}
.back-btn{
  font-size:22px;
  cursor:pointer;
  font-weight:700;
  color:var(--maroon-accent);
}
.header-title{
  font-size:18px;
  font-weight:700;
  color:#FFE4E6;
}

/* PROFILE CARD */
.profile-balance-card{
  background:linear-gradient(135deg,rgba(30,10,10,.9),rgba(10,5,5,.88));
  border:1.5px solid var(--maroon-border);
  border-radius:18px;
  padding:18px;
  backdrop-filter:blur(14px);
  box-shadow:0 12px 35px rgba(0,0,0,.65);
  margin-bottom:22px;
}

.profile-top{
  display:flex;
  gap:14px;
  align-items:center;
  margin-bottom:18px;
}

.profile-avatar{
  width:64px;
  height:64px;
  border-radius:50%;
  border:2px solid var(--maroon-accent);
  object-fit:cover;
}

.profile-info{flex:1}

.profile-id{
  font-size:13px;
  color:#FECACA;
  font-weight:600;
}

.profile-label{
  font-size:13px;
  color:#FCA5A5;
  margin-top:4px;
}

.profile-balance{
  font-size:26px;
  font-weight:700;
  color:#FFFFFF;
  margin-top:2px;
}

/* STATS */
.profile-stats{
  display:flex;
  gap:12px;
}

.stat-box{
  flex:1;
  background:rgba(40,10,10,.85);
  border:1px solid var(--maroon-border);
  border-radius:14px;
  padding:12px;
  text-align:center;
}

.stat-label{
  font-size:12px;
  color:#FCA5A5;
}

.stat-value{
  font-size:14px;
  font-weight:700;
  color:#FFFFFF;
  margin-top:4px;
}

/* SUB STATS */
.sub-stats{
  display:flex;
  gap:10px;
}
.sub-stat{
  flex:1;
  background:rgba(40,10,10,.85);
  border:1px solid var(--maroon-border);
  padding:10px;
  border-radius:10px;
  text-align:center;
}
.label{
  font-size:12px;
  color:#FCA5A5;
}
.value{
  font-size:14px;
  font-weight:700;
  color:#FFFFFF;
}

/* MENU */
.action-buttons{
  display:flex;
  flex-direction:column;
  gap:14px;
  margin-bottom:20px;
}

.action-btn{
  display:flex;
  align-items:center;
  gap:14px;
  padding:14px 16px;
  border-radius:14px;
  background:rgba(20,10,10,.78);
  border:1.5px solid var(--maroon-border);
  backdrop-filter:blur(12px);
  cursor:pointer;
  transition:.25s;
}

.action-btn:hover{
  background:rgba(40,10,10,.9);
  transform:translateY(-2px);
}

.action-btn img{
  width:38px;
  filter:drop-shadow(0 0 6px rgba(185,28,28,.6));
}

.action-btn div{
  font-size:15px;
  font-weight:600;
  color:#FFE4E6;
}

/* LOGOUT */
.menu-item{
  display:flex;
  align-items:center;
  gap:12px;
  padding:14px;
  border-radius:14px;
  background:rgba(60,10,10,.85);
  border:1px solid #DC2626;
  text-decoration:none;
}

.menu-item img{
  width:36px;
}

.menu-text{
  font-size:15px;
  font-weight:700;
  color:#F87171;
}


</style>
</head>

<body>

<div class="main-container">

  <div class="profile-balance-card">

  <div class="profile-top">
    <img src="logoa.jpg" class="profile-avatar">
    <div class="profile-info">
      <div class="profile-id">ID : <?php echo e(auth()->user()->phone); ?></div>
      <div class="profile-label">Saldo Akun</div>
      <div class="profile-balance"><?php echo e(price(auth()->user()->balance)); ?></div>
    </div>
  </div>

  <div class="profile-stats">
    <div class="stat-box">
      <div class="stat-label">Total Penarikan</div>
      <div class="stat-value">
        <?php echo e(price(\App\Models\Withdrawal::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?>

      </div>
    </div>
    <div class="stat-box">
      <div class="stat-label">Total Deposit</div>
      <div class="stat-value">
        <?php echo e(price(\App\Models\Deposit::where('user_id', auth()->id())->where('status','approved')->sum('amount'))); ?>

      </div>
    </div>
  </div>

</div>

  <div class="action-buttons">
  
  <div class="action-btn" onclick="window.location.href='/promo'">
    <img src="https://api.iconify.design/solar:gift-bold-duotone.svg?color=%237F1D1D">
    <div>Hadiah</div>
  </div>

  <div class="action-btn" onclick="window.location.href='/history'">
    <img src="https://api.iconify.design/mdi:clipboard-text-outline.svg?color=%237F1D1D">
    <div>Catatan</div>
  </div>

  <div class="action-btn" onclick="location.href='/user/recharge'">
    <img src="https://api.iconify.design/solar:wallet-bold.svg?color=%237F1D1D">
    <div>Isi Ulang</div>
  </div>

  <div class="action-btn" onclick="location.href='/withdraw'">
    <img src="https://api.iconify.design/solar:money-bag-bold.svg?color=%237F1D1D">
    <div>Penarikan</div>
  </div>

  <div class="action-btn" onclick="location.href='/add/card'">
    <img src="https://api.iconify.design/mdi:credit-card-outline.svg?color=%237F1D1D">
    <div>Kartu Bank</div>
  </div>

  <div class="action-btn" onclick="location.href='/about-us'">
    <img src="https://api.iconify.design/mdi:office-building-outline.svg?color=%237F1D1D">
    <div>Tentang</div>
  </div>

</div>


  <a href="/logout" class="menu-item">
    <img src="https://api.iconify.design/mdi:logout-variant.svg?color=%23ff6b6b">
    <span class="menu-text">Keluar</span>
  </a>

</div>
<?php echo $__env->make('app.layout.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/wrkdpgna/public_html/resources/views/app/main/mine.blade.php ENDPATH**/ ?>